<?php

namespace MABEL_SI\Core\Common\Managers
{

	if (!defined('ABSPATH')) {
		die;
	}

	use stdClass;

	class License_Manager
	{
		private $api_url     = '';
		private $slug        = '';
		private $version     = '';
		private $wp_override = false;
		private $name        = '';
		private $key         = '';
		private $exp         = '';
		private $cached_plugin_update = null;

		public function __construct( $api_url, $plugin_base ) {

			$this->api_url     = trailingslashit( $api_url );
			$this->slug        = Config_Manager::$slug;
			$this->version     = Config_Manager::$version;
			$this->name        = $plugin_base;

			$this->init();
		}

		private function get_key() {
			if(empty($this->key)) {
				$raw = get_option('mabel-shoppable-images_license');
				if($raw === false)
					return false;
				$raw = json_decode(base64_decode($raw));
				if(empty($raw) || !is_string($raw->key) || strlen($raw->key) < 20 || strpos($raw->key,'-') === false)
					return false;

				$this->key = $raw->key;
				$this->exp = $raw->expiration;

				return $raw->key;
			}
			return $this->key;
		}

		public function init() {

			add_action( 'admin_post_' . 'mabel-shoppable-images-activate-license', array($this, 'activate_license'));
			add_action( 'admin_post_' . 'mabel-shoppable-images-deactivate-license', array($this, 'deactivate_license'));

			add_filter( 'pre_set_site_transient_update_plugins', array( $this, 'check_update' ) );
			add_filter( 'plugins_api', array( $this, 'plugins_api_filter' ), 10, 3 );
			add_action( 'in_plugin_update_message-' . $this->name, array( $this, 'in_plugin_update_message' ), 10, 2 );
			if(isset($_GET['force-check']) && $_GET['force-check'] === '1')
				$this->wp_override = true;

		}

		public function in_plugin_update_message($args, $response) {
			if(self::get_key() === false || empty( $response->package ))
				echo  '<br/>' . __('Updates are disabled because your license key is expired. To enable updates, please renew your license key.', 'mabel-shoppable-images');
			if(!empty($response->upgrade_notice))
				echo '<div style="padding:12px 0;border-top:1px solid #ffb900;"><strong>Upgrade warning! </strong>' . wp_kses_post($response->upgrade_notice) . '</div><p style="display: none">';
		}

		public static function get_license_info() {
			$raw = get_option(Config_Manager::$slug.'_license');
			return $raw === false ? null : json_decode(base64_decode($raw));
		}

		public function deactivate_license()
		{
			$key = $this->get_key();
			if($key !== false){
				$this->api_request('license/deactivate/'.$key.'/mabel-shoppable-images');
			}
			delete_option('mabel-shoppable-images_license');

			$notice = array(
				'class' => 'success',
				'message' => 'License deactivated.'
			);

			wp_redirect(admin_url('options-general.php?page=mabel-shoppable-images&notice='.base64_encode(serialize($notice))));
		}

		public function activate_license()
		{
			$key = $_REQUEST['mabel-shoppable-images-license'];

			$result = $this->api_request('license/activate/'.$key.'/mabel-shoppable-images');

			if($result === null){
				$notice = array(
					'class' => 'error',
					'message' => "Something went wrong. Can't connect to the license server."
				);
				//wp_redirect(admin_url("options-general.php?page=" . Config_Manager::$slug.'&notice=success&m='.__('Can not contact server',Config_Manager::$slug)));
				//exit;
			} else{
				if($result->status === 'passed') {
					update_option('mabel-shoppable-images_license', base64_encode(json_encode(
						array(
							'key' => $key,
							'expiration' => $result->expiration,
							'url' => home_url()
						)
					)));
					$notice = array(
						'class' => 'success',
						'message' => 'License activated.'
					);
				}else{
					$notice = array(
						'class' => 'error',
						'message' => $result->message
					);
				}
			}

			wp_redirect(admin_url('options-general.php?page=mabel-shoppable-images&notice='.base64_encode(serialize($notice))));
			exit;
		}

		public function plugins_api_filter( $_data, $_action = '', $_args = null ) {

			if ( $_action != 'plugin_information' ) {
				return $_data;
			}
			if ( ! isset( $_args->slug ) || ( $_args->slug != $this->slug ) ) {
				return $_data;
			}

			if ($this->get_key() === false)
				return $_data;

			$api_response = $this->api_request( 'plugin/info/'.$this->get_key().'/mabel-shoppable-images');

			if ( null !== $api_response ) {
				$_data = $api_response;
			}

			// Convert sections into an associative array, since we're getting an object, but core expects an array.
			if ( isset( $_data->sections ) && !is_array( $_data->sections ) ) {
				$new_sections = array();
				foreach ( $_data->sections as $key => $value ) {
					$new_sections[ $key ] = $value;
				}
				$_data->sections = $new_sections;
			}

			return $_data;
		}

		public function check_update( $_transient_data ) {
			global $pagenow;

			if ( ! is_object( $_transient_data ) ) {
				$_transient_data = new stdClass;
			}

			/*if ( 'plugins.php' == $pagenow && is_multisite() ) {
				return $_transient_data;
			}*/

			if ( ! empty( $_transient_data->response ) && ! empty( $_transient_data->response[ $this->name ] ) && false === $this->wp_override ) {
				return $_transient_data;
			}

			if($this->get_key() === false)
				return $_transient_data;

			if(empty($this->exp))
				return $_transient_data;

			// If plugin is expired 10 months or longer, don't run anymore
			$exp = \DateTime::createFromFormat("Y-m-d H:i:s",$this->exp);
			$now = new \DateTime('now');
			$exp = $exp->add(new \DateInterval('P10M'));
			if($exp < $now) return $_transient_data;

			// Cached because this filter is called twice in the same pageload
			if($this->cached_plugin_update != null)
				$version_info = $this->cached_plugin_update;
			else
				$version_info = $this->wp_override ? null : $this->get_cached_version_info();

			if ( null === $version_info) {
				$version_info = $this->api_request( 'plugin/update/'.$this->version.'/'.$this->get_key() . '/mabel-shoppable-images' );
				if(isset($version_info->icons))
					$version_info->icons = json_decode(json_encode($version_info->icons),true);
				$this->set_version_info_cache( $version_info );
				$this->cached_plugin_update = $version_info;
			}

			if ( null !== $version_info && is_object( $version_info ) && isset( $version_info->new_version ) && version_compare( $this->version, $version_info->new_version, '<' ) ) {

				$_transient_data->response[ $this->name ] = $version_info;
				$_transient_data->last_checked           = current_time( 'timestamp' );
				$_transient_data->checked[ $this->name ] = $this->version;

			}

			return $_transient_data;
		}

		public function get_cached_version_info( ) {

			$transient = get_transient('mabel-shoppable-images_version_info');
			if($transient === false)
				return null;

			$decoded = json_decode($transient);
			if(isset($decoded->icons))
				$decoded->icons = json_decode(json_encode($decoded->icons),true);

			return $decoded;
		}

		public function set_version_info_cache( $value ) {

			set_transient('mabel-shoppable-images_version_info', json_encode($value), HOUR_IN_SECONDS * 6 ); // Store for 6 hours.

		}

		private function api_request( $url ) {

			global $wp_version;

			$api_params = array(
				'wp_version'    => $wp_version,
				'url'           => home_url(),
				'is_ssl'        => is_ssl()
			);

			$data = array(
				'timeout' 	=> apply_filters('shoppable_images_license_timeout', 5),
				'body'		=> $api_params
			);

			$request = wp_remote_post( $this->api_url .$url, $data);

			$return = null;

			if ( is_wp_error( $request ) )
				return $return;

			if ( $request['response']['code'] == 200 )
			{
				$return = json_decode($request['body']);
			}

			return $return;
		}

	}
}