<?php
/**
 * Plugin Name: Wholesale For WooCommerce
 * Plugin URI: https://wpexperts.io/
 * Description: Wholesale for WooCommerce enables store owners to create and manage wholesale prices, multiple wholesale user roles, user registration forms, product and price visibility, tax, payment and shipping methods, and much more.
 * Version: 2.0.0
 * Author: wpexpertsio
 * Author URI: https://wpexperts.io/
 * Developer: wpexpertsio
 * Developer URI: https://wpexperts.io/
 * Text Domain: woocommerce-wholesale-pricing
 *
 * Woo: 4830851:fd98fab857870bb9b375e1e0ca9d003e
 * WC requires at least: 3.0
 * WC tested up to: 4.8.0
 *
 * Copyright: © 2009-2015 WooCommerce.
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}
if ( ! defined( 'WWP_PLUGIN_URL' ) ) {
	define( 'WWP_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}
if ( ! defined( 'WWP_PLUGIN_PATH' ) ) {
	define( 'WWP_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
}
if ( ! defined( 'WWP_PLUGIN_DIRECTORY_NAME' ) ) {
	define( 'WWP_PLUGIN_DIRECTORY_NAME', dirname( __FILE__ ) );
}
if ( ! class_exists( 'Wwp_Wholesale_Pricing' ) ) {

	class Wwp_Wholesale_Pricing {

		public function __construct() { 
			$plugin                 = 'woocommerce/woocommerce.php';
			$subsite_active_plugins = (array) get_option( 'active_plugins' );
			$network_active_plugins = (array) get_site_option( 'active_sitewide_plugins' );
			register_activation_hook( __FILE__, array( $this, 'wholesale_register_activation_hook' ) );
			if ( array_key_exists( $plugin, $network_active_plugins ) || in_array( $plugin, $subsite_active_plugins ) || class_exists( 'WooCommerce' ) ) {
				self::init();
			} else {
				add_action( 'admin_notices', array( __Class__, 'wholesale_admin_notice_error' ) );
			}
		}

		public function wholesale_register_activation_hook() {

			if ( get_option( 'wwp_save_form' ) == false ) {
				if ( get_option( 'wwp_wholesale_registration_options' ) ) {
					$registrations = get_option( 'wwp_wholesale_registration_options' );
					$type          = 'text';
					for ( $i = 1; $i < 6; $i++ ) {
	
						if ( isset( $registrations[ 'custom_field_' . $i ] ) && 'yes' == $registrations[ 'custom_field_' . $i ] ) {
	
							if ( isset( $registrations[ 'woo_custom_field_' . $i ] ) ) {
								$field_name = $registrations[ 'woo_custom_field_' . $i ];
							} else {
								$field_name = esc_html__( 'Custom Field ' . $i, 'woocommerce-wholesale-pricing' );
							}
	
							if ( isset( $registrations[ 'required_field_' . $i ] ) && 'yes' == $registrations[ 'required_field_' . $i ] ) {
								$required = true;
							} else {
								$required = false;
							}
							if ( '5' == $i ) {
								$type = esc_html__( 'textarea', 'woocommerce-wholesale-pricing' );
							}
	
								$fields[] = array(
									'type'      => $type,
									'required'  => $required,
									'label'     => $field_name,
									'className' => 'form-control',
									'name'      => 'text-159670154749' . $i,
									'value'     => '',
									'subtype'   => 'text',
								);
						}
					}
					$fields                                       = json_encode( $fields );
					$registrations['display_fields_registration'] = 'yes';
					update_option( 'wwp_save_form', $fields );
					update_option( 'wwp_wholesale_registration_options', $registrations );
				}
			}
		}

		public static function init() {
			if ( function_exists( 'load_plugin_textdomain' ) ) {
				load_plugin_textdomain( 'woocommerce-wholesale-pricing', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
			} 
			if ( get_option( 'wwp_wholesale_pricing_options' ) == false ) { 
				$default_settings = array('wholesale_role' => 'single', 'restrict_store_access' => '', 'retailer_disabled' => '', 'save_price_disabled' => '', );
				update_option( 'wwp_wholesale_pricing_options', $default_settings , false );
			}
			include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-general-functions.php';
			include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-common.php';
			include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-user-roles.php';
			add_action( 'plugins_loaded', __CLASS__ . '::wwp_wholesale_gateways_init', 11 );
			
			if ( is_admin() ) {
				include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-reports.php';
				include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-backend.php';
				include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-metabox.php';
				include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-requests.php';
				include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-user-custom-fields.php';
				include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-bulk-price.php';
				include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-registration-setting.php';
				include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-rulesets.php';
				include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-export-import.php';

				// Meta data migrate from single to multi wholesaler
				$migrate_singel_file_to_multi_file = get_option( 'migrate_singel_file_to_multi_file' );
				if ( empty( $migrate_singel_file_to_multi_file ) ) {
					include_once WWP_PLUGIN_PATH . 'inc/migrate-singel-file-to-multi-file.php';
				}

				add_action( 'admin_notices', array( __Class__, 'setting_notice' ) );
			} else {
				include_once WWP_PLUGIN_PATH . '/inc/class-wwp-wholesale-frontend.php';
				add_action( 'init', array( __Class__, 'include_wholesale_functionality' ) );
				// version 1.3.0
				include_once WWP_PLUGIN_PATH . 'inc/class-wwp-products-visibility.php';
				// ends version 1.3.0
			}
			// version 1.3.0
			if ( in_array( 'woocommerce-subscriptions/woocommerce-subscriptions.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
					include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-subscription.php';
			}
			// ends version 1.3.0
			include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-registration.php';
			include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-registration-ajax.php';
		}
		
		public static function wwp_wholesale_gateways_init() {
			include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-payment-method.php';
		}

		public static function include_wholesale_functionality() { 
			$settings = get_option( 'wwp_wholesale_pricing_options', true );
			if ( is_user_logged_in() ) { 
				$user_info      = get_userdata( get_current_user_id() );
				$user_role      = implode( ', ', $user_info->roles );
				$wholesale_role = term_exists( $user_role, 'wholesale_user_roles' );
				if ( ( 0 !== $wholesale_role && null !== $wholesale_role ) || is_admin() ) { 
					include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-multiuser.php';
					include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-functions.php';
					include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-mnm-compatibility.php';
				}
			} else { 
				if ( isset( $settings['restrict_store_access'] ) && 'yes' == $settings['restrict_store_access'] ) {
					self::restrict_store_access();
					include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-multiuser.php';
					include_once WWP_PLUGIN_PATH . 'inc/class-wwp-wholesale-mnm-compatibility.php';
				}
			}
		}

		public static function restrict_store_access() {
			if ( is_admin() ) {
				return;
			}
			$post = wwp_get_post_data( '' );
			if ( isset( $post['access_store_pass'] ) && ! empty( $post['access_store_pass'] ) ) {
				$allterms = get_terms( 'wholesale_user_roles', array( 'hide_empty' => false ) );
				foreach ( $allterms as $allterm_key => $allterm_value ) {
					$password = get_term_meta( $allterm_value->term_id, 'password', true );
					if ( $password == $post['access_store_pass'] ) {
						setcookie( 'access_store_id', $allterm_value->term_id, time() + 86400, '/', '', 0 );
						if ( isset( $_SERVER['HTTP_REFERER'] ) ) {
							$refresh       = sanitize_text_field( $_SERVER['HTTP_REFERER'] ) . '?message=successfully';
							$shop_page_url = apply_filters( 'wwp_redirect_shop_page_url', get_permalink( wc_get_page_id( 'shop' ) ) );
							if ( $shop_page_url ) {
								header( 'Location: ' . $shop_page_url );
								exit;
							}
							header( 'Location: ' . $refresh );
							exit;
						}
					}
				}
				$refresh = sanitize_text_field( $_SERVER['HTTP_REFERER'] );
				wc_add_notice( __( 'Your password is invalid', 'woocommerce-wholesale-pricing' ), 'error' );
				//header( 'Location: ' . $refresh );
				//exit;
			}
			if ( isset( $post['back_to_retailer'] ) && ! empty( $post['back_to_retailer'] ) ) {
				unset( $_COOKIE['access_store_id'] );
				setcookie( 'access_store_id', null, 0, '/' );
				header( 'Location: ' . remove_query_arg( 'message' ) );
			}
			$get = wwp_get_get_data( '' );
			if ( isset( $get['message'] ) && ! empty( $get['message'] ) ) {
				wc_add_notice( __( 'You have been successfully access the wholesale store.', 'woocommerce-wholesale-pricing' ), 'success' );
			}
		}
		public static function wholesale_admin_notice_error() {
			$class   = 'notice notice-error';
			$message = esc_html__( 'The plugin Wholesale For WooCommerce requires WooCommerce to be installed and activated, in order to work', 'woocommerce-wholesale-pricing' );
			printf( '<div class="%1$s"><p>%2$s</p></div>', esc_html( $class ), esc_html( $message ) );
		}
		public static function setting_notice() {
			$wwp_pricing_options = get_option( 'wwp_wholesale_pricing_options' );
			if ( empty( $wwp_pricing_options ) && apply_filters( 'wwp_settings_notice', true )) {
				$class   = 'notice notice-warning is-dismissible';
				$plugin_name = apply_filters( 'wwp_wholsale_plg_title', 'Wholesale For WooCommerce' );
				$heading = esc_html__( 'Thank You for installing', 'woocommerce-wholesale-pricing' );
				$message     = esc_html__( 'Your current settings are incomplete. Settings must be saved in order to run the plugin. Click here to ', 'woocommerce-wholesale-pricing' );
				printf( '<div class="%1$s"><h2>%2$s %3$s</h2><p> %4$s <a href="%5$s">%6$s</a></p></div>', esc_html( $class ), esc_html( $heading ), esc_html( $plugin_name ), esc_html( $message ), esc_url( admin_url( 'admin.php?page=wwp_wholesale' ) ), esc_html__( 'Setup', 'woocommerce-wholesale-pricing' ) );
			}
		}
	}
	new Wwp_Wholesale_Pricing();
}
