<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
if ( ! class_exists( 'CLASS_WWP_WHOLESALE_REGISTRATION_AJAX' ) ) {

	class CLASS_WWP_WHOLESALE_REGISTRATION_AJAX {
		public function __construct() {
			$settings = ! empty( get_option( 'wwp_wholesale_pricing_options' ) ) ? get_option( 'wwp_wholesale_pricing_options', true ) : array();
			if ( isset( $settings['over_right_wholesale_form'] ) && 'yes' == $settings['over_right_wholesale_form'] ) {
				add_action( 'wp_ajax_over_right_wholesale_form', array( $this, 'wooc_extra_register_fields' ) );
				add_action( 'wp_ajax_nopriv_over_right_wholesale_form', array( $this, 'wooc_extra_register_fields' ) );
				add_action( 'woocommerce_after_customer_login_form', array( $this, 'action_woocommerce_after_customer_login_form' ), 10, 1 );
				
				add_action( 'wwp_wholesaler_registration_fields_start', array( $this, 'wwp_wholesaler_registration_fields_start' ), 10, 2 );
				add_filter( 'wwp_wholesale_registration_form_errors', array( $this, 'wwp_wholesale_registration_form_errors' ), 10, 1 );
			}
		}
		
		public function wwp_wholesale_registration_form_errors( $errors ) {
			$post = wwp_get_post_data();
			$errors = implode(',,', $errors);
			if ( !empty( $errors ) && isset( $post['wwp_wholesale_registration_form_over_right']) ) { 
				setcookie( 'wwp_registration_error', $errors, time() + 86400, '/', '', 0 );
			}
			return $errors;
		}
		
		public function wwp_wholesaler_registration_fields_start( $registrations, $settings ) { 
			
			if ( isset( $_COOKIE['wwp_registration_error'] ) && ! empty( $_COOKIE['wwp_registration_error'] ) ) {
				$cookie = $_COOKIE;
				$errors = $cookie['wwp_registration_error'];
				$errors = explode( ',,', $errors );
				//print_r (explode(",,",$errors));
				if ( ! empty( $errors ) ) {
					echo '<ul class="woocommerce-error" role="alert">';
					foreach ( $errors as $key => $error ) { 
						echo '<li>' . wp_kses_post( $error ) . '</li>';
					}
					echo '</ul>';
					unset( $_COOKIE['wwp_registration_error'] );
					setcookie( 'wwp_registration_error', null, 0, '/' );
				}
			}
		}
		 
		public function action_woocommerce_after_customer_login_form( $customer_login_form ) {
			?>
			<script type="text/javascript">
			jQuery(document).ready( function() {         
				jQuery.ajax({
					url : "<?php echo esc_html__( admin_url( 'admin-ajax.php' ) ); ?>",
					type : 'POST',
					data : {
					 action : 'over_right_wholesale_form'
					},
					success : function( response ) {
						jQuery('form.woocommerce-form.woocommerce-form-register.register').replaceWith(response);
						jQuery('h2.wholesaler-registration').remove(); 
						jQuery('.wwp_wholesaler_registration_form').append('<input type="hidden" name="wwp_wholesale_registration_form_over_right">');
						jQuery('#wwp_wholesaler_copy_billing_address').change(
						function() { 
						if (!this.checked) {
							jQuery('#wholesaler_shipping_address').fadeIn('slow');
						} else {
							jQuery('#wholesaler_shipping_address').fadeOut('slow');
						}
						}
						);
					}
				});
			
			});
			</script>
			<style>
				form.woocommerce-form.woocommerce-form-register.register {
					display:none;
				}
			</style>
			<?php
		}

		public function wooc_extra_register_fields() {
			$wwp_registration_form = new Wwp_Wholesale_Pricing_Registration();
			echo wp_kses( $wwp_registration_form->wwp_registration_form(), shapeSpace_allowed_html() );
			die;
		}
	}
	new CLASS_WWP_WHOLESALE_REGISTRATION_AJAX();
}
