<?php
/*
Plugin Name: WooCommerce Japak Synchronisatie
Plugin URI: http://www.japak.nl
Description: WooCommerce koppeling met het Japak magazijn.
Author: Jeroen van den Nieuwenhuisen
Author URI: http://www.japak.nl
Version: 0.1.0
*/

//Prevent direct access data leaks
if (!defined('ABSPATH')) {
    exit;
}

// some generic definitions
define('WCJPK_PLUGIN', plugin_basename(__FILE__));
define('WCJPK_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('WCJPK_PLUGIN_NAME', basename(__FILE__, '.php'));
define('WCJPK_PLUGIN_URL', plugin_dir_url(__FILE__));
define('WCJPK_DATABASE_VERSION', '1.1');
define('WCJPK_DATABASE_ORDER_SYNC_TABLENAME', 'wcjpk_order_synchronisation_queue');

// load the plugin classes
require_once(WCJPK_PLUGIN_DIR . 'japak/autoload.php');
require_once(WCJPK_PLUGIN_DIR . 'woocommerce-japak-install.php');
require_once(WCJPK_PLUGIN_DIR . 'woocommerce-japak-class.php');

// make sure we don't expose any info if called directly
if (!function_exists('add_action')) {
	echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
	exit;
}

//Check if WooCommerce is active.
if (in_array( 'woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
	require_once(WCJPK_PLUGIN_DIR . '../woocommerce/woocommerce.php');

	if (class_exists('WoocommerceJapak')) {

		$woocommerceJapak = new WoocommerceJapak();

		// Register for activation
  		register_activation_hook( __FILE__, array(&$woocommerceJapak, 'activation'));
  		register_deactivation_hook( __FILE__, array(&$woocommerceJapak, 'deactivation'));
	}
}