<?php

function wcjpk_install()
{
	global $wpdb;

	$tableName = $wpdb->prefix . WCJPK_DATABASE_ORDER_SYNC_TABLENAME;
	$charsetCollate = $wpdb->get_charset_collate();

	$sql = "CREATE TABLE $tableName (
		`id` MEDIUMINT(9) NOT NULL AUTO_INCREMENT,
		`orderId` MEDIUMINT(9) NOT NULL,
		`status` ENUM('waiting', 'processing', 'done', 'error') NOT NULL DEFAULT 'waiting',
		`attempts` TINYINT(2) DEFAULT 0,
		`error_code` TINYINT(1) DEFAULT NULL,
		`created_at` DATETIME NOT NULL,
		`updated_at` DATETIME NULL,
		UNIQUE KEY id (id)
	) $charsetCollate;";

	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($sql);

	add_option('wcjpk_db_version', WCJPK_DATABASE_VERSION);
}

function wcjpk_update_db_check()
{
	
    if (get_site_option('wcjpk_db_version') != WCJPK_DATABASE_VERSION) {
        wcjpk_install();
    }
}

add_action('plugins_loaded', 'wcjpk_update_db_check');

function wcjpk_add_every_minute($schedules)
{
    $schedules['every_minut'] = array(
        'interval' => 60,
        'display' => __( 'Every Minute', 'textdomain' )
    );
    
    return $schedules;
}

add_filter( 'cron_schedules', 'wcjpk_add_every_minute' );
