<?php
class Japak_Serializer_OrderSerializer extends Japak_Serializer_Serializer
{
	public static function serialize(Japak_Objects_Order $order)
	{
		$orderXML = array();
		$orderXML[] = '<Order>';
		$orderXML[] = '<Reference>' . $order->getReference() . '</Reference>';
		$orderXML[] = '<PaymentMethodCode>' . $order->getPaymentMethodCode() . '</PaymentMethodCode>';
		$orderXML[] = '<PricesIncl>' . Japak_Serializer_Serializer::boolString($order->getPricesIncl()) . '</PricesIncl>';
		$orderXML[] = '<ElectronicPaid>' . $order->getElectronicPaid() . '</ElectronicPaid>';

		// PARCEL SERVICE
		$orderXML[] = '<Parcel>';
		$orderXML[] = '<ParcelServiceCode>' . $order->getParcelServiceCode()  . '</ParcelServiceCode>';
		$orderXML[] = '<ParcelTypeCode>' . $order->getParcelTypeCode() . '</ParcelTypeCode>';
		$orderXML[] = '<NumberOfColli>' . $order->getNumberOfColli() . '</NumberOfColli>';
		$orderXML[] = '</Parcel>';

		// ORDER CUSTOMER
		$orderXML[] = '<Customer>';
		$orderXML[] = '<CustomerCode>' . $order->getCustomerCode() . '</CustomerCode>';
		$orderXML[] = '<ShopCode>' . $order->getShopCode() . '</ShopCode>';

		// BILLING ADDRESS
		$orderXML[] = '<BillingAddress>';
		$orderXML[] = '<CountryCode>' . Japak_Serializer_Serializer::toCDATA($order->getBillingCountryCode()) . '</CountryCode>';
		$orderXML[] = '<NameFirst>' . Japak_Serializer_Serializer::toCDATA($order->getBillingNameFirst()) . '</NameFirst>';
		$orderXML[] = '<NameLast>' . Japak_Serializer_Serializer::toCDATA($order->getBillingNameLast()) . '</NameLast>';
		$orderXML[] = '<Phone>' . Japak_Serializer_Serializer::toCDATA($order->getBillingPhone()) . '</Phone>';
		$orderXML[] = '<Street>' . Japak_Serializer_Serializer::toCDATA($order->getBillingStreet()) . '</Street>';
		$orderXML[] = '<HouseNumber>' . Japak_Serializer_Serializer::toCDATA($order->getBillingHouseNumber()) . '</HouseNumber>';

		if (Japak_Serializer_Serializer::notEmptyString($order->getBillingHouseNumberAddon())) {
			$orderXML[] = '<HouseNumberAddon>' . Japak_Serializer_Serializer::toCDATA($order->getBillingHouseNumberAddon()) . '</HouseNumberAddon>';
		}

		$orderXML[] = '<PostalCode>' . Japak_Serializer_Serializer::toCDATA($order->getBillingPostalCode()) . '</PostalCode>';
		$orderXML[] = '<Email>' . Japak_Serializer_Serializer::toCDATA($order->getBillingEmail()) . '</Email>';
		$orderXML[] = '<City>' . Japak_Serializer_Serializer::toCDATA($order->getBillingCity()) . '</City>';

		if (Japak_Serializer_Serializer::notEmptyString($order->getBillingFax())) {
			$orderXML[] = '<Fax>' . Japak_Serializer_Serializer::toCDATA($order->getBillingFax()) . '</Fax>';
		}

		if (Japak_Serializer_Serializer::notEmptyString($order->getBillingCompany())) {
			$orderXML[] = '<Company>' . Japak_Serializer_Serializer::toCDATA($order->getBillingCompany()) . '</Company>';
		}

		$orderXML[] = '</BillingAddress>';

		// SHIPMENT ADDRESS
		if (Japak_Serializer_Serializer::notEmptyString($order->getShipmentCountryCode())) {
			$orderXML[] = '<ShipmentAddress>';
			$orderXML[] = '<CountryCode>' . Japak_Serializer_Serializer::toCDATA($order->getShipmentCountryCode()) . '</CountryCode>';
			$orderXML[] = '<NameFirst>' . Japak_Serializer_Serializer::toCDATA($order->getShipmentNameFirst()) . '</NameFirst>';
			$orderXML[] = '<NameLast>' . Japak_Serializer_Serializer::toCDATA($order->getShipmentNameLast()) . '</NameLast>';
			$orderXML[] = '<Street>' . Japak_Serializer_Serializer::toCDATA($order->getShipmentStreet()) . '</Street>';
			$orderXML[] = '<HouseNumber>' . Japak_Serializer_Serializer::toCDATA($order->getShipmentHouseNumber()) . '</HouseNumber>';

			if (Japak_Serializer_Serializer::notEmptyString($order->getShipmentHouseNumberAddon())) {
				$orderXML[] = '<HouseNumberAddon>' . Japak_Serializer_Serializer::toCDATA($order->getShipmentHouseNumberAddon()) . '</HouseNumberAddon>';
			}

			$orderXML[] = '<PostalCode>' . Japak_Serializer_Serializer::toCDATA($order->getShipmentPostalCode()) . '</PostalCode>';
			$orderXML[] = '<City>' . Japak_Serializer_Serializer::toCDATA($order->getShipmentCity()) . '</City>';

			if (Japak_Serializer_Serializer::notEmptyString($order->getShipmentPhone())) {
				$orderXML[] = '<Phone>' . Japak_Serializer_Serializer::toCDATA($order->getShipmentPhone()) . '</Phone>';
			}

			if (Japak_Serializer_Serializer::notEmptyString($order->getShipmentEmail())) {
				$orderXML[] = '<Email>' . Japak_Serializer_Serializer::toCDATA($order->getShipmentEmail()) . '</Email>';
			}

			if (Japak_Serializer_Serializer::notEmptyString($order->getShipmentFax())) {
				$orderXML[] = '<Fax>' . Japak_Serializer_Serializer::toCDATA($order->getShipmentFax()) . '</Fax>';
			}

			if (Japak_Serializer_Serializer::notEmptyString($order->getShipmentCompany())) {
				$orderXML[] = '<Company>' . Japak_Serializer_Serializer::toCDATA($order->getShipmentCompany()) . '</Company>';
			}

			$orderXML[] = '</ShipmentAddress>';
		}

		$orderXML[] = '</Customer>';

		$orderLines = $order->getOrderLines();

		if (@count($orderLines) > 0) {
			$orderXML[] = '<OrderLines>';

			foreach ($orderLines as $orderLine) {
				if ($orderLine instanceof Japak_Objects_OrderLine) {
					$orderXML[] = '<OrderLine>';
					$orderXML[] = '<ItemCode>' . $orderLine->getItemCode() . '</ItemCode>';
					$orderXML[] = '<QuantityOrdered>' . $orderLine->getAmount() . '</QuantityOrdered>';
					$orderXML[] = '<QuantityToDeliver>' . $orderLine->getAmount() . '</QuantityToDeliver>';

					if ($orderLine->getPriceIncl()) {
						$orderXML[] = '<PriceIncl>' . $orderLine->getPrice() . '</PriceIncl>';
						$orderXML[] = '<AmountIncl>' . $orderLine->getRowTotal() . '</AmountIncl>';
					} else {
						$orderXML[] = '<Price>' . $orderLine->getPrice() . '</Price>';
						$orderXML[] = '<Amount>' . $orderLine->getRowTotal() . '</Amount>';
					}
					$orderXML[] = '</OrderLine>';
				} else if ($orderLine instanceof Japak_Objects_OrderLineText) {
					$orderXML[] = '<OrderLine>';
					$orderXML[] = '<Description>' . $orderLine->getDescription() . '</Description>';
					$orderXML[] = '</OrderLine>';
				}
			}

			$orderXML[] = '</OrderLines>';
		}
		
		$extraFields = $order->getExtraFields();
		
		if (@count($extraFields) > 0) {
			$orderXML[] = '<CustomFields>';
			
			foreach ($extraFields as $extraFieldKey => $extraFieldValue) {
				$orderXML[] = '<' . $extraFieldKey . '>';
				$orderXML[] = Japak_Serializer_Serializer::toCDATA($extraFieldValue);
				$orderXML[] = '</' . $extraFieldKey . '>';
			}
			
			$orderXML[] = '</CustomFields>';
		}

		$orderXML[] = '</Order>';

		return join("\n", $orderXML);
	}
}