<?php
class Japak_Serializer_ItemSerializer extends Japak_Serializer_Serializer
{
	public static function serialize(Japak_Objects_Item $item)
	{
		$itemXML = array();
		$itemXML[] = '<Item>';
		$itemXML[] = '<ItemCode>' . $item->getItemCode() . '</ItemCode>';
		$itemXML[] = '<Brand>' . Japak_Serializer_Serializer::toCDATA($item->getBrand()) . '</Brand>';
		$itemXML[] = '<BrandGroup>' . Japak_Serializer_Serializer::toCDATA($item->getBrandGroup()) . '</BrandGroup>';
		$itemXML[] = '<VatCode>' . $item->getVATCode() . '</VatCode>';
		$itemXML[] = '<ItemStatus>' . $item->getItemStatus() . '</ItemStatus>';
		$itemXML[] = '<Description>' . Japak_Serializer_Serializer::toCDATA($item->getDescription()) . '</Description>';

		if ($item->issetPrice()) {
			$itemXML[] = '<Price>' . floatval($item->getPrice()) . '</Price>';
		}

		if ($item->issetCostPrice()){
			$itemXML[] = '<CostPrice>' . floatval($item->getCostPrice()) . '</CostPrice>';
		}

		if ($item->issetStock()) {
			$overwrite = ($item->getStockOverwrite()) ? 'true' : 'false';
			$itemXML[] = '<Stock overwrite="' . $overwrite . '">' . intval($item->getStock()) . '</Stock>';
		}

		if ($item->issetLocation()) {
			$itemXML[] = '<Location>' . intval($item->getLocation()) . '</Location>';
		}

		$itemXML[] = '<ItemType>' . $item->getType() . '</ItemType>';

		if ($item->getType() == Japak_Objects_ItemTypes::Assembly) {
			$itemXML[] = '<AssemblyItems>';

			foreach ($item->getAssemblyItems() as $assemblyItem) {
				$itemXML[] = '<AssemblyItem>';
				$itemXML[] = '<ItemCode>' . $assemblyItem->getItemCode() . '</ItemCode>';
				$itemXML[] = '<Number>' . intval($assemblyItem->getNumber()) . '</Number>';
				$itemXML[] = '</AssemblyItem>';
			}

			$itemXML[] = '</AssemblyItems>';
		}

		if ($item->issetBarcode()) {
			$itemXML[] = '<EanCodes><EanCode>' . Japak_Serializer_Serializer::toCDATA($item->getBarcode()) . '</EanCode></EanCodes>';
		}

		if ($item->issetImageURL()) {
			$itemXML[] = '<CustomFields><imageurl>' . Japak_Serializer_Serializer::toCDATA($item->getImageURL()) . '</imageurl></CustomFields>';
		}

		$itemXML[] = '</Item>';

		return join("\n", $itemXML);
	}
}