<?php
class Japak_Objects_Order
{
	/**
	 * @var string
	 */
	protected $reference = '';

	/**
	 * @var string
	 */
	protected $paymentMethodCode = 'EB';

	/**
	 * @var boolean
	 */
	protected $pricesIncl = true;

	/**
	 * @var integer
	 */
	protected $electronicPaid = 0;

	/**
 	 * @var string
	 */
	protected $parcelServiceCode = 'DPDNL';

	/**
	 * @var string
	 */
	protected $parcelTypeCode = '101';

	/**
	 * @var integer
	 */
	protected $numberOfColli = 1;

	/**
	 * @var string
	 */
	protected $customerCode = '';

	/**
	 * @var string
	 */
	protected $shopCode = '';

	/**
	 * @var string
	 */
	protected $billingCountryCode = 'NL';

	/**
	 * @var string
	 */
	protected $billingNameFirst = '';

	/**
	 * @var string
	 */
	protected $billingNameLast = '';

	/**
	 * @var string
	 */
	protected $billingPhone = '';

	/**
	 * @var string
	 */
	protected $billingStreet = '';

	/**
	 * @var string
	 */
	protected $billingHouseNumber = '';

	/**
	 * @var string
	 */
	protected $billingHouseNumberAddon = '';

	/**
	 * @var string
	 */
	protected $billingPostalCode = '';

	/**
	 * @var string
	 */
	protected $billingEmail = '';

	/**
	 * @var string
	 */
	protected $billingCity = '';

	/**
	 * @var string
	 */
	protected $billingFax = '';

	/**
	 * @var string
	 */
	protected $billingCompany = '';

	/**
	 * @var string
	 */
	protected $shipmentCountryCode = 'NL';

	/**
	 * @var string
	 */
	protected $shipmentNameFirst = '';

	/**
	 * @var string
	 */
	protected $shipmentNameLast = '';

	/**
	 * @var string
	 */
	protected $shipmentPhone = '';

	/**
	 * @var string
	 */
	protected $shipmentStreet = '';

	/**
	 * @var string
	 */
	protected $shipmentHouseNumber = '';

	/**
	 * @var string
	 */
	protected $shipmentHouseNumberAddon = '';

	/**
	 * @var string
	 */
	protected $shipmentPostalCode = '';

	/**
	 * @var string
	 */
	protected $shipmentEmail = '';

	/**
	 * @var string
	 */
	protected $shipmentCity = '';

	/**
	 * @var string
	 */
	protected $shipmentFax = '';

	/**
	 * @var string
	 */
	protected $shipmentCompany = '';

	/**
	 * @var array
	 */
	protected $orderLines = array();
	
	/**
	 * @var array
	 */
	protected $extraFields = array();

	// REFERENCE
	public function setReference($reference)
	{
		$this->reference = trim($reference);
	}

	public function getReference()
	{
		return $this->reference;
	}

	// PAYMENT METHODE CODE
	public function setPaymentMethodCode($paymentMethodCode)
	{
		$this->paymentMethodCode = $paymentMethodCode;
	}

	public function getPaymentMethodCode()
	{
		return $this->paymentMethodCode;
	}

	// PRICES INCL
	public function setPricesIncl($pricesIncl)
	{
		$this->pricesIncl = $pricesIncl;
	}

	public function getPricesIncl()
	{
		return $this->pricesIncl;
	}

	// ELECTRONIC PAID
	public function setElectronicPaid($electronicPaid)
	{
		$this->electronicPaid = $electronicPaid;
	}

	public function getElectronicPaid()
	{
		return $this->electronicPaid;
	}

	// PARCEL SERVICE CODE
	public function setParcelServiceCode($parcelServiceCode)
	{
		$this->parcelServiceCode = $parcelServiceCode;
	}

	public function getParcelServiceCode()
	{
		return $this->parcelServiceCode;
	}

	// PARCEL TYPE CODE
	public function setParcelTypeCode($parcelTypeCode)
	{
		$this->parcelTypeCode = $parcelTypeCode;
	}

	public function getParcelTypeCode()
	{
		return $this->parcelTypeCode;
	}

	// NUMBER OF COLLI
	public function setNumberOfColli($numberOfColli)
	{
		$this->numberOfColli = intval($numberOfColli);
	}

	public function getNumberOfColli()
	{
		return $this->numberOfColli;
	}

	// CUSTOMER CODE
	public function setCustomerCode($customerCode)
	{
		$this->customerCode = trim($customerCode);
	}

	public function getCustomerCode()
	{
		return $this->customerCode;
	}

	// SHOPCODE
	public function setShopCode($shopCode)
	{
		$this->shopCode = $shopCode;
	}

	public function getShopCode()
	{
		return $this->shopCode;
	}

	// BILLING COUNTY CODE
	public function setBillingCountryCode($billingCountryCode)
	{
		$this->billingCountryCode = trim(strtoupper($billingCountryCode));
	}

	public function getBillingCountryCode()
	{
		return $this->billingCountryCode;
	}

	// BILLING NAME FIRST
	public function setBillingNameFirst($billingNameFirst)
	{
		$this->billingNameFirst = trim($billingNameFirst);
	}

	public function getBillingNameFirst()
	{
		return $this->billingNameFirst;
	}

	// BILLING NAME LAST
	public function setBillingNameLast($billingNameLast)
	{
		$this->billingNameLast = trim($billingNameLast);
	}

	public function getBillingNameLast()
	{
		return $this->billingNameLast;
	}

	// BILLING PHONE
	public function setBillingPhone($billingPhone)
	{
		$this->billingPhone = trim($billingPhone);
	}

	public function getBillingPhone()
	{
		return $this->billingPhone;
	}

	// BILLING PHONE
	public function setBillingStreet($billingStreet)
	{
		$this->billingStreet = trim($billingStreet);
	}

	public function getBillingStreet()
	{
		return $this->billingStreet;
	}

	// BILLING HOUSE NUMBER
	public function setBillingHouseNumber($billingHouseNumber)
	{
		$this->billingHouseNumber = trim($billingHouseNumber);
	}

	public function getBillingHouseNumber()
	{
		return $this->billingHouseNumber;
	}

	// BILLING HOUSE NUMBER ADDON
	public function setBillingHouseNumberAddon($billingHouseNumberAddon)
	{
		$this->billingHouseNumberAddon = trim($billingHouseNumberAddon);
	}

	public function getBillingHouseNumberAddon()
	{
		return $this->billingHouseNumberAddon;
	}

	// BILLING POSTAL CODE
	public function setBillingPostalCode($billingPostalCode)
	{
		$this->billingPostalCode = trim(str_replace(' ', '', strtoupper($billingPostalCode)));
	}

	public function getBillingPostalCode()
	{
		return $this->billingPostalCode;
	}

	// BILLING EMAIL
	public function setBillingEmail($billingEmail)
	{
		$this->billingEmail = trim($billingEmail);
	}

	public function getBillingEmail()
	{
		return $this->billingEmail;
	}

	// BILLING CITY
	public function setBillingCity($billingCity)
	{
		$this->billingCity = trim($billingCity);
	}

	public function getBillingCity()
	{
		return $this->billingCity;
	}

	// BILLING FAX
	public function setBillingFax($billingFax)
	{
		$this->billingFax = trim($billingFax);
	}

	public function getBillingFax()
	{
		return $this->billingFax;
	}

	// BILLING COMPANY
	public function setBillingCompany($billingCompany)
	{
		$this->billingCompany = trim($billingCompany);
		
		if (strlen($this->billingCompany) > 64) {
			$this->billingCompany = substr($this->billingCompany, 0, 64);
		}
	}

	public function getBillingCompany()
	{
		return $this->billingCompany;
	}

	// SHIPMENT COUNTY CODE
	public function setShipmentCountryCode($shipmentCountryCode)
	{
		$this->shipmentCountryCode = trim(strtoupper($shipmentCountryCode));
	}

	public function getShipmentCountryCode()
	{
		return $this->shipmentCountryCode;
	}

	// SHIPMENT NAME FIRST
	public function setShipmentNameFirst($shipmentNameFirst)
	{
		$this->shipmentNameFirst = trim($shipmentNameFirst);
	}

	public function getShipmentNameFirst()
	{
		return $this->shipmentNameFirst;
	}

	// SHIPMENT NAME LAST
	public function setShipmentNameLast($shipmentNameLast)
	{
		$this->shipmentNameLast = trim($shipmentNameLast);
	}

	public function getShipmentNameLast()
	{
		return $this->shipmentNameLast;
	}

	// SHIPMENT PHONE
	public function setShipmentPhone($shipmentPhone)
	{
		$this->shipmentPhone = trim($shipmentPhone);
	}

	public function getShipmentPhone()
	{
		return $this->shipmentPhone;
	}

	// SHIPMENT PHONE
	public function setShipmentStreet($shipmentStreet)
	{
		$this->shipmentStreet = trim($shipmentStreet);
	}

	public function getShipmentStreet()
	{
		return $this->shipmentStreet;
	}

	// SHIPMENT HOUSE NUMBER
	public function setShipmentHouseNumber($shipmentHouseNumber)
	{
		$this->shipmentHouseNumber = trim($shipmentHouseNumber);
	}

	public function getShipmentHouseNumber()
	{
		return $this->shipmentHouseNumber;
	}

	// SHIPMENT HOUSE NUMBER ADDON
	public function setShipmentHouseNumberAddon($shipmentHouseNumberAddon)
	{
		$this->shipmentHouseNumberAddon = trim($shipmentHouseNumberAddon);
	}

	public function getShipmentHouseNumberAddon()
	{
		return $this->shipmentHouseNumberAddon;
	}

	// SHIPMENT POSTAL CODE
	public function setShipmentPostalCode($shipmentPostalCode)
	{
		$this->shipmentPostalCode = trim($shipmentPostalCode);
	}

	public function getShipmentPostalCode()
	{
		return $this->shipmentPostalCode;
	}

	// SHIPMENT EMAIL
	public function setShipmentEmail($shipmentEmail)
	{
		$this->shipmentEmail = trim($shipmentEmail);
	}

	public function getShipmentEmail()
	{
		return $this->shipmentEmail;
	}

	// SHIPMENT CITY
	public function setShipmentCity($shipmentCity)
	{
		$this->shipmentCity = trim($shipmentCity);
	}

	public function getShipmentCity()
	{
		return $this->shipmentCity;
	}

	// SHIPMENT FAX
	public function setShipmentFax($shipmentFax)
	{
		$this->shipmentFax = trim($shipmentFax);
	}

	public function getShipmentFax()
	{
		return $this->shipmentFax;
	}

	// SHIPMENT COMPANY
	public function setShipmentCompany($shipmentCompany)
	{
		$this->shipmentCompany = trim($shipmentCompany);
		
		if (strlen($this->shipmentCompany) > 64) {
			$this->shipmentCompany = substr($this->shipmentCompany, 0, 64);
		}
	}

	public function getShipmentCompany()
	{
		return $this->shipmentCompany;
	}

	// SET SHIPPING COSTS
	public function setShippingCosts($shippingCost, $vatCode)
	{
		$shippingCostsItem = new Japak_Objects_OrderLine();

		if($vatCode == VATCODE_0){
			$shippingCostsItem->setItemCode(SHIPPING_COST_ITEMCODE_VAT0, false);
		} else if($vatCode == VATCODE_6){
			$shippingCostsItem->setItemCode(SHIPPING_COST_ITEMCODE_VAT6, false);
		} else {
			$shippingCostsItem->setItemCode(SHIPPING_COST_ITEMCODE_VAT21, false);
		}

		$shippingCostsItem->setPrice(floatval($shippingCost));
		$shippingCostsItem->setAmount(1);
		$shippingCostsItem->setRowTotal(floatval($shippingCost));

		$this->addOrderline($shippingCostsItem);
	}

	// ORDERLINES
	public function addOrderline(Japak_Objects_OrderLineBase $orderLine)
	{
		$this->orderLines[] = $orderLine;
	}

	public function getOrderlines()
	{
		return $this->orderLines;
	}
	
	public function addExtraField($key, $value)
	{
		$this->extraFields[$key] = $value;
	}

	public function getExtraFields()
	{
		return $this->extraFields;
	}
}