<?php
class Japak_Objects_OrderNumberToken
{
	/**
	 * @var integer
	 */
	protected $orderNumber;

	/**
	 * @var string
	 */
	protected $token;

	/**
	 * @var string
	 */
	protected $status;

	public function __construct($orderNumber = '', $token = 0, $status = 'Unknown')
	{
		// SET DEFAULT VALUES
		$this->orderNumber 	= intval($orderNumber);
		$this->token 		= intval($token);
		$this->status 		= $status;
	}

	// ORDER NUMBER
	public function setOrderNumber($orderNumber)
	{
		$this->orderNumber = intval($orderNumber);
	}

	public function getOrderNumber()
	{
		return $this->orderNumber;
	}

	// TOKEN
	public function setToken($token)
	{
		$this->token = intval($token);
	}

	public function getToken()
	{
		return $this->token;
	}

	// STATUS
	public function setStatus($status)
	{
		$this->status = $status;
	}

	public function getStatus()
	{
		return $this->status;
	}
}