<?php
class Japak_Objects_OrderLine extends Japak_Objects_OrderLineBase
{
	/**
	 * @var string
	 */
	protected $itemCode = '';

	/**
	 * @var decimal
	 */
	protected $price = 0.0;

	/**
	 * @var decimal
	 */
	protected $rowTotal = 0.0;

	/**
	 * @var integer
	 */
	protected $amount = 0.0;

	/**
	 * @var decimal
	 */
	protected $priceIncl = true;

	// ITEMCODE
	public function setItemCode($itemCode)
	{
		$this->itemCode = $itemCode;
	}

	public function getItemCode()
	{
		return $this->itemCode;
	}

	// PRICE
	public function setPrice($price)
	{
		$this->price = floatval($price);
	}

	public function getPrice()
	{
		return $this->price;
	}

	// ROW TOTAL
	public function setRowTotal($rowTotal)
	{
		$this->rowTotal = floatval($rowTotal);
	}

	public function getRowTotal()
	{
		return $this->rowTotal;
	}

	// AMOUNT
	public function setAmount($amount)
	{
		$this->amount = intval($amount);
	}

	public function getAmount()
	{
		return $this->amount;
	}

	// PRICE INCL
	public function getPriceIncl()
	{
		return $this->priceIncl;
	}

	public function setPriceIncl($priceIncl)
	{
		$this->priceIncl = (bool)$priceIncl;
	}
}