<?php

try
{
	$order = new Japak_Objects_Order();

	// SET DEFAULT VALUES
	$order->setReference(324234234);
	$order->setElectronicPaid(0);

	// CUSTOMER
	$order->setCustomerCode(1234);

	$order->setBillingCountryCode('NL');
	$order->setBillingNameFirst('Jeroen');
	$order->setBillingNameLast('van den Nieuwenhuisen');
	$order->setBillingPhone('06-55332626');
	$order->setBillingStreet('Salderes');
	$order->setBillingHouseNumber('18');
	$order->setBillingHouseNumberAddon('A');
	$order->setBillingPostalCode('5682ER');
	$order->setBillingEmail('nieuwenhuisen@me.com');
	$order->setBillingCity('Best');
	$order->setBillingFax('0499-399014');
	$order->setBillingCompany('Japak');

	$order->setShipmentCountryCode('NL');
	$order->setShipmentNameFirst('Jeroen');
	$order->setShipmentNameLast('van den Nieuwenhuisen');
	$order->setShipmentPhone('06-55332626');
	$order->setShipmentStreet('Salderes');
	$order->setShipmentHouseNumber('18');
	$order->setShipmentHouseNumberAddon('A');
	$order->setShipmentPostalCode('5682ER');
	$order->setShipmentEmail('nieuwenhuisen@me.com');
	$order->setShipmentCity('Best');
	$order->setShipmentFax('0499-399014');
	$order->setShipmentCompany('Japak');

	$oderLine1 = new Japak_Objects_OrderLine();
	$oderLine1->setItemCode('1234');
	$oderLine1->setPrice(15.0);
	$oderLine1->setAmount(1);
	$oderLine1->setRowTotal(15.0);

	$oderLine2 = new Japak_Objects_OrderLine();
	$oderLine2->setItemCode('75476');
	$oderLine2->setPrice(25.5);
	$oderLine2->setAmount(4);
	$oderLine2->setRowTotal(100.2);

	$order->addOrderLine($oderLine1);
	$order->addOrderLine($oderLine2);

	$order->setShippingCosts(8.05, DEFAULT_VATCODE);

	$comm = new Japak_Communication();
	$result = $comm->sendRequest(Japak_Serializer_OrderSerializer::serialize($order));
}
catch(Exception $ex)
{
	die('EXCEPTION: ' . $ex->getMessage());
}