<?php
	
class Japak_Communication
{
	private $_interfaceVersion = '1.0.0.0';
	private $_applicationName;
	private $_applicationId;
	private $_securityCode;
	private $_webserviceURL;
	private $_shopcode;
	private $_skuPrefix;

	private $_soapClient;

	public function __construct($applicationName, $applicationId, $securityCode, $webserviceUrl, $shopCode, $skuPrefix)
	{
		// SETTINGS
		$this->_applicationName	= $applicationName;
		$this->_applicationId = $applicationId;
		$this->_securityCode = $securityCode;
		$this->_webserviceURL = $webserviceUrl;
		$this->_shopcode = $shopCode;
		$this->_skuPrefix = $skuPrefix;

		$this->_soapClient = new SoapClient($this->_webserviceURL, array(
            'trace' => true,
            'encoding' => 'UTF-8',
            'exceptions' => true,
            'cache_wsdl' => WSDL_CACHE_NONE
        ));
	}

	private function call($methode, $soap, $use_xml_wrapper = true)
	{
		try
		{
            $params = ($use_xml_wrapper) ? array('xml' => $soap) : $soap;
            $response = $this->_soapClient->{$methode}($params);
                       
			if (isset($response->GetResponseResult)) {
				$parsedResponse = new SimpleXMLElement($response->GetResponseResult);

				if($parsedResponse->ResultCode != 'I00'){
					throw new Japak_Exception_Communication($parsedResponse->ResultDescription, $parsedResponse->ResultCode);
				}

				return $parsedResponse;
			} else {
				if (is_array($response) && isset($response['faultstring'])) {
					throw new Japak_Exception_Communication($response['faultstring']);
				}

				return $response;
			}
		} catch (Exception $ex) {
			//die($ex->getMessage());
			//throw $ex;
		}
		
		echo $this->_soapClient->__getLastResponse();
		exit;
	}

	public function getStocks($itemCodePrefix = '')
	{
        $result = $this->call('GetResponse', sprintf('<GetStock>
		<InterfaceVersion>%s</InterfaceVersion>
		<SecurityCode>%s</SecurityCode>
		<ApplicationId>%d</ApplicationId>
		</GetStock>',
			$this->_interfaceVersion,
			$this->_securityCode,
			$this->_applicationId));

		$stockItems = array();
		
		if (@property_exists($result, 'Items') && @property_exists($result->Items, 'Item')) {			
			foreach ($result->Items->Item as $item) {
				$itemCode = (string)$item->ItemCode;
								
				if (strpos($itemCode, $itemCodePrefix) === 0) {
					$stockItems[] = new Japak_Objects_StockItem($itemCode, (int)$item->Stock);
				}
			}
		}

		return $stockItems;
	}
	
	public function getChangedStock($itemCodePrefix, $token = 0)
	{	
		$result = $this->call('ChangedStock', array(
			'securityCode' => $this->_securityCode,
			'token' => $token,
			'maxResult' => 5000
		), false);
		
		$newToken = $token;
		$stockItems = array();
				
		foreach ($result->ChangedStockResult->ResponseValue->ItemStockToken as $item) {
			$itemCode = (string)$item->ItemCode;
			$newToken = max($newToken, (int)$item->Token);
			
// 			echo $itemCode . '<br />';
								
			if (strpos($itemCode, $itemCodePrefix) === 0) {
				$stockItems[] = new Japak_Objects_StockItem($itemCode, (int)$item->Stock);
			}
		}
		
		return array(
			$newToken, 
			$stockItems
		);
	}
	
	public function getChangedAssemblyStock($itemCodePrefix, $token = 0)
	{
		$result = $this->call('ChangedAssemblyStock', array(
			'securityCode' => $this->_securityCode,
			'token' => $token,
			'maxResult' => 5000
		), false);
		
		$newToken = $token;
		$stockItems = array();
		
		foreach ($result->ChangedAssemblyStockResult->ResponseValue->ItemAssemblyStockToken as $item) {
			$itemCode = (string)$item->ItemCode;
			
			$newToken = max($newToken, (int)$item->Token);
								
			if (strpos($itemCode, $itemCodePrefix) === 0) {
				$stockItems[] = new Japak_Objects_StockItem($itemCode, (int)$item->Available);
			}
		}
		
		return array(
			$newToken, 
			$stockItems
		);
	}

	public function getOrder($orderNumber)
	{
		$result = $this->call('OrderInfo', sprintf('<OrderInfo xmlns="http://sherpa.sherpaan.nl/">
		<securityCode>%s</securityCode>
		<orderNumber>%d</orderNumber>
		</OrderInfo>',
			$this->_securityCode,
			intval($orderNumber)), false);

		// @TODO PARSE ORDER
	}

	public function getChangedOrders($token = 0, $count = 50)
	{
		$result = $this->call('ChangedOrders', sprintf('<ChangedOrders xmlns="http://sherpa.sherpaan.nl/">
			      	<securityCode>%s</securityCode>
			      	<count>%d</count>
			      	<token>%d</token>
			    	</ChangedOrders>',
			    	$this->_securityCode,
			    	intval($count),
			    	intval($token)), false);

		$changedOrders = array();

		if(isset($result['ChangedOrdersResult']) && isset($result['ChangedOrdersResult']['ResponseValue']) && isset($result['ChangedOrdersResult']['ResponseValue']['OrderNumberToken']) && is_array($result['ChangedOrdersResult']['ResponseValue']['OrderNumberToken'])){
			foreach($result['ChangedOrdersResult']['ResponseValue']['OrderNumberToken'] as $token){
				if(isset($token['OrderNumber']) && isset($token['Token']) && isset($token['OrderStatus'])){
					$changedOrders[] = new Japak_Objects_OrderNumberToken($token['OrderNumber'], $token['Token'], $token['OrderStatus']);
				}
			}
		}

		return $changedOrders;
	}

	public function getItem($itemCode)
	{
		$result = $this->call('ItemInfo', sprintf('<ItemInfo xmlns="http://sherpa.sherpaan.nl/">
		<securityCode>%s</securityCode>
		<itemCode>%s</itemCode>
		</ItemInfo>',
			$this->_securityCode,
			trim($itemCode)), false);

		// @TODO PARSE ITEM
	}

	public function getChangedItems($token = 0, $count = 50)
	{
		$result = $this->call('ChangedItems', sprintf('<ChangedItems xmlns="http://sherpa.sherpaan.nl/">
			      	<securityCode>%s</securityCode>
			      	<count>%d</count>
			      	<token>%d</token>
			    	</ChangedItems>',
			    	$this->_securityCode,
			    	intval($count),
			    	intval($token)), false);

		$changedItems = array();

		if(isset($result['ChangedItemsResult']) && isset($result['ChangedItemsResult']['ResponseValue']) && isset($result['ChangedItemsResult']['ResponseValue']['ItemCodeToken']) && is_array($result['ChangedItemsResult']['ResponseValue']['ItemCodeToken'])){
			foreach($result['ChangedItemsResult']['ResponseValue']['ItemCodeToken'] as $token){
				if(isset($token['ItemCode']) && isset($token['Token'])){
					$changedItems[] = new Japak_Objects_ItemToken($token['ItemCode'], $token['Token']);
				}
			}
		}

		return $changedItems;
	}

	public function sendRequest($xml)
	{
		try
		{
			$response = $this->call('GetResponse', sprintf('<Import>
			<InterfaceVersion>%s</InterfaceVersion>
			<SecurityCode>%s</SecurityCode>
			<ApplicationId>%d</ApplicationId>
			%s</Import>',
				$this->_interfaceVersion,
				$this->_securityCode,
				$this->_applicationId,
				$xml));

			return $response;
		}
		catch(Exception $ex)
		{
			throw $ex;
		}
	}
}