<?php
/**
 * Plugin Name: Woo Store finder
 * Description: Link stores to your products and display those stores in google maps
 * Version: 2.0
 * Tags: woocommerce, stores, store locator, store finder
 * Author: wpexpertsio
 * Author URI: http://wpexpert.io/
 * Developer: wpexpertsio
 * Developer URI: https://wpexperts.io/
 * Text Domain: store-finder-for-woocommerce
 *
 * Woo: 5801089:33b2264131ad62d68b43fd4a6201459d
 * WC requires at least: 3.0
 * WC tested up to: 5.8.0
 */
if ( ! class_exists( 'Woo_Store_Locator' ) ) {

	final class Woo_Store_Locator {

		// Plugin Version
		public $version = '2.0';

		// Instnace
		protected static $_instance = null;

		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		public function __clone() {
			_doing_it_wrong( __FUNCTION__, 'Cheatin&#8217; huh?', esc_attr( $this->version ) );
		}

		public function __wakeup() {
			_doing_it_wrong( __FUNCTION__, 'Cheatin&#8217; huh?', esc_attr( $this->version ) );
		}

		private function define( $name, $value, $definable = true ) {

			if ( ! defined( $name ) ) {
				define( $name, $value );
			} elseif ( ! $definable && defined( $name ) ) {
				_doing_it_wrong( 'define->define()', 'Could not define: ' . esc_attr( $name ) . ' as it is already defined somewhere else!', esc_attr( $this->version ) );
			}

		}

		public function file( $required_file ) {
			if ( file_exists( $required_file ) ) {
				require_once $required_file;
			} else {
				_doing_it_wrong( 'woocommerce_store_locator->file()', 'Requested file ' . esc_attr( $required_file ) . ' not found.', esc_attr( $this->version ) );
			}
		}

		public function __construct() {
			$this->define_constants();
			$this->load_modules();

			add_action( 'admin_enqueue_scripts', array( $this, 'woocommerce_store_locator_admin_scripts' ) ); // wp_enqueue_script

		}


		/**
		 * Enqueue styles and scripts
		 **/
		public function woocommerce_store_locator_admin_scripts() {

			global $pagenow;
			$post_type = get_post_type( get_the_ID() );
			// $stores_post_type = get_option(WOOCOMMERCE_STORE_SETTINGS_ID.'_stores_slug');

			if ( WOOCOMMERCE_STORE_LOCATOR_POSTTYPE == $post_type || ( isset( $_GET['page'] ) && isset( $_GET['tab'] ) && ( 'wc-settings' == $_GET['page'] ) && ( 'wsl' == $_GET['tab'] ) ) ) {

				$wsl_api_key = get_option( WOOCOMMERCE_STORE_SETTINGS_ID . '_maps_api_key' );

				wp_enqueue_media();
				wp_enqueue_script( 'wsl_backend_map', 'https://maps.googleapis.com/maps/api/js?key=' . $wsl_api_key . '&libraries=places', array( 'jquery' ), WOOCOMMERCE_STORE_LOCATOR_VERSION );
				wp_register_script( 'wsl_backend_script', plugins_url( 'assets/js/backend_script.js', __FILE__ ), array( 'jquery' ), WOOCOMMERCE_STORE_LOCATOR_VERSION );
				wp_localize_script(
					'wsl_backend_script',
					'wsl',
					array(
						'ajax_url'   => admin_url( 'admin-ajax.php' ),
						'assets_url' => plugins_url( 'assets', __FILE__ ),
						'wsl_nonce'  => wp_create_nonce( 'wsl-backend-nonce' ),
					)
				);
				wp_enqueue_script( 'wsl_backend_script' );

				wp_enqueue_script( 'wsl_select2', plugins_url( 'assets/js/select2.js', __FILE__ ), array( 'jquery' ), WOOCOMMERCE_STORE_LOCATOR_VERSION );

				wp_enqueue_script( 'csvprogressbar', plugins_url( 'assets/js/csvprogressbar.js', __FILE__ ), array( 'jquery' ), WOOCOMMERCE_STORE_LOCATOR_VERSION );

				  $my_import_stores = get_option( 'my_import_stores_finder', true );

				wp_localize_script(
					'csvprogressbar',
					'myAjax',
					array(
						'ajaxurl'       => admin_url( 'admin-ajax.php' ),
						'stores_finder' => $my_import_stores,
						'wsl_nonce'     => wp_create_nonce( 'wsl-frontend-nonce' ),
					)
				);

				wp_enqueue_style( 'wsl_select2', plugins_url( 'assets/css/select2.css', __FILE__ ), array(), WOOCOMMERCE_STORE_LOCATOR_VERSION );
				wp_enqueue_script( 'wsl_timepicker', plugins_url( 'assets/js/jquery.timepicker.js', __FILE__ ), array( 'jquery' ), WOOCOMMERCE_STORE_LOCATOR_VERSION );
				wp_enqueue_style( 'wsl_timepicker', plugins_url( 'assets/css/jquery.timepicker.css', __FILE__ ), array(), WOOCOMMERCE_STORE_LOCATOR_VERSION );
				wp_enqueue_style( 'wsl_backend_style', plugins_url( 'assets/css/backend_style.css', __FILE__ ), array(), WOOCOMMERCE_STORE_LOCATOR_VERSION );
			}

		}

		private function define_constants() {

			$this->define( 'WOOCOMMERCE_STORE_LOCATOR_VERSION', $this->version );
			$this->define( 'WOOCOMMERCE_STORE_LOCATOR_SLUG', 'woocommerce-store-locator' );
			$this->define( 'WOOCOMMERCE_STORE_SETTINGS_ID', 'wsl' );
			$this->define( 'WOOCOMMERCE_STORE_LOCATOR_POSTTYPE', 'wsl_stores' );
			$this->define( 'WOOCOMMERCE_STORE_LOCATOR_POSTTYPE_REVIEWS', 'wsl_stores' );
			$this->define( 'WOOCOMMERCE_STORE_LOCATOR_TEXT_DOMAIN', 'woosl' );

			$this->define( 'WOOCOMMERCE_STORE_LOCATOR', __FILE__ );
			$this->define( 'WOOCOMMERCE_STORE_LOCATOR_ROOT', plugin_dir_path( WOOCOMMERCE_STORE_LOCATOR ) );
			$this->define( 'WOOCOMMERCE_STORE_LOCATOR_INCLUDE', plugin_dir_path( WOOCOMMERCE_STORE_LOCATOR ) . 'inc/' );
			$this->define( 'WOOCOMMERCE_STORE_LOCATOR_ASSETS', plugin_dir_url( WOOCOMMERCE_STORE_LOCATOR ) . 'assets/' );

		}

		public function load_modules() {

			$this->file( WOOCOMMERCE_STORE_LOCATOR_INCLUDE . 'admin/wsl-woocommerce-settings.php' );
			$this->file( WOOCOMMERCE_STORE_LOCATOR_INCLUDE . 'admin/wsl-product-settings.php' );
			$this->file( WOOCOMMERCE_STORE_LOCATOR_INCLUDE . 'admin/wsl-stores-settings.php' );
			$this->file( WOOCOMMERCE_STORE_LOCATOR_INCLUDE . 'admin/wsl-reviews.php' );

			$this->file( WOOCOMMERCE_STORE_LOCATOR_INCLUDE . 'frontend/wsl-single-product-page.php' );
			$this->file( WOOCOMMERCE_STORE_LOCATOR_INCLUDE . 'frontend/wsl-frontend.php' );
			$this->file( WOOCOMMERCE_STORE_LOCATOR_INCLUDE . 'frontend/wsl-comment.php' );

		}

	}
}

function woo_store_locator_plugin() {
	return Woo_Store_Locator::instance();
}
add_action( 'plugins_loaded', 'woo_store_locator_plugin' );


function wsl_admin_notice__error() {

	if ( ! class_exists( 'woocommerce' ) ) {
		$class   = 'notice notice-error';
		$message = __( 'Woo Store Finder Requires Woocommerce to be installed and activated.', 'woocommerce-store-locator' );

		printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) );
	}

}
add_action( 'admin_notices', 'wsl_admin_notice__error' );
