<?php
echo esc_html( get_header() );
wp_enqueue_script( 'wsl_map' );
$store_meta                       = get_post_meta( get_the_ID() );
$map_options['user_marker_icon']  = plugins_url( 'assets/img/', WOOCOMMERCE_STORE_LOCATOR ) . get_option( WOOCOMMERCE_STORE_SETTINGS_ID . '_start_markers', false ) . '.png';
$map_options['store_marker_icon'] = plugins_url( 'assets/img/', WOOCOMMERCE_STORE_LOCATOR ) . get_option( WOOCOMMERCE_STORE_SETTINGS_ID . '_store_markers', false ) . '.png';
$map_options['mapTypeControl']    = get_option( WOOCOMMERCE_STORE_SETTINGS_ID . '_show_map_type', false );
$map_options['scroll']            = get_option( WOOCOMMERCE_STORE_SETTINGS_ID . '_scroll_wheel_zoom', false );
$map_options['streetViewControl'] = get_option( WOOCOMMERCE_STORE_SETTINGS_ID . '_show_streetview', false );
$map_options['phone']             = get_option( WOOCOMMERCE_STORE_SETTINGS_ID . '_label_phone', false );
$map_options['email']             = get_option( WOOCOMMERCE_STORE_SETTINGS_ID . '_label_email', false );
$map_options['url']               = get_option( WOOCOMMERCE_STORE_SETTINGS_ID . '_label_url', false );

if ( $store_meta ) {
	?>
<div class="entry-content">
<div class="woo_store_locator_container <?php echo ( has_post_thumbnail() ) ? 'store_locator_has_coverImage' : 'store_locator_no_coverImage'; ?>" style="max-width:100%;">

	<?php
	$display_img = get_option( 'wsl_display_image_' );
	if ( 'yes' == $display_img ) {

		if ( has_post_thumbnail() ) {
			?>
		<div class="store_locator_header">
			<?php
			if ( has_post_thumbnail() ) {
				the_post_thumbnail( 'full' );
			}
		}
		?>
		</div>
		<?php
	}
	if ( 'no' == $display_img ) {
		?>
<div class="store_locator_body">
	<div class="store_locator_map">
		<div id="store_locatore_map" style="height: 400px;width: 100%;"></div>
	</div>
		<?php
	}
	?>
	<div class="store_locator_content">

			<div class="wsl_single_left">
				<ul class="wsl_single_store_desc">
				<?php
				if ( isset( $store_meta['wsl_stores_name'][0] ) && ! empty( $store_meta['wsl_stores_name'][0] ) ) {
					?>
					<li><h3>
					<?php
					esc_attr_e( isset( $store_meta['wsl_stores_name'][0] ) ? $store_meta['wsl_stores_name'][0] : '' );
					?>
					</h3> </li>
					<?php
				}
				if ( isset( $store_meta['wsl_stores_description'][0] ) && ! empty( $store_meta['wsl_stores_description'][0] ) ) {
					?>
					<li>
					<?php

					echo esc_attr( nl2br( ( isset( $store_meta['wsl_stores_description'][0] ) ? $store_meta['wsl_stores_description'][0] : '' ) ) );
					?>
					</li>
					
					<?Php
				}

				?>
				</ul>
			<div class="wsl_store_products">
	
			 
			<?php
			$wsl_products = get_posts(
				array(
					'post_type'      => 'product',
					'posts_per_page' => -1,
					'post_status'    => 'publish',
					'meta_query'     => array(
						array(
							'key'     => 'wsl_product_stores',
							'value'   => array( '', array(), serialize( array() ) ),
							'compare' => 'NOT IN',
						),
					),
				)
			);


			?>
					<h3 class="products-main-title main-title mb-5 text-xl text-center uppercase">Products</h3>
					<ul >
					<?php
					if ( ! empty( $wsl_products ) ) {

						foreach ( $wsl_products as $wsl_product ) {
							$product_stores = explode( ',', get_post_meta( $wsl_product->ID, 'wsl_product_stores', true ) );

							if ( is_array( $product_stores ) && in_array( get_the_ID(), $product_stores ) ) {
								$product = wc_get_product( $wsl_product->ID );
								if ( ! empty( $product ) ) {
									$product_url = $product->get_permalink();
									$product_img = get_the_post_thumbnail_url( $wsl_product->ID, 'woocommerce_thumbnail' );
									if ( empty( $product_img ) ) {
										$product_img = wc_placeholder_img_src( 'woocommerce_thumbnail' );
									}

									echo wp_kses_post( '<li><a href="' . $product_url . '"><img src="' . esc_attr( $product_img ) . '"><span class="wsl_product_title">' . esc_attr( $product->get_title() ) . '</span></a></li>' );
								}
							}
						}
					}
					?>

					</ul>
					</div>
				</div>
			
<div class="wsl_single_right">
	<?php
	if ( 'yes' != $display_img && has_post_thumbnail() ) {
		?>
		<div class="wsl_single_side_image">
		<?php
		the_post_thumbnail( 'full' );
		?>
	</div> 
		<?php
	}
	$days_hours = unserialize( $store_meta['wsl_stores_days'][0] );

	if ( ! empty( $days_hours ) ) {

		$working_hours = '<table class="woosl-working-hours"><tr><td colspan="3">Hours</td></tr>';
		// $store_days_hours = unserialize($days_hours);
		$store_days_hours = $days_hours;
		$days             = array(
			__( 'Monday', 'woosl' ),
			__( 'Tuesday', 'woosl' ),
			__( 'Wednesday', 'woosl' ),
			__( 'Thursday', 'woosl' ),
			__( 'Friday', 'woosl' ),
			__( 'Saturday', 'woosl' ),
			__( 'Sunday', 'woosl' ),
		);

		foreach ( $days as $day ) {
			$working_hours .= "<tr class='" . ( ( '1' == $store_days_hours[ $day ]['status'] ) ? 'woosl-open' : 'woosl-closed' ) . "'><td>" . $day . '</td><td>' . ( ( '1' == $store_days_hours[ $day ]['status'] ) ? __( 'Open', 'woosl' ) : __( 'Closed', 'woosl' ) ) . "</td><td><span class='woosl-start'>" . $store_days_hours[ $day ]['start'] . "</span><span class='woosl-end'>" . $store_days_hours[ $day ]['end'] . '</span></td></tr>';
		}
		$working_hours .= '</table>';

		echo wp_kses_post( $working_hours );
	}
	$store_phone = $store_meta['wsl_stores_phone'][0];
	$email       = $store_meta['wsl_stores_email'][0];
	$website     = $store_meta['wsl_stores_website'][0];
	$categories  = implode( ', ', wp_get_post_terms( get_the_id(), 'wsl_stores_categories', array( 'fields' => 'names' ) ) );
	echo '<div class="wsl-single-store-details">';
	if ( ! empty( $store_phone ) ) {
		echo wp_kses_post( '<p class="woosl-phone">Phone: <a href="tel:' . esc_attr( $store_phone ) . '">' . $store_phone . '</a> </p>' );
	}
	if ( ! empty( $email ) ) {
		echo wp_kses_post( '<p class="woosl-email">Email: <a href="mailto:' . esc_attr( $email ) . '">' . $email . '</a> </p>' );
	}
	if ( ! empty( $website ) ) {
		echo wp_kses_post( '<p class="woosl-url">Website: <a target="_blank" href="' . esc_attr( $website ) . '">' . $website . '</a> </p>' );
	}
	if ( ! empty( $categories ) ) {
		echo wp_kses_post( '<p class="woosl-categories">Categories: ' . $categories . ' </p>' );
	}
	echo '</div >';
	?>
</div>
<div style="clear:both"></div>


</div>
<div id="comments" class="comments-area">

	<?php if ( have_comments() ) : ?>
		
 
		<ol class="comment-list">
			<?php
				wp_list_comments(
					array(
						'style'       => 'div',
						'short_ping'  => true,
						'avatar_size' => 32,
					)
				);
			?>
		</ol><!-- .comment-list -->
 
		<?php
			// Are there comments to navigate through?

		if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
			?>
		<nav class="navigation comment-navigation" role="navigation">
			<h1 class="screen-reader-text section-heading"><?php html_e( 'Comment navigation', 'woosl' ); ?></h1>
			<div class="nav-previous"><?php previous_comments_link( __( '&larr; Older Comments', 'woosl' ) ); ?></div>
			<div class="nav-next"><?php next_comments_link( __( 'Newer Comments &rarr;', 'woosl' ) ); ?></div>
		</nav><!-- .comment-navigation -->
		<?php endif; // Check for comment navigation ?>
 
		<?php if ( ! comments_open() && get_comments_number() ) : ?>
		<p class="no-comments"><?php html_e( 'Comments are closed.', 'woosl' ); ?></p>
		<?php endif; ?>
 
	<?php endif; // have_comments() ?>
 
	<?php
	$store_review = get_option( 'wsl_store_review' );

	if ('yes' == $store_review ) {

		comments_template();
	}
}
get_footer();
?>

<script>
var store_locator_map_options = <?php echo json_encode( $map_options ); ?>;

	function  initializeMapFrontend( store_lat, store_lng) {
		// Detect user location
		if (navigator.geolocation) {
			navigator.geolocation.getCurrentPosition(function (position) {          
				var lat = position.coords.latitude;
				var lng = position.coords.longitude;
				var mapType = "roadmap";  
				// Display markers on map
				var store_locator_map = new google.maps.Map(document.getElementById('store_locatore_map'), {
					center: new google.maps.LatLng(store_lat, store_lng),
					mapTypeControl: Number( store_locator_map_options.mapTypeControl ),
					scrollwheel: Number( store_locator_map_options.scroll ),
					streetViewControl: Number( store_locator_map_options.streetViewControl ),
					mapTypeId:  google.maps.MapTypeId[mapType.toUpperCase()]
				});
				var bounds = new google.maps.LatLngBounds();
				var infowindow = new google.maps.InfoWindow();
				// user location display
				var user_marker = new google.maps.Marker({
					position: new google.maps.LatLng(lat, lng),
					map: store_locator_map,
					icon: store_locator_map_options.user_marker_icon
				});
				// Store location display
				var store_marker = new google.maps.Marker({
					position: new google.maps.LatLng(store_lat, store_lng),
					map: store_locator_map,
					icon: store_locator_map_options.store_marker_icon
				});
				//extend the bounds to include each marker's position
				bounds.extend(user_marker.position);
				bounds.extend(store_marker.position);
				google.maps.event.addListener(user_marker, 'click', function () {
					infowindow.setContent("<?php esc_attr_e( 'Your location', 'woosl' ); ?>");
					infowindow.open(store_locator_map, user_marker);
				});
				google.maps.event.addListener(store_marker, 'click', function () {
					infowindow.setContent("<div class='single-page-infowindow'><p><?php esc_attr_e( $store_meta['wsl_stores_name'][0] ); ?></p></div>");
					infowindow.open(store_locator_map, store_marker);
				});
				store_locator_map.fitBounds(bounds);
				// Draw the route
				directionsDisplay = new google.maps.DirectionsRenderer({suppressMarkers: true});
				var directionsService = new google.maps.DirectionsService();
				var request = {
					origin: new google.maps.LatLng(lat, lng),
					destination: new google.maps.LatLng(store_lat, store_lng),
					travelMode: google.maps.TravelMode.DRIVING
				};
				directionsService.route(request, function (response, status) {
					if (status == google.maps.DirectionsStatus.OK) {
						directionsDisplay.setDirections(response);
						directionsDisplay.setMap(store_locator_map);
					} 
				});
			}, function () {
				var bounds = new google.maps.LatLngBounds();
				var infowindow = new google.maps.InfoWindow();
				var mapType = "roadmap"; 
				var store_locator_map = new google.maps.Map(document.getElementById('store_locatore_map'), {
					center: new google.maps.LatLng(store_lat, store_lng),
					zoom: 7,
					mapTypeControl: Number( store_locator_map_options.mapTypeControl ),
					scrollwheel: Number( store_locator_map_options.scroll ),
					streetViewControl: Number( store_locator_map_options.streetViewControl ),
					mapTypeId:  google.maps.MapTypeId[mapType.toUpperCase()]
				});
				var store_marker = new google.maps.Marker({
					position: new google.maps.LatLng(store_lat, store_lng),
					map: store_locator_map,
					icon: store_locator_map_options.store_marker_icon
				});
				bounds.extend(store_marker.position);
				google.maps.event.addListener(store_marker, 'click', function () {
					infowindow.setContent("<div class='single-page-infowindow'><p><?php esc_attr_e( $store_meta['wsl_stores_name'][0] ); ?></p></div>");
					infowindow.open(store_locator_map, store_marker);
				});
				//store_locator_map.fitBounds(bounds);
			});
		} else {}
	}
	jQuery(document).ready(function (jQuery) {
		initializeMapFrontend(<?php esc_attr_e( $store_meta['wsl_stores_lat'][0] ); ?>, <?php esc_attr_e( $store_meta['wsl_stores_lng'][0] ); ?>);
	});
</script>
