<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( class_exists( 'woocommerce' ) ) {

	class Wsl_Single_Product_Page {
		public $id;

		public function __construct() {
			$this->id = 'wsl';

			add_filter( 'woocommerce_is_purchasable', array( $this, 'wsl_hide_add_to_cart' ), 10, 2 );
			add_filter( 'woocommerce_product_meta_start', array( $this, 'wsl_display_find_in_store' ) );

		}
		public function wsl_hide_add_to_cart( $return_value, $product ) {

			$hide = get_option( $this->id . '_remove_add_to_cart', false );
			if ( 'yes' == $hide ) {
				// return false; /* if we return false then purchase functionality will be removed from site */
				remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
			}
			return $return_value;
		}


		public function wsl_display_find_in_store() {

			$find_in_store_display = get_option( $this->id . '_find_in_store', false );

			$find_in_store_display = apply_filters( 'wsf_find_in_store_display', $find_in_store_display, get_the_id() );

			if ( 'yes' == $find_in_store_display ) {

				$find_in_store_label    = get_option( $this->id . '_label_find_in_store', false );
				$find_in_store_page     = get_option( $this->id . '_shortcode_page', false );
				$find_in_store_page_url = '';

				if ( empty( $find_in_store_label ) ) {
					$find_in_store_label = __( 'Find in Store', 'woosl' );
				}

				if ( ! empty( $find_in_store_page ) ) {
					$find_in_store_page_url  = get_permalink( $find_in_store_page );
					$find_in_store_page_url .= '?product_id=' . get_the_id();
				}

				?>
				<div class="wsl-find-in-store"><a class="button" href="<?php echo esc_attr( $find_in_store_page_url ); ?>" target="_blank"><?php echo esc_attr( $find_in_store_label ); ?></a></div>
				<?php
			}

		}

	}

	new Wsl_Single_Product_Page();
}
