<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Wsl_Frontend {

	public $id = WOOCOMMERCE_STORE_SETTINGS_ID;
	public function __construct() {

		add_action( 'wp_enqueue_scripts', array( $this, 'wsl_enqueue_frontend_scripts' ) ); // wp_enqueue_script
		add_shortcode( 'woo_store_locator', array( $this, 'wsl_shortcode' ) );

		add_action( 'wp_ajax_wsl_map_request', array( $this, 'wsl_map_request_callback' ) );
		add_action( 'wp_ajax_nopriv_wsl_map_request', array( $this, 'wsl_map_request_callback' ) );

	}


	public function wsl_shortcode() {

		$product_id = 0;
		$settings   = $this->wsl_get_settings();
		if ( isset( $_GET['product_id'] ) && ! empty( $_GET['product_id'] ) ) {
			$product_id = absint( $_GET['product_id'] );
		} elseif ( isset( $settings['general']['_default_product'] ) && ! empty( $settings['general']['_default_product'] ) ) {
			$product_id = absint( $settings['general']['_default_product'] );
		}

		if ( 'product' != get_post_type( $product_id ) ) {
			$product_id = 0;
		}

		if ( ! empty( $product_id ) ) {

			wp_enqueue_script( 'wsl_map' );
			wp_enqueue_script( 'wsl_frontend_script' );

			// getting all products
			/*
			$query = new WC_Product_Query( array(
				'limit' => -1,
				'orderby' => 'date',
				'order' => 'DESC',
				'return' => 'ids',
				'status' => 'publish'
			) );
			$products = $query->get_products();
			*/
			$products = get_posts(
				array(
					'post_type'      => 'product',
					'posts_per_page' => -1,
					'post_status'    => 'publish',
				)
			);

			// getting all product categories
			$terms = get_terms( $settings['general']['_categories_slug'] );

			$max_results = ( $settings['general']['_max_results'] ) ? explode( ',', trim( $settings['general']['_max_results'] ) ) : false;
			$radius      = ( $settings['general']['_radius_options'] ) ? explode( ',', trim( $settings['general']['_radius_options'] ) ) : false;

			$default_location = $settings['general']['_start_point'] . ', ' . $settings['general']['_map_region'];

			$html  = "<div class='woosl-wrap' id='woosl'>";
			$html .= "<div class='woosl-search-bar' id='woosl-search-wrap'>";
			$html .= "<div class='woosl-input woosl-inputs-fields'>";
			$html .= '<label >' . $settings['labels']['_label_your_location'] . '</label>';
			$html .= "<input type='text' id='_start_point' class='woosl-search-input _start_point woosl-input-text' value='" . $default_location . "' placeholder='" . $settings['labels']['_label_your_location'] . "'>";
			$html .= "<input type='hidden' class='_start_point_lat' >";
			$html .= "<input type='hidden' class='_start_point_lng' >";
			$html .= "<input type='hidden' class='_start_location' value='" . $default_location . "' >";
			$html .= "<input type='hidden' class='_search_lat' >";
			$html .= "<input type='hidden' class='_search_lng' >";
			// $html.="<input type='hidden' class='_product_id' value='".$product_id."' >";
			$html .= '</div>';

			if ( count( $products ) > 0 ) {
				$html .= "<div class='wsl-products woosl-inputs-fields' id='store_radius' >";
				$html .= '<label >' . $settings['labels']['_label_products'] . '</label>';
				$html .= "<select id='woosl-product' class='_product_id woosl-select'>";
				foreach ( $products as $p ) {

					if ( $p->ID == $product_id ) {
						$html .= "<option value='" . $p->ID . "' selected>" . get_the_title( $p->ID ) . '</option>';
					} else {
						$html .= "<option value='" . $p->ID . "'>" . get_the_title( $p->ID ) . '</option>';
					}
				}

				$html .= '</select></div>';
			}
			if ( $terms && 'yes' == $settings['general']['_store_category'] ) {
				$html .= "<div id='stor-pcat' class='woosl-dropdown woosl-store-cat woosl-inputs-fields'>";
				$html .= '<label >' . $settings['labels']['_label_category_filter'] . '</label>';
				$html .= "<select id='woosl-radius-dropdown' class='_stores_cat woosl-select'>";
				$html .= "<option value='0'>Select</option>";
				foreach ( $terms as $term ) {
					$html .= "<option value='" . $term->term_id . "'>" . $term->name . '</option>';
				}
				$html .= '</select></div>';
			}

			if ( $radius ) {
				$hide_class = '';
				if ( 'no' == $settings['general']['_search_radius'] ) {
					$hide_class = 'woosl-hide';
				}

				$html .= "<div id='store_radius' class='woosl-radius woosl-inputs-fields " . $hide_class . "'>";
				$html .= '<label >' . $settings['labels']['_label_search_radius'] . '</label>';
				$html .= "<select class='_radius_options wsl-select woosl-radius-dropdown' id='woosl-radius-dropdown'> ";
				foreach ( $radius as $r ) {

					if ( strpos( $r, '[' ) !== false ) {
						$html .= "<option value='" . str_replace( ']', '', str_replace( '[', '', $r ) ) . "' selected>" . str_replace( ']', '', str_replace( '[', '', $r ) ) . '</option>';
					} else {
						$html .= "<option value='" . $r . "'>" . $r . '</option>';
					}
				}

				$html .= '</select></div>';
			}

			if ( !empty( $max_results ) ) {
				$html .= "<div id='store_result' class='woosl-results woosl-inputs-fields'>";
				$html .= '<label >' . $settings['labels']['_label_results'] . '</label>';
				$html .= "<select class='_max_results woosl-select' id='wpsl-results-dropdown'>";
				foreach ( $max_results as $mr ) {

					if ( strpos( $mr, '[' ) !== false ) {
						$html .= "<option value='" . str_replace( ']', '', str_replace( '[', '', $mr ) ) . "' selected>" . str_replace( ']', '', str_replace( '[', '', $mr ) ) . '</option>';
					} else {
						$html .= "<option value='" . $mr . "'>" . $mr . '</option>';
					}
				}
				$html .= '</select></div>';
			}

			$html .= "<div class='woosl-search-btn-wrap woosl-inputs-fields'>";
			$html .= "<button id='woosl-search-btn' class='woosl-button woosl-submit'>" . $settings['labels']['_label_search'] . '</button>';
			$html .= "</div></div><div class='woosl-gmap' id='woosl-gmap' style='position: relative;    overflow: hidden;'></div><div class='woosl-maps-results' id='woosl-list'>
			<div class='woosl-results-list' id='woosl-stores'><div id='woosl-directionsPanel'></div><ul></ul></div></div></div>";

			return $html;
		}
		return ( '<p>' . __( 'You need to access the map from product page or you need to add a default product from settings', 'woosl' ) . '</p>' );
	}

	public function wsl_enqueue_frontend_scripts() {
		$settings = $this->wsl_get_settings();

		// if(isset($_GET['product_id'])){

		// $product_id = absint($_GET['product_id']);
			$wsl_api_key = get_option( WOOCOMMERCE_STORE_SETTINGS_ID . '_maps_api_key' );
			wp_register_script( 'wsl_map', 'https://maps.googleapis.com/maps/api/js?key=' . $wsl_api_key . '&libraries=places&region=' . $settings['general']['_map_region'] . '&language=' . $settings['general']['_map_language'], array( 'jquery' ), '1.0' );
			wp_register_script( 'wsl_frontend_script', plugins_url( 'assets/js/frontend_script.js', WOOCOMMERCE_STORE_LOCATOR ), array( 'jquery' ), '1.0' );

			wp_localize_script(
				'wsl_frontend_script',
				'wsl_frontend',
				array(
					'ajax_url'   => admin_url( 'admin-ajax.php' ),
					'images_url' => plugins_url( 'assets/img/', WOOCOMMERCE_STORE_LOCATOR ),
					'wsl_nonce'  => wp_create_nonce( 'wsl-ajax-nonce' ),
					'settings'   => $settings,
				)
			);

		// }
		wp_enqueue_style( 'wsl_frontend_style', plugins_url( 'assets/css/frontend_style.css', WOOCOMMERCE_STORE_LOCATOR ), array(), '1.0' );
		 wp_enqueue_style( 'dashicons' );
		 wp_enqueue_script( 'markercrysterss', plugins_url( 'assets/js/markercrysters.js', WOOCOMMERCE_STORE_LOCATOR ), array( 'jquery' ), '1.0' );

	}

	/* if radius, lat, lng are given then it will return those stores which are only within radius. otherwise it will return all the stores attached to the product*/
	public function wsl_get_stores( $product_id = 0, $radius = 0, $center_lng = 0, $center_lat = 0, $unit = '', $settings = '', $store_cat = 0 ) {

		if ( $product_id ) {

			$assigned_stores = get_post_meta( $product_id, 'wsl_product_stores', true );
			$assigned_stores = explode( ',', $assigned_stores );

			if ( ! empty( $assigned_stores ) ) {
				$stores_details = array();
				$fields_order   = get_option( 'wsl_fields_order' );
				$count          = 0;

				foreach ( $assigned_stores as $assigned_store_id ) {
					if ( empty( $assigned_store_id ) ) {
						break;
					}
					$lat = get_post_meta( $assigned_store_id, 'wsl_stores_lat', true );
					$lng = get_post_meta( $assigned_store_id, 'wsl_stores_lng', true );

					if ( empty( $lat ) || empty( $lng ) ) {
						continue;
					}
					if ( ! empty( $store_cat ) ) {
						$all_store_cat = wp_get_post_terms( $assigned_store_id, $settings['general']['_categories_slug'], array( 'fields' => 'ids' ) );

						if ( ! empty( $all_store_cat ) && is_array( $all_store_cat ) ) {
							if ( ! in_array( $store_cat, $all_store_cat ) ) {
								continue;
							}
						}
					}

					$distance = 0;
					if ( ! empty( $radius ) && ! empty( $center_lng ) && ! empty( $center_lat ) ) {
						$distance = $this->distance( $center_lat, $center_lng, $lat, $lng, $unit );
						if ( $radius < absint( $distance ) ) {
							continue;
						}
						$stores_details[ $count ]['wsl_stores_distance'] = $distance;
					}

					$store_name = get_post_meta( $assigned_store_id, 'wsl_stores_name', true );

					$stores_details[ $count ]['wsl_stores_name']       = $store_name;
					$stores_details[ $count ]['wsl_stores_lat']        = $lat;
					$stores_details[ $count ]['wsl_stores_lng']        = $lng;
					$stores_details[ $count ]['wsl_stores_id']         = $assigned_store_id;
					$stores_details[ $count ]['wsl_stores_infowindow'] = $this->info_window_content( $assigned_store_id, $store_name, $lat, $lng, $settings );

					if ( ! empty( $fields_order ) ) {
						$stores_details[ $count ]['wsl_stores_list'] = $this->wsl_map_list_items_by_field_order( $assigned_store_id, $lat, $lng, $store_name, $distance, $unit, $settings, $fields_order );
					} else {
						$stores_details[ $count ]['wsl_stores_list'] = $this->wsl_map_list_items( $assigned_store_id, $lat, $lng, $store_name, $distance, $unit, $settings );
					}

					$count++;
				}

				if ( ! empty( $stores_details ) ) {

					usort(
						$stores_details,
						function( $a, $b ) {
							// return $a['wsl_stores_distance'] <=> $b['wsl_stores_distance'];
							if ( $a['wsl_stores_distance'] == $b['wsl_stores_distance'] ) {
								return 0;
							}
							return ( $a['wsl_stores_distance'] < $b['wsl_stores_distance'] ) ? -1 : 1;
						}
					);

					return $stores_details;
				}
			}
		}

		return false;

	}

	public function info_window_content( $assigned_store_id, $store_name, $lat, $lng, $settings ) {

		$content  = "<div data-store-id='" . $assigned_store_id . "' class='woosl-infowindow'>";
		$content .= get_option( 'wsl_stores_info', true );
		// $tag = get_bloginfo( 'name' );
		// $sitename =  str_replace('{test}', $tag, $content);
		// str_replace("world","Peter","Hello world!");
		if ( strpos( $content, '{title}' ) !== false ) {
			$title = '';

			if ( 'yes' == $settings['general']['_enable_permalink'] ) {
				$title = "<a class='info-storename' target='_blank' href='" . get_permalink( $assigned_store_id ) . "'>" . $store_name . '</a>';
			} else {
				$title = $store_name;
			}
			$content = str_replace( '{title}', $title, $content );
		}
		if ( strpos( $content, '{address}' ) !== false ) {
			// str_replace('{address}',$content,$content
			$address = get_post_meta( $assigned_store_id, 'wsl_stores_address', true );

			if ( ! empty( $address ) ) {
				$content = str_replace( '{address}', $address, $content );
			} else {
				$content = str_replace( '{address}', '', $content );
			}
		}

		if ( strpos( $content, '{website}' ) !== false ) {

			$website = get_post_meta( $assigned_store_id, 'wsl_stores_website', true );
			if ( ! empty( $website ) ) {
				$content = str_replace( '{website}', $website, $content );
			} else {
				$content = str_replace( '{website}', '', $content );
			}
		}
		if ( strpos( $content, '{city}' ) !== false ) {
			$city = get_post_meta( $assigned_store_id, 'wsl_stores_city', true );
			if ( ! empty( $city ) ) {
				$content = str_replace( '{city}', $city, $content );
			} else {
				$content = str_replace( '{city}', '', $content );
			}
		}
		if ( strpos( $content, '{country}' ) !== false ) {
			$country = get_post_meta( $assigned_store_id, 'wsl_stores_country', true );
			if ( ! empty( $country ) ) {
				$content = str_replace( '{country}', $country, $content );
			} else {
				$content = str_replace( '{country}', '', $content );
			}
		}
		if ( strpos( $content, '{postal_code}' ) !== false ) {
			$postal_code = get_post_meta( $assigned_store_id, 'wsl_stores_zipcode', true );
			if ( ! empty( $postal_code ) ) {
				$content = str_replace( '{postal_code}', $postal_code, $content );
			} else {
				$content = str_replace( '{postal_code}', '', $content );
			}
		}
		if ( strpos( $content, '{phone}' ) !== false ) {
			$phone = get_post_meta( $assigned_store_id, 'wsl_stores_phone', true );
			if ( ! empty( $phone ) ) {
				$content = str_replace( '{phone}', $phone, $content );
			} else {
				$content = str_replace( '{phone}', '', $content );
			}
		}
		if ( strpos( $content, '{email}' ) !== false ) {
			$email = get_post_meta( $assigned_store_id, 'wsl_stores_email', true );
			if ( ! empty( $email ) ) {
				$content = str_replace( '{email}', $email, $content );
			} else {
				$content = str_replace( '{email}', '', $content );
			}
		}
		if ( strpos( $content, '{description}' ) !== false ) {

			$description = get_post_meta( $assigned_store_id, 'wsl_stores_description', true );
			if ( ! empty( $description ) ) {
				$content = str_replace( '{description}', $description, $content );
			} else {
				$content = str_replace( '{description}', '', $content );
			}
		}
		if ( strpos( $content, '{get_direction}' ) !== false ) {
			$get_direction .= "<div class='woosl-actions'><a class='woosl-store-direction' onclick='show_store_direction(" . $lat . ', ' . $lng . ")'>" . $settings['labels']['_label_get_directions'] . '</a></div>';
			if ( ! empty( $get_direction ) ) {
				$content = str_replace( '{get_direction}', $get_direction, $content );
			} else {
				$content = str_replace( '{get_direction}', '', $content );
			}
		}
		if ( strpos( $content, '{rating}' ) !== false ) {

			global $wpdb;
			$post_type = 'wsl_stores';
			$rating = $wpdb->get_results( $wpdb->prepare( "SELECT 
			SUM(commentmeta.meta_value) as sum_of_ratings, 
			COUNT(commentmeta.meta_value) as no_of_ratings 
			FROM 
			`{$wpdb->prefix}commentmeta` as commentmeta 
			INNER JOIN `{$wpdb->prefix}comments` as comments ON comments.comment_ID = commentmeta.comment_id
			WHERE 
			commentmeta.meta_key LIKE %s AND 
			comments.comment_post_ID = %d AND 
			comments.comment_approved = 1", '%rating%', $assigned_store_id ) );

			if ( ! empty( $rating ) && isset( $rating[0]->no_of_ratings) && ! empty( $rating[0]->no_of_ratings ) ) {
				$defaults = array(
					'rating' => ( $rating[0]->sum_of_ratings / $rating[0]->no_of_ratings ),
					'type'   => 'rating',
					'number' => $rating[0]->no_of_ratings,
					'echo'   => false,
				);
			
				$store_review = get_option( 'wsl_store_review' );
				if ( 'yes' == $store_review ) {

					$rating_html  = wp_star_rating( $defaults );
					$rating_html .= '<span class="total_reviews"> ( ' . ( $rating[0]->sum_of_ratings / $rating[0]->no_of_ratings ) . ' /5 )</span>';
					$content      = str_replace( '{rating}', $rating_html, $content );
				} else {
					$content = str_replace( '{rating}', '<strong>Please enable checkbox from store setting to view RATINGS </strong>', $content );
				}
			} else {

				$content = str_replace( '{rating}', '', $content );
			}
		}
			// ($rating[0]->sum_of_ratings)/($rating[0]->no_of_ratings)
		$content .= '<div class ="div_info_btn">
						<button class ="info_btn"><a style="color: white" onclick="show_store_direction(' . $lat . ', ' . $lng . ')" style="cursor:pointer;">' . esc_html__( $settings['labels']['_label_get_directions'], 'woosl' ) . '</a></button>
						<button class ="info_btn"><a style="color: white" href= "' . esc_url( get_permalink( $assigned_store_id ) ) . '"target="_blank">VIEW DETAILS</a></button>
					</div>';
		return $content;
	}

	public function wsl_get_settings() {
		$settings = array();

		$settings['general']['_maps_api_key']      = get_option( $this->id . '_maps_api_key', false );
		$settings['general']['_map_language']      = get_option( $this->id . '_map_language', false );
		$settings['general']['_map_region']        = get_option( $this->id . '_map_region', false );
		$settings['general']['_search_radius']     = get_option( $this->id . '_search_radius', false );
		$settings['general']['_store_category']    = get_option( $this->id . '_store_category', false );
		$settings['general']['_distance_unit']     = get_option( $this->id . '_distance_unit', false );
		$settings['general']['_max_results']       = get_option( $this->id . '_max_results', false );
		$settings['general']['_radius_options']    = get_option( $this->id . '_radius_options', false );
		$settings['general']['_locate_user']       = get_option( $this->id . '_locate_user', false );
		$settings['general']['_start_point']       = get_option( $this->id . '_start_point', false );
		$settings['general']['_distance_unit']     = get_option( $this->id . '_distance_unit', false );
		$settings['general']['_show_map_type']     = get_option( $this->id . '_show_map_type', false );
		$settings['general']['_scroll_wheel_zoom'] = get_option( $this->id . '_scroll_wheel_zoom', false );
		$settings['general']['_enable_permalink']  = get_option( $this->id . '_enable_permalink', false );
		$settings['general']['_stores_slug']       = get_option( $this->id . '_stores_slug', false );
		$settings['general']['_categories_slug']   = get_option( $this->id . '_categories_slug', false );
		$settings['general']['_start_markers']     = get_option( $this->id . '_start_markers', false );
		$settings['general']['_store_markers']     = get_option( $this->id . '_store_markers', false );
		$settings['general']['_show_streetview']   = get_option( $this->id . '_show_streetview', false );
		$settings['general']['_default_product']   = get_option( $this->id . '_default_product', false );
		$settings['general']['_show_map_cluster']  = get_option( $this->id . '_show_map_cluster', false );

		$settings['single_product']['_find_in_store']       = get_option( $this->id . '_find_in_store', false );
		$settings['single_product']['_remove_add_to_cart']  = get_option( $this->id . '_remove_add_to_cart', false );
		$settings['single_product']['_label_find_in_store'] = get_option( $this->id . '_label_find_in_store', false );
		$settings['single_product']['_shortcode_page']      = get_option( $this->id . '_shortcode_page', false );

		$settings['labels']['_label_your_location']            = get_option( $this->id . '_label_your_location', false );
		$settings['labels']['_label_search_radius']            = get_option( $this->id . '_label_search_radius', false );
		$settings['labels']['_label_no_results_found']         = get_option( $this->id . '_label_no_results_found', false );
		$settings['labels']['_label_search']                   = get_option( $this->id . '_label_search', false );
		$settings['labels']['_label_searching_preloader_text'] = get_option( $this->id . '_label_searching_preloader_text', false );
		$settings['labels']['_label_results']                  = get_option( $this->id . '_label_results', false );
		$settings['labels']['_label_category_filter']          = get_option( $this->id . '_label_category_filter', false );
		$settings['labels']['_label_more_info']                = get_option( $this->id . '_label_more_info', false );
		$settings['labels']['_label_phone']                    = get_option( $this->id . '_label_phone', false );
		$settings['labels']['_label_email']                    = get_option( $this->id . '_label_email', false );
		$settings['labels']['_label_url']                      = get_option( $this->id . '_label_url', false );
		$settings['labels']['_label_hours']                    = get_option( $this->id . '_label_hours', false );
		$settings['labels']['_label_start_location']           = get_option( $this->id . '_label_start_location', false );
		$settings['labels']['_label_get_directions']           = get_option( $this->id . '_label_get_directions', false );
		$settings['labels']['_label_no_directions_found']      = get_option( $this->id . '_label_no_directions_found', false );
		$settings['labels']['_label_back']                     = get_option( $this->id . '_label_back', false );
		$settings['labels']['_label_street_view']              = get_option( $this->id . '_label_street_view', false );
		$settings['labels']['_label_general_error']            = get_option( $this->id . '_label_general_error', false );
		$settings['labels']['_label_query_limit_error']        = get_option( $this->id . '_label_query_limit_error', false );
		$settings['labels']['_label_products']                 = get_option( $this->id . '_label_products', false );

		return $settings;

	}

	public function wsl_map_request_callback() {
	
		if ( isset( $_POST['wsl_nonce'] ) && ! wp_verify_nonce( sanitize_text_field( $_POST['wsl_nonce'] ), 'wsl-ajax-nonce' ) ) {
			wp_send_json_error( __( 'Oops! something went wrong', 'woosl' ) );
			// wp_die("Busted");
		}

		$product_id  = ( isset( $_POST['product_id'] ) ? absint( $_POST['product_id'] ) : '' );
		$center_lat  = ( isset( $_POST['start_point_lat'] ) ? sanitize_text_field( $_POST['start_point_lat'] ) : '' );
		$center_lng  = ( isset( $_POST['start_point_lng'] ) ? sanitize_text_field( $_POST['start_point_lng'] ) : '' );
		$unit        = ( isset( $_POST['unit'] ) ? sanitize_text_field( $_POST['unit'] ) : '' );
		$radius      = ( isset( $_POST['radius'] ) ? absint( $_POST['radius'] ) : '' );
		$max_results = ( isset( $_POST['max_results'] ) ? absint( $_POST['max_results'] ) : '' );
		$store_cat   = ( isset( $_POST['store_cat'] ) ? absint( $_POST['store_cat'] ) : '' );
		$settings    = $this->wsl_get_settings();

	

		if ( ! empty( $product_id ) && ! empty( $center_lat ) && ! empty( $center_lng ) && ! empty( $radius ) ) {

			$stores = $this->wsl_get_stores( $product_id, $radius, $center_lng, $center_lat, $unit, $settings, $store_cat );


			if ( ! empty( $stores ) && ! empty( $max_results ) ) {
				$stores = array_slice( $stores, 0, $max_results );
			}

			$stores_details = array(
				'stores' => $stores,
			);
				echo json_encode( $stores_details );
				wp_die();
		}

		wp_send_json_error( __( $settings['labels']['_label_general_error'], 'woosl' ) );

	}

	public function distance( $lat1, $lon1, $lat2, $lon2, $unit = 'km' ) {
		$theta = $lon1 - $lon2;
		$dist  = sin( deg2rad( $lat1 ) ) * sin( deg2rad( $lat2 ) ) + cos( deg2rad( $lat1 ) ) * cos( deg2rad( $lat2 ) ) * cos( deg2rad( $theta ) );
		$dist  = acos( $dist );
		$dist  = rad2deg( $dist );
		$miles = $dist * 60 * 1.1515;
		$unit  = strtolower( $unit );
		if ( 'km' == $unit ) { /* Kilometers */
			return ( $miles * 1.609344 );
		} elseif ( 'nm' == $unit ) { /* Nautical Miles */
			return ( $miles * 0.8684 );
		} else { /* Miles */
			return $miles;
		}
	}



	public function wsl_map_list_items( $store_id, $lat, $lng, $store_name, $distance, $unit, $settings ) {
		global $wpdb;
		$rating_html = '';
		$rating = $wpdb->get_results( $wpdb->prepare( "SELECT 
			SUM(commentmeta.meta_value) as sum_of_ratings, 
			COUNT(commentmeta.meta_value) as no_of_ratings 
			FROM 
			`{$wpdb->prefix}commentmeta` as commentmeta 
			INNER JOIN `{$wpdb->prefix}comments` as comments ON comments.comment_ID = commentmeta.comment_id
			WHERE 
			commentmeta.meta_key LIKE %s AND 
			comments.comment_post_ID = %d AND 
			comments.comment_approved = 1", '%rating%', $store_id ) );
		if ( ! empty( $rating ) && isset( $rating[0]->no_of_ratings) && ! empty( $rating[0]->no_of_ratings ) ) {
			$defaults    = array(
				'rating' => ( $rating[0]->sum_of_ratings / $rating[0]->no_of_ratings ),
				'type'   => 'rating',
				'number' => $rating[0]->no_of_ratings,
				'echo'   => false,
			);
			$rating_html = wp_star_rating( $defaults );
		}
		// $dir_type=!empty($map_options['direction']) ? $map_options['direction'] : 'detail';
		$dir_type   = 'detail';
		$list_item  = '';
		$list_item .= '<li class="store store-locator-item " data-distance="' . $distance . '" data-store-id="' . $store_id . '" id="list-item-' . ( $store_id ) . '" >';

		$address      = get_post_meta( $store_id, 'wsl_stores_address', true );
		$list_item   .= '<div class="woosl-store-location">';
		$list_item   .= '<p>';
		$store_review = get_option( 'wsl_store_review' );
		if ( 'yes' == $settings['general']['_enable_permalink'] ) {
			$store_title = '<strong><a href="' . esc_url( get_permalink( $store_id ) ) . '" target="_blank">' . $store_name . '</a></strong>';
		} else {
			$store_title = $store_name;
		}

		$list_item .= '<input type="hidden" id="store-address-' . $store_id . '" class="store-address" value="' . esc_attr( $address ) . '" />';
		$list_item .= '<strong>' . $store_title . '</strong>';
		// if(has_post_thumbnail($store_id))
		// {
		// $list_item .= '<div class="wsl-image">'.get_the_post_thumbnail($store_id, 'post-thumbnail', '' ).'</div>';
		// }
		if ( 'yes' == $store_review ) {
			$list_item .= '<span >' . $rating_html . '</span>';
		}
		$list_item .= '<span class="woosl-street">' . $address . '</span>';
		$list_item .= '<span>' . get_post_meta( $store_id, 'wsl_stores_city', true ) . ', ' . get_post_meta( $store_id, 'wsl_stores_zipcode', true ) . '</span>';

		$list_item .= '<span class="woosl-country">' . get_post_meta( $store_id, 'wsl_stores_country', true ) . '</span>';
		$list_item .= '</p> </div>';

		$list_item .= '<div class="woosl-direction-wrap">';
		$list_item .= '' . number_format( $distance, 2 ) . ' ' . $unit;

		$list_item .= $this->get_direction_link( $lat, $lng, $dir_type, $settings ); // detail or gmap

		$store_phone = get_post_meta( $store_id, 'wsl_stores_phone', true );
		$website     = get_post_meta( $store_id, 'wsl_stores_website', true );
		$days_hours  = get_post_meta( $store_id, 'wsl_stores_days', true );
		$email       = get_post_meta( $store_id, 'wsl_stores_email', true );
		$dispay_hour = get_option( 'wsl_display_store_hour' );
		$more_info   = '';

		if ( ! empty( $store_phone ) || ! empty( $website ) || ! empty( $days ) || ! empty( $email ) ) {
			$more_info .= '<p><a onClick="showhide_moreinfo(' . $store_id . ')" class="woosl-store-details woosl-store-listing">' . $settings['labels']['_label_more_info'] . '</a></p>';
			$more_info .= '<div id="woosl-moreinfo-' . $store_id . '" class="woosl-moreinfo woosl-hide" >';
			if ( ! empty( $store_phone ) ) {
				$more_info .= '<p class="woosl-phone">' . __( $settings['labels']['_label_phone'], 'woosl' ) . ': <a href="tel:' . esc_attr( $store_phone ) . '">' . $store_phone . '</a> </p>';
			}
			if ( ! empty( $email ) ) {
				$more_info .= '<p class="woosl-email">' . __( $settings['labels']['_label_email'], 'woosl' ) . ': <a href="mailto:' . esc_attr( $email ) . '">' . $email . '</a> </p>';
			}
			if ( ! empty( $website ) ) {
				$more_info .= '<p class="woosl-url">' . __( $settings['labels']['_label_url'], 'woosl' ) . ': <a target="_blank" href="' . esc_attr( $website ) . '">' . $website . '</a> </p>';
			}
			if ( ! empty( $days_hours ) && 'yes' == $dispay_hour  ) {

				$working_hours = "<table class='woosl-working-hours'><tr><td colspan='3'>" . __( $settings['labels']['_label_hours'], 'woosl' ) . '</td></tr>';
				// $store_days_hours = unserialize($days_hours);
				$store_days_hours = $days_hours;
				$days             = array(
					__( 'Monday', 'woosl' ),
					__( 'Tuesday', 'woosl' ),
					__( 'Wednesday', 'woosl' ),
					__( 'Thursday', 'woosl' ),
					__( 'Friday', 'woosl' ),
					__( 'Saturday', 'woosl' ),
					__( 'Sunday', 'woosl' ),
				);

				foreach ( $days as $day ) {
					$working_hours .= "<tr class='" . ( ( '1' == $store_days_hours[ $day ]['status'] ) ? 'woosl-open' : 'woosl-closed' ) . "'><td>" . $day . '</td><td>' . ( ( '1' == $store_days_hours[ $day ]['status'] ) ? __( 'Open', 'woosl' ) : __( 'Closed', 'woosl' ) ) . "</td><td><span class='woosl-start'>" . $store_days_hours[ $day ]['start'] . "</span><span class='woosl-end'>" . $store_days_hours[ $day ]['end'] . '</span></td></tr>';
				}
				$working_hours .= '</table>';

				$more_info .= $working_hours;
			}
		}

		$list_item .= $more_info;
		$list_item .= '</div></li>';
		return $list_item;
	}

	public function wsl_map_list_items_by_field_order( $store_id, $lat, $lng, $store_name, $distance, $unit, $settings, $fields_order ) {

		$dir_type   = 'detail';
		$list_item  = '';
		$list_item .= '<li class="store store-locator-item " data-distance="' . $distance . '" data-store-id="' . $store_id . '" id="list-item-' . ( $store_id ) . '" >';
		$list_item .= '<input type="hidden" id="store-address-' . $store_id . '" class="store-address" value="' . esc_attr( $address ) . '" />';

		foreach ( $fields_order as $section => $field ) {

			$list_item .= $this->wsl_get_fields_by_section( $section, $fields_order, $store_id, $store_name, $distance, $unit, $settings );
		}
		$list_item .= '</li>';
		return $list_item;
	}

	public function wsl_get_fields_by_section( $section = '', $fields_order = array(), $store_id = '', $store_name = '', $distance = '', $unit = '', $settings = array() ) {

		$response = '';
		if ( ! empty( $section ) && isset( $fields_order[ $section ] ) && ! empty( $fields_order[ $section ] ) ) {

			if ( 'wsl_general-fields' == $section ) {
				$response .= '<div class="wsl_general-fields">';
				foreach ( $fields_order[ $section ] as $field ) {
					$response .= $this->wsl_get_field_html_by_name( $store_id, $field, $settings, $distance, $unit, $store_name );
				}
				$response .= '</div>';
			} elseif ( 'wsl_address-fields' == $section ) {
				$response .= '<div class="wsl_address-fields">';
				foreach ( $fields_order[ $section ] as $field ) {
					$response .= $this->wsl_get_field_html_by_name( $store_id, $field, $settings, $distance, $unit, $store_name );
				}
				$response .= '</div>';
			} elseif ( 'wsl_more-info-fields' == $section ) {
				$response .= '<div class="wsl_more-info-fields">';
				$response .= '<p><a onClick="showhide_moreinfo(' . $store_id . ')" class="woosl-store-details woosl-store-listing">' . $settings['labels']['_label_more_info'] . '</a></p>';
				$response .= '<div id="woosl-moreinfo-' . $store_id . '" class="woosl-moreinfo woosl-hide" >';
				foreach ( $fields_order[ $section ] as $field ) {
					$response .= $this->wsl_get_field_html_by_name( $store_id, $field, $settings, $distance, $unit, $store_name );
				}
				$response .= '</div></div>';
			}
		}
		return $response;
	}

	public function wsl_get_field_html_by_name( $store_id = 0, $field = '', $settings = '', $distance = '', $unit = '', $store_name = '' ) {

		$field_html = '';
		if ( ! empty( $field ) && ! empty( $store_id ) ) {

			if ( 'wsl_phone' == $field ) {
				$field_value = get_post_meta( $store_id, 'wsl_stores_phone', true );
				if ( ! empty( $field_value ) ) {
					$field_html = '<p class="woosl-phone">' . $settings['labels']['_label_phone'] . ': <a href="tel:' . esc_attr( $field_value ) . '">' . $field_value . '</a> </p>';
				}
			} elseif ( 'wsl_country' == $field ) {
				$field_value = get_post_meta( $store_id, 'wsl_stores_country', true );
				if ( ! empty( $field_value ) ) {
					$field_html = '<span class="woosl-country">' . $field_value . '</span>';
				}
			} elseif ( 'wsl_url' == $field ) {
				$field_value = get_post_meta( $store_id, 'wsl_stores_website', true );
				if ( ! empty( $field_value ) ) {
					$field_html = '<p class="woosl-url">' . $settings['labels']['_label_url'] . ': <a target="_blank" href="' . esc_attr( $field_value ) . '">' . $field_value . '</a> </p>';
				}
			} elseif ( 'wsl_get-directions' == $field ) {
				$dir_type    = 'detail';
				$lat         = get_post_meta( $store_id, 'wsl_stores_lat', true );
				$lng         = get_post_meta( $store_id, 'wsl_stores_lng', true );
				$field_html  = '<p class="woosl-direction-wrap">';
				$field_html .= $this->get_direction_link( $lat, $lng, $dir_type, $settings );
				$field_html .= '</p>';
			} elseif ( 'wsl_distance' == $field ) {

				$field_html  = '<p class="woosl-distance-wrap">';
				$field_html .= '' . number_format( $distance, 2 ) . ' ' . $unit;
				$field_html .= '</p>';

			} elseif ( 'wsl_name' == $field ) {
				if ( 'yes' == $settings['general']['_enable_permalink'] ) {
					$field_html = '<p class="woosl-name"><strong><a href="' . esc_url( get_permalink( $store_id ) ) . '" target="_blank">' . $store_name . '</a></strong></p>';
				} else {
					$field_html = '<p class="woosl-name">' . $store_name . '</p>';
				}
			} elseif ( 'wsl_email' == $field ) {
				$field_value = get_post_meta( $store_id, 'wsl_stores_email', true );
				if ( ! empty( $field_value ) ) {
					$field_html = '<p class="woosl-email">' . $settings['labels']['_label_email'] . ': <a href="mailto:' . esc_attr( $field_value ) . '">' . $field_value . '</a> </p>';
				}
			} elseif ( 'wsl_zipcode' == $field ) {
				$field_value = get_post_meta( $store_id, 'wsl_stores_zipcode', true );
				if ( ! empty( $field_value ) ) {
					$field_html = '<span class="woosl-zipcode">' . $field_value . '</span>';
				}
			} elseif ( 'wsl_city' == $field ) {
				$field_value = get_post_meta( $store_id, 'wsl_stores_city', true );
				if ( ! empty( $field_value ) ) {
					$field_html = '<span class="woosl-city">' . $field_value . '</span>';
				}
			} elseif ( 'wsl_hours' == $field ) {
				$days_hours    = get_post_meta( $store_id, 'wsl_stores_days', true );
				$working_hours = "<div class='woosl-working-hours'><table class='woosl-working-hours'><tr><td colspan='3'>" . $settings['labels']['_label_hours'] . '</td></tr>';
				// $store_days_hours = unserialize($days_hours);
				$store_days_hours = $days_hours;
				$days             = array(
					__( 'Monday', 'woosl' ),
					__( 'Tuesday', 'woosl' ),
					__( 'Wednesday', 'woosl' ),
					__( 'Thursday', 'woosl' ),
					__( 'Friday', 'woosl' ),
					__( 'Saturday', 'woosl' ),
					__( 'Sunday', 'woosl' ),
				);

				foreach ( $days as $day ) {
					$working_hours .= "<tr class='" . ( ( '1' == $store_days_hours[ $day ]['status'] ) ? 'woosl-open' : 'woosl-closed' ) . "'><td>" . $day . '</td><td>' . ( ( '1' == $store_days_hours[ $day ]['status'] ) ? __( 'Open', 'woosl' ) : __( 'Closed', 'woosl' ) ) . "</td><td><span class='woosl-start'>" . $store_days_hours[ $day ]['start'] . "</span><span class='woosl-end'>" . $store_days_hours[ $day ]['end'] . '</span></td></tr>';
				}
				$working_hours .= '</table></div>';

				$field_html = $working_hours;

			} elseif ( 'wsl_street-address' == $field ) {
				$field_value = get_post_meta( $store_id, 'wsl_stores_address', true );
				if ( ! empty( $field_value ) ) {
					$field_html = '<span class="woosl-street">' . $field_value . '</span>';
				}
			}
		}
		return $field_html;
	}

	public function get_direction_link( $lat, $lng, $type, $settings ) {
		if ( 'gmap' == $type ) {
			return '<a class="woosl-directions" href="https://www.google.com/maps?daddr=' . $lat . ',' . $lng . '" target="_blank">' . esc_html__( $settings['labels']['_label_get_directions'], 'woosl' ) . '</a>';
		} else {
			return '<a class="woosl-directions" onclick="show_store_direction(' . $lat . ', ' . $lng . ')" style="cursor:pointer;">' . esc_html__( $settings['labels']['_label_get_directions'], 'woosl' ) . '</a>';
		}
	}
}

new Wsl_Frontend();
