<?php
// Actions
add_action( 'comment_form_logged_in_after', 'wsl_comment_rating_rating_field' );
add_action( 'comment_form_after_fields', 'wsl_comment_rating_rating_field' );
add_action( 'comment_post', 'wsl_comment_rating_save_comment_rating' );

// Filters
add_filter( 'preprocess_comment', 'ci_comment_rating_require_rating' );
add_filter( 'comment_text', 'ci_comment_rating_display_rating' );

// Create the rating interface.

function wsl_comment_rating_rating_field() {

	if ( is_singular('wsl_stores') ) {
		?>
	<?php wp_nonce_field( 'store_comment_nonce', 'store_comment_form' ); ?>
	<label for="rating">Rating<span class="required">*</span></label>
	<fieldset class="comments-rating">
		<span class="rating-container">
			<?php for ( $i = 5; $i >= 1; $i-- ) : ?>
				<input type="radio" id="rating-<?php echo esc_attr( $i ); ?>" name="rating" value="<?php echo esc_attr( $i ); ?>" /><label for="rating-<?php echo esc_attr( $i ); ?>"><?php echo esc_html( $i ); ?></label>
			<?php endfor; ?>
			<input type="radio" id="rating-0" class="star-cb-clear" name="rating" value="0" /><label for="rating-0">0</label>
		</span>
	</fieldset>
		<?php
	}
}

function wsl_comment_rating_save_comment_rating( $comment_id ) {
	if ( ( isset( $_POST['rating'] ) ) && ( '' !== $_POST['rating'] ) && isset( $_POST['store_comment_form'] ) && wp_verify_nonce( sanitize_text_field( $_POST['store_comment_form'] ), 'store_comment_nonce' )) {
		$rating = intval( $_POST['rating'] );
	}
	add_comment_meta( $comment_id, 'rating', $rating );
}


function ci_comment_rating_require_rating( $commentdata ) {
	if (   isset( $_POST['store_comment_form'] ) && wp_verify_nonce( sanitize_text_field( $_POST['store_comment_form'] ), 'store_comment_nonce' ) && ! is_admin() && ( ! isset( $_POST['rating'] ) || 0 === intval( $_POST['rating'] ) )  ) {
		echo esc_html( wp_die( __( 'Error: You did not add a rating. Hit the Back button on your Web browser and resubmit your comment with a rating.' ) ) );
	}
	return $commentdata;
}


function ci_comment_rating_display_rating( $comment_text ) {
	$rating = get_comment_meta( get_comment_ID(), 'rating', true );
	$stars = '<p class="stars">';
	for ( $i = 1; $i <= $rating; $i++ ) {
		$stars .= '<span class="dashicons dashicons-star-filled"></span>';
	}
	$stars       .= '</p>';
	$comment_text = $comment_text . $stars;
	return $comment_text;

}



