<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WC_Settings_MyPlugin' ) ) :

	function wsl_add_settings() {

		/**
		 * Settings class
		 *
		 * @since 1.0.0
		 */
		class WC_Settings_MyPlugin extends WC_Settings_Page {

			/**
			 * Setup settings class
			 *
			 * @since  1.0
			 */
			public function __construct() {

				$this->id    = WOOCOMMERCE_STORE_SETTINGS_ID;
				$this->label = __( 'Store Locator', 'woosl' );

				add_filter( 'woocommerce_settings_tabs_array', array( $this, 'add_settings_page' ), 20 );
				add_action( 'woocommerce_settings_' . $this->id, array( $this, 'output' ) );
				add_action( 'woocommerce_settings_save_' . $this->id, array( $this, 'save' ) );
				add_action( 'woocommerce_sections_' . $this->id, array( $this, 'output_sections' ) );
				add_action( 'woocommerce_admin_field_csv_files', array( $this, 'import_store_finder_page_callback_woo' ) );
				add_action( 'woocommerce_admin_field_info_files', array( $this, 'funct_store_info_files' ) );
				add_action( 'save_post', 'funct_store_info_files' );

				// X-X-X-X- EXPORT CSV X-X-X-X

				// add_action('admin_post_printSales.csv', array($this,'export_sales_manager_csv'));
			}

			/**
			 * Get sections
			 *
			 * @return array
			 */

			public function get_sections() {

				$sections = array(
					'general'        => __( 'General Settings', 'woosl' ),

					'single_product' => __( 'Single Product', 'woosl' ),

					'labels'         => __( 'Labels', 'woosl' ),

					'imp_csv'        => __( 'Import/Export', 'woosl' ),

					'info_window'    => __( 'Info-Window', 'woosl' ),
				);

				return apply_filters( 'woocomrce_get_sections_' . $this->id, $sections );
			}

			/**
			 * Get settings array
			 *
			 * @since 1.0.0
			 * @param string $current_section Optional. Defaults to empty string.
			 * @return array Array of settings
			 */
			public function get_settings( $current_section = '' ) {

				if ( 'single_product' == $current_section ) {

					$pages = get_pages();

					$pages_options = array();
					foreach ( $pages as $page ) {
						$pages_options[ $page->ID ] = $page->post_title;
					}

					/**
					 * Filter Plugin Section 2 Settings
					 *
					 * @since 1.0.0
					 * @param array $settings Array of the plugin settings
					 */
					$settings = apply_filters(
						$this->id . '_single_product_settings',
						array(

							array(
								'name' => __( 'Single Product Settings', 'woosl' ),
								'type' => 'title',
								'desc' => '',
								'id'   => $this->id . '_product_settings',
							),

							array(
								'type'    => 'checkbox',
								'id'      => $this->id . '_find_in_store',
								'name'    => __( 'Display Find in Store button', 'woosl' ),
								'default' => 'yes',
							),

							array(
								'type'    => 'checkbox',
								'id'      => $this->id . '_remove_add_to_cart',
								'name'    => __( 'Remove Add to cart button', 'woosl' ),
								'default' => 'no',
								'desc'    => __( 'This will remove add to cart button from single product page', 'woosl' ),
							),

							array(
								'name'    => __( 'Find in Store button label', 'woosl' ),
								'id'      => $this->id . '_label_find_in_store',
								'type'    => 'text',
								'default' => 'Find in Store',
							),

							array(
								'type'    => 'select',
								'id'      => $this->id . '_shortcode_page',
								'name'    => __( 'Store Locator Shortcode', 'woosl' ),
								'options' => $pages_options,
								'class'   => 'wc-enhanced-select',
								'desc'    => __( 'Select page on which Store Locator shortcode is placed', 'woosl' ),
							),

							array(
								'type' => 'sectionend',
								'id'   => $this->id . '_product_settings',
							),

						)
					);

				} elseif ( 'labels' == $current_section ) {

					$settings = apply_filters(
						$this->id . '_labels_settings',
						array(

							// label settings start

							array(
								'name' => __( 'Label Options', 'woosl' ),
								'type' => 'title',
								'desc' => '',
								'id'   => $this->id . '_label_options',
							),

							array(
								'name'     => __( 'Your Location', 'woosl' ),
								'desc_tip' => __( 'Your Location', 'woosl' ),
								'id'       => $this->id . '_label_your_location',
								'type'     => 'text',
								'default'  => 'Your Location',
							),
							array(
								'name'     => __( 'Search Radius', 'woosl' ),
								'desc_tip' => __( 'Search Radius', 'woosl' ),
								'id'       => $this->id . '_label_search_radius',
								'type'     => 'text',
								'default'  => 'Search Radius',
							),
							array(
								'name'     => __( 'No Results Found', 'woosl' ),
								'desc_tip' => __( 'No Results Found', 'woosl' ),
								'id'       => $this->id . '_label_no_results_found',
								'type'     => 'text',
								'default'  => 'No Results Found',
							),
							array(
								'name'     => __( 'Search', 'woosl' ),
								'desc_tip' => __( 'Search', 'woosl' ),
								'id'       => $this->id . '_label_search',
								'type'     => 'text',
								'default'  => 'Search',
							),
							array(
								'name'     => __( 'Products', 'woosl' ),
								'desc_tip' => __( 'Products', 'woosl' ),
								'id'       => $this->id . '_label_products',
								'type'     => 'text',
								'default'  => 'Products',
							),
							array(
								'name'     => __( 'Searching Preloader Text', 'woosl' ),
								'desc_tip' => __( 'Searching Preloader Text', 'woosl' ),
								'id'       => $this->id . '_label_searching_preloader_text',
								'type'     => 'text',
								'default'  => 'Searching Preloader Text',
							),
							array(
								'name'     => __( 'Results', 'woosl' ),
								'desc_tip' => __( 'Results', 'woosl' ),
								'id'       => $this->id . '_label_results',
								'type'     => 'text',
								'default'  => 'Results',
							),
							array(
								'name'     => __( 'Category Filter', 'woosl' ),
								'desc_tip' => __( 'Category Filter', 'woosl' ),
								'id'       => $this->id . '_label_category_filter',
								'type'     => 'text',
								'default'  => 'Category Filter',
							),
							array(
								'name'     => __( 'More Info', 'woosl' ),
								'desc_tip' => __( 'More Info', 'woosl' ),
								'id'       => $this->id . '_label_more_info',
								'type'     => 'text',
								'default'  => 'More Info',
							),
							array(
								'name'     => __( 'Phone', 'woosl' ),
								'desc_tip' => __( 'Phone', 'woosl' ),
								'id'       => $this->id . '_label_phone',
								'type'     => 'text',
								'default'  => 'Phone',
							),
							array(
								'name'     => __( 'Email', 'woosl' ),
								'desc_tip' => __( 'Email', 'woosl' ),
								'id'       => $this->id . '_label_email',
								'type'     => 'text',
								'default'  => 'Email',
							),
							array(
								'name'     => __( 'URL', 'woosl' ),
								'desc_tip' => __( 'URL', 'woosl' ),
								'id'       => $this->id . '_label_url',
								'type'     => 'text',
								'default'  => 'URL',
							),
							array(
								'name'     => __( 'Hours', 'woosl' ),
								'desc_tip' => __( 'Hours', 'woosl' ),
								'id'       => $this->id . '_label_hours',
								'type'     => 'text',
								'default'  => 'Hours',
							),
							array(
								'name'     => __( 'Start Location', 'woosl' ),
								'desc_tip' => __( 'Start Location', 'woosl' ),
								'id'       => $this->id . '_label_start_location',
								'type'     => 'text',
								'default'  => 'Start LocationL',
							),
							array(
								'name'     => __( 'Get Directions', 'woosl' ),
								'desc_tip' => __( 'Get Directions', 'woosl' ),
								'id'       => $this->id . '_label_get_directions',
								'type'     => 'text',
								'default'  => 'Get Directions',
							),
							array(
								'name'     => __( 'No Directions Found', 'woosl' ),
								'desc_tip' => __( 'No Directions Found', 'woosl' ),
								'id'       => $this->id . '_label_no_directions_found',
								'type'     => 'text',
								'default'  => 'No Directions Found',
							),
							array(
								'name'     => __( 'Back', 'woosl' ),
								'desc_tip' => __( 'Back', 'woosl' ),
								'id'       => $this->id . '_label_back',
								'type'     => 'text',
								'default'  => 'Back',
							),
							array(
								'name'     => __( 'General Error', 'woosl' ),
								'desc_tip' => __( 'General Error', 'woosl' ),
								'id'       => $this->id . '_label_general_error',
								'type'     => 'text',
								'default'  => 'Something went wrong, Please try again!',
							),
							array(
								'name'     => __( 'Query Limit Error', 'woosl' ),
								'desc_tip' => __( 'Query Limit Error', 'woosl' ),
								'id'       => $this->id . '_label_query_limit_error',
								'type'     => 'text',
								'default'  => 'API Usage Limit Reached',
							),

							array(
								'type' => 'sectionend',
								'id'   => $this->id . '_label_options',
							),
						 // label settings end

						)
					);

				} elseif ( 'imp_csv' == $current_section ) {
					$settings = apply_filters(
						$this->id . '_imp_csv_options_settings',
						array(

							// label settings start

							array(
								'name' => __( 'Import', 'woosl' ),
								'type' => 'title',
								'desc' => '',
								'id'   => $this->id . '_imp_csv_options',
							),
							array(
								'name' => __( 'Import', 'woosl' ),
								'type' => 'csv_files',
								'desc' => '',
								'id'   => $this->id . '_imp_csv_options',
							),
							array(
								'name' => __( 'Export', 'woosl' ),
								'type' => 'csv_export_files',
								'desc' => '',
								'id'   => $this->id . '_imp_csv_options',
							),

							array(
								'type' => 'sectionend',
								'id'   => $this->id . '_imp_csv_options',
							),
						 // label settings end

						)
					);

				} elseif ( 'info_window' == $current_section ) {
					$settings = apply_filters(
						$this->id . '_info_window_options_settings',
						array(

							// label settings start

							array(
								'name' => __( 'Store Info Window', 'woosl' ),
								'type' => 'title',
								'desc' => '',
								'id'   => $this->id . '_info_window_options',
							),
							array(
								'name' => __( 'Info Window', 'woosl' ),
								'type' => 'info_files',
								'desc' => '',
								'id'   => $this->id . '_info_window_options',
							),

							array(
								'type' => 'sectionend',
								'id'   => $this->id . '_info_window_options',
							),
						 // label settings end

						)
					);

				} else {
					global $woocommerce;
					$countries_obj = new WC_Countries();
					$countries     = $countries_obj->__get( 'countries' );
					$args          = array(
						'post_type'      => 'product',
						'post_status'    => 'publish',
						'posts_per_page' => -1,
					);
					$all_products  = get_posts( $args );
					$products      = array();
					$products[]    = __( 'Select Product', 'woosl' );
					foreach ( $all_products as $product ) {

						$products[ $product->ID ] = $product->post_title;
					}
					/**
					 * Filter Plugin Section 1 Settings
					 *
					 * @since 1.0.0
					 * @param array $settings Array of the plugin settings
					 */
					$settings = apply_filters(
						$this->id . '_general_settings',
						array(

							// google maps api section starts
							array(
								'name' => __( 'Google Maps API', 'woosl' ),
								'type' => 'title',
								'desc' => '',
								'id'   => $this->id . '_gmaps_api',
							),
							array(
								'name'     => __( 'API KEY', 'woosl' ),
								'desc_tip' => __( 'Enter your Google Map Api Key', 'woosl' ),
								'id'       => $this->id . '_maps_api_key',
								'type'     => 'text',
								'desc'     => __( 'Enter your Google Map Api Key', 'woosl' ),
							),
							array(
								'type'     => 'select',
								'id'       => $this->id . '_map_language',
								'name'     => __( 'Map Language', 'woosl' ),
								'options'  => array(
									'en'    => __( 'English', 'woosl' ),
									'es'    => __( 'Spanish', 'woosl' ),
									'fr'    => __( 'French', 'woosl' ),
									'ur'    => __( 'Urdu', 'woosl' ),
									'ar'    => __( 'Arabic', 'woosl' ),
									'zh'    => __( 'Chinese', 'woosl' ),
									'zh-CN' => __( 'Chinese (Simplified)', 'woosl' ),
									'zh-HK' => __( 'Chinese (Hong Kong)', 'woosl' ),
									'zh-TW' => __( 'Chinese (Traditional)', 'woosl' ),
									'fa'    => __( 'Farsi', 'woosl' ),
									'da'    => __( 'Danish', 'woosl' ),
									'nl'    => __( 'Dutch', 'woosl' ),
									'de'    => __( 'German', 'woosl' ),
									'iw'    => __( 'Hebrew', 'woosl' ),
									'hi'    => __( 'Hindi', 'woosl' ),
									'it'    => __( 'Italian', 'woosl' ),
									'ja'    => __( 'Japanese', 'woosl' ),
									'ko'    => __( 'Korean', 'woosl' ),
									'lt'    => __( 'Lithuanian', 'woosl' ),
									'mk'    => __( 'Macedonian', 'woosl' ),
									'ms'    => __( 'Malay', 'woosl' ),
									'no'    => __( 'Norwegian', 'woosl' ),
									'pt'    => __( 'Portuguese', 'woosl' ),
									'ro'    => __( 'Romanian', 'woosl' ),
									'ru'    => __( 'Russian', 'woosl' ),
									'sw'    => __( 'Swahili', 'woosl' ),
									'sv'    => __( 'Swedish', 'woosl' ),
									'tr'    => __( 'Turkish', 'woosl' ),
									'vi'    => __( 'Vietnamese', 'woosl' ),
								),
								'class'    => 'wc-enhanced-select',
								'desc_tip' => __( 'Select your default Map Language', 'woosl' ),
								'default'  => 'en',
								'desc'     => __( 'Select your default Map Language', 'woosl' ),
							),
							array(
								'type'     => 'select',
								'id'       => $this->id . '_map_region',
								'name'     => __( 'Map Region', 'woosl' ),
								'options'  => $countries,
								'class'    => 'wc-enhanced-select',
								'desc_tip' => __( 'Select your default Country', 'woosl' ),
								'default'  => 'US',
								'desc'     => __( 'Select your default Country', 'woosl' ),
							),

							array(
								'type' => 'sectionend',
								'id'   => $this->id . '_gmaps_api',
							),

							// google maps api settings end
							// search settings start
							array(
								'name' => __( 'Search Options', 'woosl' ),
								'type' => 'title',
								'desc' => '',
								'id'   => $this->id . '_search_options',
							),

							array(
								'type'     => 'checkbox',
								'id'       => $this->id . '_search_radius',
								'name'     => __( 'Show the search Radius Dropdown', 'woosl' ),
								'desc'     => __( 'Show search Radius Dropdown', 'woosl' ),
								'default'  => 'no',
								'desc_tip' => __( 'Enable to display the radius option filter on map', 'woosl' ),
							),
							array(
								'type'     => 'checkbox',
								'id'       => $this->id . '_store_category',
								'name'     => __( 'Show the store Category', 'woosl' ),
								'desc'     => __( 'Show store Category', 'woosl' ),
								'default'  => 'no',
								'desc'     => __( 'Enable to display the store category filter on map', 'woosl' ),
								'desc_tip' => __( 'Enable to display the store category filter on map', 'woosl' ),
							),

							array(
								'type'    => 'select',
								'id'      => $this->id . '_default_product',
								'name'    => __( 'Default Product', 'woosl' ),
								'options' => $products,
								'class'   => 'wc-enhanced-select',
								'desc'    => __( 'The map of default product will display when user acceses the page directly', 'woosl' ),
								'default' => '0',
							),

							array(
								'name'     => __( 'Show Max Search Results Field', 'woosl' ),
								'desc_tip' => __( 'Leave empty if you want to hide it', 'woosl' ),
								'id'       => $this->id . '_max_results',
								'type'     => 'text',
								'default'  => '10,[25],50,75,100,200,500',
								'desc'     => __( 'Leave empty if you want to hide it', 'woosl' ),
							),
							array(
								'name'     => __( 'Search Radius Options', 'woosl' ),
								'desc_tip' => __( 'Display Search radius filter on the map that allow users to set preferred search radius', 'woosl' ),
								'id'       => $this->id . '_radius_options',
								'type'     => 'text',
								'default'  => '10,25,[50],75,100,200,500',
								'desc'     => __( 'Display Search radius filter on the map that allow users to set preferred search radius', 'woosl' ),
							),

							array(
								'type' => 'sectionend',
								'id'   => $this->id . '_search_options',
							),

							// search settings end

							// map settings start

							array(
								'name' => __( 'Map Options', 'woosl' ),
								'type' => 'title',
								'desc' => '',
								'id'   => $this->id . '_map_options',
							),

							array(
								'type'     => 'checkbox',
								'id'       => $this->id . '_locate_user',
								'name'     => __( 'Locate User', 'woosl' ),
								'desc'     => __( 'Attempt to autolocate the user', 'woosl' ),
								'default'  => 'no',
								'desc_tip' => __( 'Enable to get user location automatically', 'woosl' ),

							),

							array(
								'name'     => __( 'Start Point', 'woosl' ),
								'desc_tip' => __( 'Enter the starting position when map loads', 'woosl' ),
								'id'       => $this->id . '_start_point',
								'type'     => 'text',
								'default'  => 'Houston, Texas',
								'desc'     => __( 'Enter the starting position when map loads', 'woosl' ),
							),

							array(
								'type'     => 'select',
								'id'       => $this->id . '_distance_unit',
								'name'     => __( 'Distance Unit', 'woosl' ),
								'options'  => array(
									'km'    => __( 'KM', 'woosl' ),
									'miles' => __( 'Miles', 'woosl' ),
								),
								'class'    => 'wc-enhanced-select',
								'desc_tip' => __( 'Set the search unit to measure distance in kilometres or miles', 'woosl' ),
								'default'  => 'km',
								'desc'     => __( 'Set the search unit to measure distance in kilometres or miles', 'woosl' ),
							),

							array(
								'type'    => 'checkbox',
								'id'      => $this->id . '_show_map_type',
								'name'    => __( 'Show the map type control', 'woosl' ),
								'desc'    => __( 'Enable to display map and satellite imagery option', 'woosl' ),
								'default' => 'no',
							),

							array(
								'type'    => 'checkbox',
								'id'      => $this->id . '_show_streetview',
								'name'    => __( 'Show Street view control', 'woosl' ),
								'desc'    => __( 'Enable to display street view control on the map to open street view', 'woosl' ),
								'default' => 'no',
							),

							array(
								'type'    => 'checkbox',
								'id'      => $this->id . '_store_review',
								'name'    => __( 'Enable Store Reviews', 'woosl' ),
								'desc'    => __( 'Display store review on Map Listing', 'woosl' ),
								'default' => 'no',
							),
							array(
								'type'    => 'checkbox',
								'id'      => $this->id . '_show_map_cluster',
								'name'    => __( 'Show Map Cluster', 'woosl' ),
								'desc'    => __( 'Display the number of markers cluster together', 'woosl' ),
								'default' => 'no',
							),
							array(
								'type'    => 'checkbox',
								'id'      => $this->id . '_display_store_hour',
								'name'    => __( 'Display Store Hours', 'woosl' ),
								'desc'    => __( 'Display store hour on Map Listing and Store popup', 'woosl' ),
								'default' => 'no',
							),
							array(
								'type'    => 'checkbox',
								'id'      => $this->id . '_scroll_wheel_zoom',
								'name'    => __( 'Enable Scroll wheel zooming', 'woosl' ),
								'desc'    => __( 'Enable to display street view control on the map with the scroll wheel', 'woosl' ),
								'default' => 'no',
							),

							array(
								'type' => 'sectionend',
								'id'   => $this->id . '_map_options',
							),
							// map settings end

							// permalink settings start

							array(
								'name' => __( 'Permalink', 'woosl' ),
								'type' => 'title',
								'desc' => '',
								'id'   => $this->id . '_permalink_options',
							),
							array(
								'type'    => 'checkbox',
								'id'      => $this->id . '_enable_permalink',
								'name'    => __( 'Enable Permalink', 'woosl' ),
								'default' => 'no',
								'desc'    => __( 'If permalink are enabled, each location will have its own page', 'woosl' ),
							),

							array(
								'name'     => __( 'Stores Slug', 'woosl' ),
								'desc_tip' => __( 'Slug to use for pages', 'woosl' ),
								'id'       => $this->id . '_stores_slug',
								'type'     => 'text',
								'default'  => 'wsl_stores',
								'desc'     => __( 'Slug to use for pages', 'woosl' ),
							),

							array(
								'name'     => __( 'Stores Categories Slug', 'woosl' ),
								'desc_tip' => __( 'Slug to use for store category', 'woosl' ),
								'id'       => $this->id . '_categories_slug',
								'type'     => 'text',
								'default'  => 'wsl_stores_categories',
								'desc'     => __( 'Slug to use for store category', 'woosl' ),
							),

							array(
								'type' => 'sectionend',
								'id'   => $this->id . '_permalink_options',
							),
							// permalink settings end

							// markers settings start

							array(
								'name' => __( 'Markers', 'woosl' ),
								'type' => 'title',
								'desc' => '',
								'id'   => $this->id . '_markers_options',
							),

							array(
								'type'    => 'radio',
								'id'      => $this->id . '_start_markers',
								'name'    => __( 'Start Location Marker', 'woosl' ),
								'options' => array(
									'blue'   => '',
									'red'    => '',
									'green'  => '',
									'orange' => '',
									'purple' => '',
									'yellow' => '',
								),
								'class'   => 'wsl-markers',
								'default' => 'red',
							),

							array(
								'type'    => 'radio',
								'id'      => $this->id . '_store_markers',
								'name'    => __( 'Store Location Marker', 'woosl' ),
								'options' => array(
									'blue'   => '',
									'red'    => '',
									'green'  => '',
									'orange' => '',
									'purple' => '',
									'yellow' => '',
								),
								'class'   => 'wsl-markers',
								'default' => 'blue',
							),
							array(
								'type'    => 'checkbox',
								'id'      => $this->id . '_display_image_',
								'name'    => __( 'Image', 'woosl' ),
								'desc'    => __( 'Check to display image on single store page', 'woosl' ),
								'default' => 'no',
							),

							array(
								'type' => 'sectionend',
								'id'   => $this->id . '_markers_options',
							),

						)
					);

				}

				/**
				 * Filter MyPlugin Settings
				 *
				 * @since 1.0.0
				 * @param array $settings Array of the plugin settings
				 */
				return apply_filters( 'woocommerce_get_settings_' . $this->id, $settings, $current_section );

			}

			public function import_store_finder_page_callback_woo() {
				?>
					<div class="import_csv">
						<form method="post" id="import-form" name="upload_form" enctype="multipart/form-data" >
							<label class='wsl-woo-label'>Upload CSV File:</label>
							<input class="btnfile" id="file-input" type="file" name="csv-file" hidden onchange="wsl_validate_file_type()"/>
							<button class="button file_picker" type="button">Browse</button>
							 <span class="wsl-upload-file-name">No File Selected</span>
							<p class="woo-store-finder-sample-csv">Max File Size: <strong>5MB</strong> </p>
							<input class="button upload_file_wsl" type="submit" name="import_stores_finder_csv_woo" value="<?php echo esc_attr( __( 'Upload', 'text-domain' ) ); ?>">
							<?php wp_nonce_field( 'store_import_nonce', 'store_import_window' ); ?>
							<p class="woo-store-finder-sample-csv">Before getting started please download the <a href="<?php echo esc_url( WOOCOMMERCE_STORE_LOCATOR_ASSETS . 'csv/sample.csv' ); ?>" download ><?php echo esc_attr( __( 'Sample CSV ', 'woosl' ) ); ?></a></p>
							<div id="progressbar">
								<div id="wsl_import_progress" ></div>
							</div>
							<span class="wsl-stores-upload"><span class="wsl-stores-uploaded"></span>	/	<span class="wsl-stores-total"></span> Uploaded</span>
						</form>
					</div>
				 <h4 class='wsl-export-heading'>Export</h4>	
					 <div class="export_csv">
					  <form method="post" name="export_form" id="export_form">
						<div class="export_category">
							<label class='wsl-export-label'>Category:</label>
								<select class="category_dropdown" name="category_dropdown[]" id="category_dropdown" multiple>
									<option value="all">All</option>
									<?php
									$terms = get_terms(
										array(
											'taxonomy' => 'wsl_stores_categories',
										)
									);

									foreach ( $terms as $term ) {
										?>
											<option value="<?php echo esc_html( $term->name ); ?>"><?php echo esc_attr( $term->name ); ?> </option> 
											<?php
									}
									?>
								</select>
							</div>
						<div class="export_country">
							<label class='wsl-export-label'>Country:</label>
							<select class="country_dropdown" name="country_dropdown[]" id="country_dropdown" multiple>
								<option value="all">All</option>
									<?php
										$args = array(
											'post_type' => 'wsl_stores',
											'posts_per_page' => -1,
											'meta_key'  => 'wsl_stores_country',
										);

										$post      = get_posts( $args );
										$in_select = array();
										foreach ( $post as $wsl ) {
												 $e = get_post_meta( $wsl->ID, 'wsl_stores_country', true );
											if ( empty( trim( $e ) ) || in_array( $e, $in_select ) ) {
												continue;
											}
											$in_select[] = $e;
											?>
											<option value="<?php echo esc_html( $e ); ?>"><?php echo esc_attr( $e ); ?> </option>
											 <?php
										}
										?>
							</select>
						</div>
						<div class="export_city">
							<label class='wsl-export-label'>City:</label>
								<select class="city_dropdown" name="city_dropdown[]" id="city_dropdown" multiple>
									<option value="all">All</option>
									<?php
										$args      = array(
											'post_type' => 'wsl_stores',
											'posts_per_page' => -1,
											'meta_key'  => 'wsl_stores_city',
										);
										$in_select = array();
										foreach ( $post as $wsl ) {
											$e = get_post_meta( $wsl->ID, 'wsl_stores_city', true );
											if ( empty( trim( $e ) ) || in_array( $e, $in_select ) ) {
												continue;
											}
											$in_select[] = $e;
											?>
											<option value="
											<?php
											echo esc_html( $e );
											?>
											">
											<?php
											echo esc_html( $e );
											?>
										</option>
											<?php
										}
										?>
								</select>
						</div>
						  <input type="hidden" name="wsl_export_csv" value="wsl_export_stores">
						  <input type="hidden" name="export_categories" id="export_categories" value="">
						  <input type="hidden" name="export_cities" id="export_cities" value="">
						  <input type="hidden" name="export_countries" id="export_countries" value="">
						  <input class="button export_button " type="submit" name="wsl_export_stores" value="Export">
						  <?php wp_nonce_field( 'store_export_window', 'export_csv_nonce' ); ?>
					</form>
					</div>
	
				<?php
			}

			/**
			 * Export Store
			 */

			/*
			* Store Info File
			*/
			public function funct_store_info_files() {
				add_filter( 'the_editor_content', array( $this, 'htmledit_pre' ) );
				?>

					
<!-- 						<td> 
							$content = $_POST['wsl_stores_info'];
							$tag = get_bloginfo( 'name' );
							$url =  str_replace('{test}', $tag, $content);
							echo '<pre>';
							print_r($url);
							echo '</pre>';
							die();
							
						</td>

 -->					
						<form action="" method="post" accept-charset="utf-8">
						<td>
							<?php

							$content = get_option( 'wsl_stores_info', true );

							wp_editor( $content, 'wsl_stores_info' );
							wp_nonce_field( 'store_info_nonce', 'store_info_window' );
							echo ' {title}: Title <br> {country}: Country <br> {city}: City <br> {phone}: phone <br> {postal_code}: postal_code <br> {website}: Website <br> {address}: Address <br> {email}: Email <br> {description}: Description <br> {rating}: Rating <br> ';

							?>
						</td>
					</form>
					
				<?php
				 global $post;

				if ( isset( $_POST['wsl_stores_info'] ) && isset( $_POST['store_info_window'] ) && wp_verify_nonce( sanitize_text_field( $_POST['store_info_window'] ), 'store_info_nonce' ) ) {

					update_option( 'wsl_stores_info', wp_kses_post( $_POST['wsl_stores_info'] ) );
					return $content;

				}

			}

			/**
			 * Output the settings
			 *
			 * @since 1.0
			 */
			public function htmledit_pre( $output ) {

				if ( ! empty( $output ) ) {

					$output = htmlspecialchars_decode( $output, ENT_NOQUOTES );
				}

				return $output;
			}
			public function output() {

				global $current_section;

				$settings = $this->get_settings( $current_section );
				WC_Admin_Settings::output_fields( $settings );
			}

			/**
			 * Save settings
			 *
			 * @since 1.0
			 */
			public function save() {

				global $current_section;

				$settings = $this->get_settings( $current_section );
				WC_Admin_Settings::save_fields( $settings );
			}

		}

		return new WC_Settings_MyPlugin();

	}
	add_filter( 'woocommerce_get_settings_pages', 'wsl_add_settings', 15 );

endif;


add_action( 'wp_ajax_wsl_fields_sort_order', 'save_wsl_fields_sort_order' );


function save_wsl_fields_sort_order() {
	if ( isset( $_POST['wsl_nonce'] ) && ! wp_verify_nonce( sanitize_text_field( $_POST['wsl_nonce'] ), 'wsl-backend-nonce' ) ) {
		wp_send_json_error( __( 'Oops! something went wrong', 'woosl' ) );

	}

	if ( isset( $_POST['fields_order'] ) && ! empty( $_POST['fields_order'] ) ) {

		update_option( 'wsl_fields_order', sanitize_text_field( $_POST['fields_order'] ) );

		$response = array(
			'success' => 'yes_success',
		);
		echo json_encode( $response );
	} else {
		wp_send_json_error( __( 'Oops! something went wrong', 'woosl' ) );
	}

	wp_die();
}

add_action( 'wp_ajax_import_js_stores_action', 'wsl_import_js_stores_action' );

function wsl_import_js_stores_action() {

	if ( isset( $_POST['import_js_stores_post_wsl'] ) && isset( $_POST['import_nonce'] ) && wp_verify_nonce( sanitize_text_field( $_POST['import_nonce'] ), 'wsl-frontend-nonce' ) ) {

		$import_js_stores_post_wsl = json_decode( str_replace( '\\', '', sanitize_text_field( $_POST['import_js_stores_post_wsl'] ) ), true );

		if ( ! empty( $import_js_stores_post_wsl['ID'] ) ) {
			global $user_ID;
			global $wpdb;
			$postmeta_table = $wpdb->prefix . 'postmeta';
			$args           = array(
				'post_type'  => 'wsl_stores',
				'status'     => 'publish',
				'meta_key'   => 'wsl_stores_code',
				'meta_value' => $import_js_stores_post_wsl['ID'],
			);

			$exist_post = get_posts( $args );

			if ( count( $exist_post ) > 0 && $import_js_stores_post_wsl['ID'] ) {
				// edit existing post
				$edit_post = array(
					'ID'         => $exist_post[0]->ID,
					'post_title' => $import_js_stores_post_wsl['Name'],
					'post_name'  => $import_js_stores_post_wsl['Name'] . uniqid(),
				);
				$post_id   = wp_update_post( $edit_post );
				$wpdb->delete( $postmeta_table, array( 'post_id' => $post_id ) );
			} else {
				// add new post
				$new_post = array(
					'post_title'  => $import_js_stores_post_wsl['Name'],
					'post_name'   => $import_js_stores_post_wsl['Name'] . uniqid(),
					'post_status' => $import_js_stores_post_wsl['Status'],
					'post_author' => $user_ID,
					'post_type'   => 'wsl_stores',
				);

				$post_id = wp_insert_post( $new_post );

			}
			$valuesArr = array();
			$sql       = 'INSERT INTO ' . $postmeta_table . '(`post_id`, `meta_key`, `meta_value`) VALUES';

			// update post meta
			$valuesArr[] = array( $post_id, 'wsl_stores_code', trim( $import_js_stores_post_wsl['ID'] ) );
			$valuesArr[] = array( $post_id, 'wsl_stores_name', trim( $import_js_stores_post_wsl['Name'] ) );
			$valuesArr[] = array( $post_id, 'wsl_stores_description', trim( $import_js_stores_post_wsl['Description'] ) );
			$valuesArr[] = array( $post_id, 'wsl_stores_address', trim( $import_js_stores_post_wsl['Address'] ) );
			$valuesArr[] = array( $post_id, 'wsl_stores_country', trim( $import_js_stores_post_wsl['Country'] ) );
			$valuesArr[] = array( $post_id, 'wsl_stores_city', trim( $import_js_stores_post_wsl['City'] ) );
			$valuesArr[] = array( $post_id, 'wsl_stores_zipcode', trim( $import_js_stores_post_wsl['PostalCode'] ) );
			$valuesArr[] = array( $post_id, 'wsl_stores_lat', trim( $import_js_stores_post_wsl['Latitude'] ) );
			$valuesArr[] = array( $post_id, 'wsl_stores_lng', trim( $import_js_stores_post_wsl['Longitude'] ) );
			$valuesArr[] = array( $post_id, 'wsl_stores_phone', trim( $import_js_stores_post_wsl['Phone'] ) );
			// $valuesArr[] = array( $post_id, 'wsl_stores_categories', $import_js_stores_post_wsl['Category'] );
			$valuesArr[] = array( $post_id, 'wsl_stores_email', trim( $import_js_stores_post_wsl['Email'] ) );
			$valuesArr[] = array( $post_id, 'wsl_stores_website', trim( $import_js_stores_post_wsl['Website'] ) );
			// $valuesArr[] = array( $post_id, 'wsl_stores_status', $import_js_stores_post_wsl['Status'] );

			foreach ( $valuesArr as $value ) {
				update_post_meta( $value[0], $value[1], $value[2] );
				$sql .= " ('" . implode( "', '", $value ) . "'),";
			}
			$stores = get_option( 'my_import_stores_finder' );

			if ( ! empty( $stores ) ) {

				foreach ( $stores as $key => $value ) {
					if ( $value['ID'] == $import_js_stores_post_wsl['ID'] ) {
						unset( $stores[ $key ] );
					}
				}
				   update_option( 'my_import_stores_finder', $stores );

			} else {
					echo 'false';
			}

			if ( ! empty( $import_js_stores_post_wsl['Category'] ) ) {
					$temp       = '';
					$temp2      = '';
					$cat_ids    = array();
					$taxonomies = explode( '|', $import_js_stores_post_wsl['Category'] );
				foreach ( $taxonomies as $key => $group ) {
						$terms = explode( ',', $group );
						$terms = array_reverse( $terms );
					foreach ( $terms as $newkey => $term ) {
						$temp = term_exists( $term, 'wsl_stores_categories' );
						if ( $temp ) {
							$temp2 = $temp['term_id'];
						} else {
							if ( ! empty( $temp2 ) ) {
								wp_insert_term( $term, 'wsl_stores_categories', array( 'parent' => $temp2 ) );
							} else {
								wp_insert_term( $term, 'wsl_stores_categories' );
							}
										$temp2 = $new['term_id'];
						}
					}
					// set term to post
					$cat_ids[] = $temp2;
					$temp2     = '';
				}
				$cat_ids           = array_map( 'intval', $cat_ids );
				$cat_ids           = array_unique( $cat_ids );
				$term_taxonomy_ids = wp_set_object_terms( $post_id, $cat_ids, 'wsl_stores_categories', true );
				clean_term_cache( $cat_ids, 'wsl_stores_categories', true );
			}

			if ( ! empty( $post_id ) && ! empty( $import_js_stores_post_wsl['ID'] ) ) {
				$my_import_stores = get_option( 'my_import_stores_finder' );
				if ( is_array( $my_import_stores ) ) {
					foreach ( $my_import_stores as $arry ) {
						if ( $arry['ID'] != $import_js_stores_post_wsl['ID'] ) {
							$arrayss[] = $arry;
						}
					}
				}
				if ( is_array( $my_import_stores ) ) {

					$wsl_stores_API_KEY = get_option( 'wsl_stores_API_KEY' );

					$records = array(
						'post_id'   => $post_id,
						'error_msg' => @$responsedecoded->error_message,
						'ID'        => $import_js_stores_post_wsl['ID'],
						'Name'      => $import_js_stores_post_wsl['Name'],
						'address'   => $import_js_stores_post_wsl['Address'] . '' . $import_js_stores_post_wsl['Country'] . '' . $import_js_stores_post_wsl['City'] . '' . $import_js_stores_post_wsl['Postalcode'] . '' . $import_js_stores_post_wsl['Lattitude'] . '' . $import_js_stores_post_wsl['Longitude'] . '' . $import_js_stores_post_wsl['Phone'] . '' . $import_js_stores_post_wsl['Category'] . '' . $import_js_stores_post_wsl['Email'] . '' . $import_js_stores_post_wsl['Website'] . '' . $import_js_stores_post_wsl['Status'],
					);

					$responsedecoded = json_decode( file_get_contents( 'https://maps.google.com/maps/api/geocode/json?address=' . urlencode( $records['address'] ) . '&sensor=false&key=' . $wsl_stores_API_KEY ) );

					if ( empty( $responsedecoded ) ) {
						'responsedecoded Error #:' . $err;
						update_post_meta( $post_id, 'responsedecoded_Error_while_getting_lng_and_lat', $err );
					} else {
						if ( 'OK' == $responsedecoded->status ) {
							update_post_meta( $post_id, 'wsl_stores_lat', $responsedecoded->results[0]->geometry->location->lat );
							update_post_meta( $post_id, 'wsl_storesr_lng', $responsedecoded->results[0]->geometry->location->lng );
							$records['lat'] = $responsedecoded->results[0]->geometry->location->lat;
							$records['lng'] = $responsedecoded->results[0]->geometry->location->lng;
							$array          = array();

						} else {
							$records['lat'] = 'empty';
							$records['lng'] = 'empty';
							update_post_meta( $post_id, 'cURL_Error_while_getting_lng_and_lat', $responsedecoded );
						}
					}

					echo json_encode( $records );
					die();
				}
			}
		}
	}
}


	add_action( 'admin_init', 'export_store_locator_csv' );

function export_store_locator_csv() {

			$args = array(
				'post_type'      => 'wsl_stores',
				'posts_per_page' => -1,
			);
			if ( isset( $_POST['wsl_export_csv'] ) && 'wsl_export_stores' == $_POST['wsl_export_csv'] && isset( $_POST['export_csv_nonce'] ) && wp_verify_nonce( sanitize_text_field( $_POST['export_csv_nonce'] ), 'store_export_window' ) ) {

				$categories = array();
				$cities     = array();
				$countries  = array();
				if ( isset( $_POST['export_categories'] ) && ! empty( $_POST['export_categories'] ) && 'All' != $_POST['export_categories'] ) {

					$categories = explode( ',', sanitize_text_field( $_POST['export_categories'] ) );

					if ( in_array( 'All', $categories ) ) {
						// if All is in category then we skip category condition
						$categories = array();
					}
				}

				if ( isset( $_POST['export_cities'] ) && ! empty( $_POST['export_cities'] ) && 'All' != $_POST['export_cities'] ) {

					$cities = explode( ',', sanitize_text_field( $_POST['export_cities'] ) );

					if ( in_array( 'All', $cities ) ) {
						// if All is in category then we skip category condition
						$cities = array();
					}
				}

				if ( isset( $_POST['export_countries'] ) && ! empty( $_POST['export_countries'] ) && 'All' != $_POST['export_countries'] ) {

					$countries = explode( ',', sanitize_text_field( $_POST['export_countries'] ) );

					if ( in_array( 'All', $countries ) ) {
						// if All is in category then we skip category condition
						$countries = array();
					}
				}

				$all_stores       = get_posts( $args );
				$stores_to_export = array();

				$csvURL = dirname( __FILE__ ) . '/Stores.csv';
				header( 'Content-Type: application/csv' );
				header( 'Content-Disposition: attachment; filename=Stores.csv' );
				header( 'Pragma: no-cache' );

				$output_handle = @fopen( $csvURL, 'w' );
				$csv_fields    = array( 'ID', 'Name', 'Description', 'Address', 'Country', 'City', 'PostalCode', 'Latitude', 'Longitude', 'Phone', 'Category', 'Email', 'Website', 'Status' );
				fputcsv( $output_handle, $csv_fields );

				if ( ! empty( $all_stores ) ) {

					foreach ( $all_stores as $stores ) {

						if ( ! empty( $categories ) ) {
							$store_cats = wp_get_post_terms( $stores->ID, 'wsl_stores_categories', array( 'fields' => 'names' ) );
							if ( empty( array_intersect( $store_cats, $categories ) ) ) {
								continue;
							}
						}
						if ( ! empty( $cities ) ) {

							if ( ! in_array( get_post_meta( $stores->ID, 'wsl_stores_city', true ), $cities ) ) {
								continue;
							}
						}
						if ( ! empty( $countries ) ) {
							if ( ! in_array( get_post_meta( $stores->ID, 'wsl_stores_country', true ), $countries ) ) {
								continue;
							}
						}
						$store_meta       = get_post_meta( $stores->ID );
						$store_categories = implode( ', ', wp_get_post_terms( $stores->ID, 'wsl_stores_categories', array( 'fields' => 'names' ) ) );

						$csv_fields = array(
							$store_meta['wsl_stores_code'][0],
							$store_meta['wsl_stores_name'][0],
							$store_meta['wsl_stores_description'][0],
							$store_meta['wsl_stores_address'][0],
							$store_meta['wsl_stores_country'][0],
							$store_meta['wsl_stores_city'][0],
							$store_meta['wsl_stores_zipcode'][0],
							$store_meta['wsl_stores_lat'][0],
							$store_meta['wsl_stores_lng'][0],
							$store_meta['wsl_stores_phone'][0],
							$store_categories,
							$store_meta['wsl_stores_email'][0],
							$store_meta['wsl_stores_website'][0],
							$stores->post_status,
						);

						fputcsv( $output_handle, $csv_fields );

					}
				}

				fclose( $output_handle );

				readfile( $csvURL );
				die();

			}

}


		add_action( 'admin_init', 'wsl_save_import_stores' );

function wsl_save_import_stores() {

	if ( isset( $_POST['import_stores_finder_csv_woo'] ) && isset( $_POST['store_import_window'] ) && wp_verify_nonce( sanitize_text_field( $_POST['store_import_window'] ), 'store_import_nonce' ) ) {
				$csv_mimetypes = array(
					'text/csv',
					'text/plain',
					'text/comma-separated-values',
					'application/excel',
					'application/vnd.ms-excel',
					'application/vnd.msexcel',
					'application/csv',
					'application/octet-stream',
					'application/txt',
				);

				if ( ! isset( $_FILES['csv-file']['tmp_name'] ) || ( isset( $_FILES['csv-file']['type'] ) && ! in_array( $_FILES['csv-file']['type'], $csv_mimetypes ) ) || ( isset( $_FILES['csv-file']['size'] ) && 0 == sanitize_text_field( $_FILES['csv-file']['size'] ) ) ) {
					add_action( 'admin_notices', 'wsl_invalid_csv_notice' );

				} else {

					?>
					 <script>var addresses = [];</script>
					 <?php
						$csv    = array_map( 'str_getcsv', file( sanitize_text_field( $_FILES['csv-file']['tmp_name'] ) ) );
						$header = array_shift( $csv );
						$stores = array();
						foreach ( $csv as $row ) {
							if ( ! empty( $row[1] ) ) {

								$row[0]  = sanitize_text_field( $row[0] );
								$row[1]  = sanitize_text_field( $row[1] );
								$row[2]  = sanitize_text_field( $row[2] );
								$row[3]  = sanitize_text_field( $row[3] );
								$row[4]  = sanitize_text_field( $row[4] );
								$row[5]  = sanitize_text_field( $row[5] );
								$row[6]  = sanitize_text_field( $row[6] );
								$row[7]  = sanitize_text_field( $row[7] );
								$row[8]  = sanitize_text_field( $row[8] );
								$row[9]  = sanitize_text_field( $row[9] );
								$row[10] = sanitize_text_field( $row[10] );
								$row[11] = sanitize_text_field( $row[11] );
								$row[12] = sanitize_text_field( $row[12] );
								$row[13] = sanitize_text_field( $row[13] );
								// $row[14]=sanitize_text_field($row[14]);
								$stores[] = array_combine( $header, $row );
							}
						}

						update_option( 'my_import_stores_finder', $stores );

				}
	}
}


function wsl_invalid_csv_notice() {
	$class   = 'notice notice-error';
	$message = __( 'Please select CSV file.', 'woosl' );

	printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) );
}
