<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
if ( ! class_exists( 'WSL_Manage_Stores' ) ) {

	class WSL_Manage_Stores {

		public $store_locator_slug;
		public $store_locator_taxonomy;
		public $enable_permalinks;


		public function __construct() {
			add_action( 'init', array( $this, 'wsl_init' ) );
			add_action( 'admin_menu', array( $this, 'add_wsl_in_product_menu' ) );
			add_action( 'add_meta_boxes', array( $this, 'add_wsl_stores_metaboxes' ) );
			add_action( 'save_post', array( $this, 'wsl_stores_save_meta_box_data' ) );
			add_action( 'init', array( $this, 'wsl_gutenberg_block' ) );

			add_filter( 'template_include', array( $this, 'wsl_stores_single_template_page' ), 99 );

			$this->store_locator_slug     = get_option( 'wsl_stores_slug', false );
			$this->store_locator_taxonomy = get_option( 'wsl_categories_slug', false );
			$this->enable_permalinks      = get_option( 'wsl_enable_permalink', false );

			if ( empty( $this->store_locator_slug ) ) {
				$this->store_locator_slug = WOOCOMMERCE_STORE_LOCATOR_POSTTYPE;
			}

			if ( empty( $this->store_locator_taxonomy ) ) {
				$this->store_locator_taxonomy = 'wsl_store_cat';
			}
		}

		public function wsl_init() {
			$store_reviews = get_option( 'wsl_store_review' );
			$labels        = array(
				'name'               => __( 'WSL Stores', 'woosl' ),
				'singular_name'      => __( 'WSL Store', 'woosl' ),
				'menu_name'          => __( 'WSL Stores', 'woosl' ),
				'name_admin_bar'     => __( 'WSL Stores', 'woosl' ),
				'add_new'            => __( 'Add New Store', 'woosl' ),
				'add_new_item'       => __( 'Add New Store', 'woosl' ),
				'new_item'           => __( 'New Store', 'woosl' ),
				'edit_item'          => __( 'Edit Store', 'woosl' ),
				'view_item'          => __( 'View Store', 'woosl' ),
				'all_items'          => __( 'Stores List', 'woosl' ),
				'search_items'       => __( 'Search Store', 'woosl' ),
				'parent_item_colon'  => __( 'Store Partner:', 'woosl' ),
				'not_found'          => __( 'No Store found.', 'woosl' ),
				'not_found_in_trash' => __( 'No Store found in Trash.', 'woosl' ),
			);

			$args = array(
				'labels'          => $labels,
				'description'     => __( 'Description.', 'woosl' ),
				'public'          => ( 'yes' == $this->enable_permalinks ? true : false ),
				'show_ui'         => true,
				'show_in_menu'    => false,
				'query_var'       => true,
				'rewrite'         => array( 'slug' => $this->store_locator_slug ),
				'capability_type' => 'post',
				'has_archive'     => true,
				'hierarchical'    => false,
				'menu_position'   => null,
				'menu_icon'       => 'dashicons-location-alt',
				'supports'        => array( 'thumbnail', 'comments' ),
			);
			register_post_type( WOOCOMMERCE_STORE_LOCATOR_POSTTYPE, $args );

			$tax_labels = array(
				'name'              => _x( 'Store Categories', 'taxonomy general name' ),
				'singular_name'     => _x( 'Store Category', 'taxonomy singular name' ),
				'search_items'      => __( 'Search Store Categories' ),
				'popular_items'     => __( 'Popular Store Categories' ),
				'all_items'         => __( 'All Store Categories' ),
				'parent_item'       => null,
				'parent_item_colon' => null,
				'edit_item'         => __( 'Edit Store Category' ),
				'update_item'       => __( 'Update Store Category' ),
				'add_new_item'      => __( 'Add New Store Category' ),
				'new_item_name'     => __( 'New Store Category Name' ),
				'menu_name'         => __( 'Store Category' ),
			);

			// Now register the non-hierarchical taxonomy like tag

			register_taxonomy(
				$this->store_locator_taxonomy,
				WOOCOMMERCE_STORE_LOCATOR_POSTTYPE,
				array(
					'hierarchical' => false,
					'labels'       => $tax_labels,
					'rewrite'      => array( 'slug' => $this->store_locator_taxonomy ),
				)
			);
		}

		public function wsl_stores_single_template_page( $template ) {

			$post_id = get_the_ID();
			$post    = get_post( $post_id );

			if ( is_single() && WOOCOMMERCE_STORE_LOCATOR_POSTTYPE == $post->post_type ) {
				$template = WOOCOMMERCE_STORE_LOCATOR_INCLUDE . 'frontend/wsl-single-store-page.php';
			}

			return $template;
		}

		public function add_wsl_in_product_menu() {
			global $submenu;
			add_submenu_page( 'edit.php?post_type=product', __( 'WSL Stores', 'woosl' ), __( 'WSL Stores', 'woosl' ), 'manage_options', 'edit.php?post_type=' . WOOCOMMERCE_STORE_LOCATOR_POSTTYPE );
		}

		public function add_wsl_stores_metaboxes() {
			add_meta_box(
				'stores-info',
				__( 'Store Info', 'woosl' ),
				array( $this, 'wsl_stores_meta_box_callback_store_info' ),
				WOOCOMMERCE_STORE_LOCATOR_POSTTYPE
			);
				add_meta_box(
					'address-info',
					__( 'Address Info', 'woosl' ),
					array( $this, 'wsl_stores_meta_box_callback_address_info' ),
					WOOCOMMERCE_STORE_LOCATOR_POSTTYPE
				);
		}

		public function wsl_stores_meta_box_callback_store_info( $post ) {
			// Add a nonce field so we can check for it later.
			wp_nonce_field( 'wsl_stores_save_meta_box_data', 'wsl_stores_meta_box_nonce' );
			$post_id = $post->ID;
			?>
				<table class="form-table" style="border: 0px;">
				<tbody>
					<tr>
						<td><?php echo esc_attr( __( 'Code', 'woosl' ) ); ?></td>
						<td><?php $meta = get_post_meta( $post_id, 'wsl_stores_code', true ); ?>
							<input type="text" value="<?php echo ! empty( $meta ) ? esc_attr( $meta ) : esc_attr( $post_id ); ?>" name="wsl_stores_code" class="widefat" readonly />
						</td>
					</tr>
					<tr>
						<td><?php echo esc_attr( __( 'Name', 'woosl' ) ); ?></td>
						<td><?php $meta = get_post_meta( $post_id, 'wsl_stores_name', true ); ?>
							<input type="text" class="widefat" value="<?php echo ! empty( $meta ) ? esc_attr( $meta ) : ''; ?>" name="wsl_stores_name"/>
						</td>
					</tr>
					<tr>
						<td><?php echo esc_attr( __( 'Description', 'woosl' ) ); ?></td>
						<td>
							<?php
							$content = get_post_meta( $post_id, 'wsl_stores_description', true );
							wp_editor( $content, 'wsl_stores_description' );
							?>
						</td>
					</tr>
					<tr>
						<td><?php echo esc_attr( __( 'Phone', 'woosl' ) ); ?></td>
						<td><?php $meta = get_post_meta( $post_id, 'wsl_stores_phone', true ); ?>
							<input type="text" value="<?php echo ! empty( $meta ) ? esc_attr( $meta ) : ''; ?>" name="wsl_stores_phone" class="widefat"/>
						</td>
					</tr>
					<tr>
						<td><?php echo esc_attr( __( 'E-Mail', 'woosl' ) ); ?></td>
						<td><?php $meta = get_post_meta( $post_id, 'wsl_stores_email', true ); ?>
							<input type="text" value="<?php echo ! empty( $meta ) ? esc_attr( $meta ) : ''; ?>" name="wsl_stores_email" class="widefat"/>
						</td>
					</tr>
					<tr>
						<td><?php echo esc_attr( __( 'Website', 'woosl' ) ); ?></td>
						<td><?php $meta = get_post_meta( $post_id, 'wsl_stores_website', true ); ?>
							<input type="text" value="<?php echo ! empty( $meta ) ? esc_attr( $meta ) : ''; ?>" name="wsl_stores_website" class="widefat"/>
						</td>
					</tr>
					<tr>
						<td><?php echo esc_attr( __( 'Working Hours', 'woosl' ) ); ?></td>
							<?php
							$days      = array( 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday' );
							$days_meta = get_post_meta( $post_id, 'wsl_stores_days', true );
							?>
						<td>
							<table id="wsl_stores_hours" style="background-color: rgb(241, 241, 241); border-radius: 5px;" class="widefat">
								<?php foreach ( $days as $day ) : ?>
								<tr>
									<td style="border-bottom: 1px solid #dbdbdb;"><?php echo esc_attr( $day ); ?></td>
									<td style="border-bottom: 1px solid #dbdbdb;">
										<input <?php echo ( isset( $days_meta[ $day ]['status'] ) && '1' == $days_meta[ $day ]['status'] ) ? 'checked' : ''; ?> type="radio" value="1" id="wsl_stores_days_<?php echo esc_attr( $day ); ?>_1" name="wsl_stores_days[<?php echo esc_attr( $day ); ?>][status]" > <label for="wsl_stores_days_<?php echo esc_attr( $day ); ?>_1"> Opened </label>
										<input <?php echo ( ! isset( $days_meta[ $day ]['status'] ) || '0' == $days_meta[ $day ]['status'] ) ? 'checked' : ''; ?> type="radio" value="0" id="wsl_stores_days_<?php echo esc_attr( $day ); ?>_0" name="wsl_stores_days[<?php echo esc_attr( $day ); ?>][status]" /> <label for="wsl_stores_days_<?php echo esc_attr( $day ); ?>_0"> Closed </label>
									</td>
									<td style="border-bottom: 1px solid #dbdbdb;">
										<input <?php echo ( isset( $days_meta[ $day ]['status'] ) && '1' == $days_meta[ $day ]['status'] ) ? '' : 'style="display: none;"'; ?> size="9" placeholder="Open Time" type="text" value="<?php echo ( isset( $days_meta[ $day ]['start'] ) ) ? esc_attr( $days_meta[ $day ]['start'] ) : ''; ?>" name="wsl_stores_days[<?php echo esc_attr( $day ); ?>][start]" class="start_time ui-timepicker-input"/>
										<input <?php echo ( isset( $days_meta[ $day ]['status'] ) && '1' == $days_meta[ $day ]['status'] ) ? '' : 'style="display: none;"'; ?> size="9" placeholder="Close Time" type="text" value="<?php echo ( isset( $days_meta[ $day ]['end'] ) ) ? esc_attr( $days_meta[ $day ]['end'] ) : ''; ?>" name="wsl_stores_days[<?php echo esc_attr( $day ); ?>][end]" class="end_time ui-timepicker-input" />
									</td>
								</tr>
								<?php endforeach; ?>
							</table>
						</td>
					</tr>
					</tbody>
				</table>
				<?php
				$store_reviews = get_option( 'wsl_store_review' );

				?>
			<?php
		}
		/**
		 * Register block
		 */
		public function wsl_gutenberg_block() {
			// Skip block registration if Gutenberg is not enabled/merged.
			if ( ! function_exists( 'register_block_type' ) ) {
				return;
			}
			$wslFrontend = new Wsl_Frontend();
			$index_js    = 'assets/js/index.js';
			wp_register_script(
				'wsl-block-script',
				plugins_url( $index_js, WOOCOMMERCE_STORE_LOCATOR ),
				array(
					'wp-blocks',
					'wp-i18n',
					'wp-element',
					'wp-components',
				),
				WOOCOMMERCE_STORE_LOCATOR_VERSION
			);
			register_block_type(
				'wsl-block/store-finder',
				array(
					'editor_script'   => 'wsl-block-script',
					'render_callback' => array( $wslFrontend, 'wsl_shortcode' ),
					'icon'            => 'location-alt',
				)
			);
		}
		public function wsl_stores_meta_box_callback_address_info( $post ) {
			$post_id = $post->ID;
			?>
			<table class="form-table">
				<tbody>
					<tr>
						<th><?php echo esc_attr( __( 'Address', 'woosl' ) ); ?></th>
							<td><?php $meta = get_post_meta( $post_id, 'wsl_stores_address', true ); ?>
								<input id="wsl_stores_address" type="text" value="<?php echo ! empty( $meta ) ? esc_attr( $meta ) : ''; ?>" name="wsl_stores_address" class="widefat"/>
							</td>
					</tr>
					<tr>
						<th><?php echo esc_attr( __( 'Store Longitude', 'woosl' ) ); ?></th>
						<td><?php $meta = get_post_meta( $post_id, 'wsl_stores_lng', true ); ?>
							<input   type="text" value="<?php echo ! empty( $meta ) ? esc_attr( $meta ) : ''; ?>" class="widefat" disabled />
						</td>
					</tr>
					<tr>
						<th><?php echo esc_attr( __( 'Store latitude', 'woosl' ) ); ?></th>
						<td><?php $meta = get_post_meta( $post_id, 'wsl_stores_lat', true ); ?>
							<input  type="text" value="<?php echo ! empty( $meta ) ? esc_attr( $meta ) : ''; ?>" class="widefat" disabled  />
						</td>
					</tr>
					<tr>
						<th><?php echo esc_attr( __( 'Country', 'woosl' ) ); ?></th>
						<td>
							<select name="wsl_stores_country" id="wsl_stores_country" class="widefat">
								<option value="" ></option>
								<?php
								global $woocommerce;
								$countries_obj = new WC_Countries();
								$countries     = $countries_obj->__get( 'countries' );

								$selectedCountry = get_post_meta( $post_id, 'wsl_stores_country', true );
								foreach ( $countries as $key => $value ) {
									?>
									<option value="<?php echo esc_attr( $key ); ?>" <?php echo ( $selectedCountry == $key ) ? 'selected' : ''; ?>><?php echo esc_attr( $value ); ?></option>
									<?php
								}
								?>
								</select>
						</td>
					</tr>
					<tr>
						<th><?php echo esc_attr( __( 'City', 'woosl' ) ); ?></th>
						<td>
							<input id="wsl_stores_city" type="text" value="<?php echo get_post_meta( $post_id, 'wsl_stores_city', true ) ? esc_attr( get_post_meta( $post_id, 'wsl_stores_city', true ) ) : ''; ?>" name="wsl_stores_city" class="widefat"/>
						</td>
					</tr>
					<tr>
						<th><?php echo esc_attr( __( 'Postal Code', 'woosl' ) ); ?></th>
						<td>
							<input id="wsl_stores_zipcode" type="text" value="<?php echo get_post_meta( $post_id, 'wsl_stores_zipcode', true ) ? esc_attr( get_post_meta( $post_id, 'wsl_stores_zipcode', true ) ) : ''; ?>" name="wsl_stores_zipcode" class="widefat"/>
						</td>
					</tr>
				</tbody>
			</table>
			<input type="hidden" value="<?php echo get_post_meta( $post_id, 'wsl_stores_lat', true ) ? esc_attr( get_post_meta( $post_id, 'wsl_stores_lat', true ) ) : ''; ?>" name="wsl_stores_lat" id="wsl_stores_lat"/>
			<input type="hidden" value="<?php echo get_post_meta( $post_id, 'wsl_stores_lng', true ) ? esc_attr( get_post_meta( $post_id, 'wsl_stores_lng', true ) ) : ''; ?>" name="wsl_stores_lng" id="wsl_stores_lng"/>
			<div id="map-container" style="position: relative;">
				<div id="map_loader" style="z-index: 9;width: 100%; height: 200px;position: absolute;background-color: #fff;"><div class="uil-ripple-css" style="transform: scale(0.6); margin-left: auto; margin-right: auto;"><div></div><div></div></div></div>
				<div id="map-canvas" style="height: 200px;width: 100%;"></div>
			</div>
			<?php
		}

		public function wsl_stores_save_meta_box_data( $post_id ) {

			if ( isset( $_POST['post_type'] ) && WOOCOMMERCE_STORE_LOCATOR_POSTTYPE == $_POST['post_type'] ) {
				// Check if our nonce is set.
				if ( ! isset( $_POST['wsl_stores_meta_box_nonce'] ) ) {
					return;
				}
				// Verify that the nonce is valid.
				if ( ! wp_verify_nonce( sanitize_text_field( $_POST['wsl_stores_meta_box_nonce'] ), 'wsl_stores_save_meta_box_data' ) ) {
					return;
				}
				// If this is an autosave, our form has not been submitted, so we don't want to do anything.
				if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
					return;
				}

				// update post title
				remove_action( 'save_post', array( $this, 'wsl_stores_save_meta_box_data' ) );
				$my_post = array(
					'ID'         => $post_id,
					'post_title' => ( isset( $_POST['wsl_stores_name'] ) && ! empty( $_POST['wsl_stores_name'] ) ? sanitize_text_field( $_POST['wsl_stores_name'] ) : '' ),
					'post_name'  => wp_unique_post_slug(
						( isset( $_POST['wsl_stores_name'] ) && ! empty( $_POST['wsl_stores_name'] ) ? sanitize_text_field( $_POST['wsl_stores_name'] ) : '' ),
						$post_id,
						'publish',
						WOOCOMMERCE_STORE_LOCATOR_POSTTYPE,
						$post_parent = null
					),
				);
				wp_update_post( $my_post );
				add_action( 'save_post', array( $this, 'wsl_stores_save_meta_box_data' ) );

				// update post meta
				if ( isset( $_POST['wsl_stores_name'] ) ) {
					update_post_meta( $post_id, 'wsl_stores_name', sanitize_text_field( $_POST['wsl_stores_name'] ) );
				}

				if ( isset( $_POST['wsl_stores_address'] ) ) {
					update_post_meta( $post_id, 'wsl_stores_address', sanitize_text_field( $_POST['wsl_stores_address'] ) );
				}

				if ( isset( $_POST['wsl_stores_lat'] ) ) {
					update_post_meta( $post_id, 'wsl_stores_lat', sanitize_text_field( $_POST['wsl_stores_lat'] ) );
				}

				if ( isset( $_POST['wsl_stores_lng'] ) ) {
					update_post_meta( $post_id, 'wsl_stores_lng', sanitize_text_field( $_POST['wsl_stores_lng'] ) );
				}

				if ( isset( $_POST['wsl_stores_country'] ) ) {
					update_post_meta( $post_id, 'wsl_stores_country', sanitize_text_field( $_POST['wsl_stores_country'] ) );
				}

				if ( isset( $_POST['wsl_stores_state'] ) ) {
					update_post_meta( $post_id, 'wsl_stores_state', sanitize_text_field( $_POST['wsl_stores_state'] ) );
				}

				if ( isset( $_POST['wsl_stores_city'] ) ) {
					update_post_meta( $post_id, 'wsl_stores_city', sanitize_text_field( $_POST['wsl_stores_city'] ) );
				}

				if ( isset( $_POST['wsl_stores_phone'] ) ) {
					update_post_meta( $post_id, 'wsl_stores_phone', sanitize_text_field( $_POST['wsl_stores_phone'] ) );
				}

				if ( isset( $_POST['wsl_stores_email'] ) ) {
					update_post_meta( $post_id, 'wsl_stores_email', sanitize_text_field( $_POST['wsl_stores_email'] ) );
				}

				if ( isset( $_POST['wsl_stores_website'] ) ) {
					update_post_meta( $post_id, 'wsl_stores_website', sanitize_text_field( $_POST['wsl_stores_website'] ) );
				}

				if ( isset( $_POST['wsl_stores_zipcode'] ) ) {
					update_post_meta( $post_id, 'wsl_stores_zipcode', sanitize_text_field( $_POST['wsl_stores_zipcode'] ) );
				}

				if ( isset( $_POST['wsl_stores_code'] ) ) {
					update_post_meta( $post_id, 'wsl_stores_code', sanitize_text_field( $_POST['wsl_stores_code'] ) );
				}

				if ( isset( $_POST['wsl_stores_days'] ) ) {
					$wsl_stores_days = array();
					for ( $i = 0; $i < count( $_POST['wsl_stores_days'] ); $i++ ) {
						$day = '';
						if ( 0 == $i ) {
							$day = 'Monday';
						} elseif ( 1 == $i ) {
							$day = 'Tuesday';
						} elseif ( 2 == $i ) {
							$day = 'Wednesday';
						} elseif ( 3 == $i ) {
							$day = 'Thursday';
						} elseif ( 4 == $i ) {
							$day = 'Friday';
						} elseif ( 5 == $i ) {
							$day = 'Saturday';
						} elseif ( 6 == $i ) {
							$day = 'Sunday';
						}

						if ( isset( $_POST['wsl_stores_days'][ $day ]['status'] ) ) {
							$wsl_stores_days[ $day ]['status'] = intval( $_POST['wsl_stores_days'][ $day ]['status'] );
						}
						if ( isset( $_POST['wsl_stores_days'][ $day ]['start'] ) ) {
							$wsl_stores_days[ $day ]['start'] = sanitize_text_field( $_POST['wsl_stores_days'][ $day ]['start'] );
						}
						if ( isset( $_POST['wsl_stores_days'][ $day ]['end'] ) ) {
							$wsl_stores_days[ $day ]['end'] = sanitize_text_field( $_POST['wsl_stores_days'][ $day ]['end'] );
						}
					}

					update_post_meta( $post_id, 'wsl_stores_days', $wsl_stores_days );
				}

				if ( isset( $_POST['wsl_stores_description'] ) ) {

					update_post_meta( $post_id, 'wsl_stores_description', sanitize_text_field( $_POST['wsl_stores_description'] ) );
				}
				if ( isset( $_POST['wsl_stores_info'] ) ) {

					 update_post_meta( $post_id, 'wsl_stores_info', sanitize_text_field( $_POST['wsl_stores_info'] ) );

				}
			}
		}

	}
	new WSL_Manage_Stores();
}
