<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// Exit if accessed directly


add_action( 'add_meta_boxes_product', 'wsl_add_meta_boxes_product' );

	// Register Your Meta box
function wsl_add_meta_boxes_product( $post ) {

	add_meta_box(
		'wsl_product_meta_box', // this is HTML id
		'Stores',
		'wsl_product_meta_box', // the callback function
		'product', // register on post type = page
		'side',
		'core'
	);
}

function wsl_product_meta_box( $post ) {

	$assigned_stores = get_post_meta( $post->ID, 'wsl_product_stores', true );
	$assigned_stores = explode( ',', $assigned_stores );

	$stores = get_posts(
		array(
			'post_type'   => WOOCOMMERCE_STORE_LOCATOR_POSTTYPE,
			'post_status' => 'publish',
			'numberposts' => -1,
		)
	);
	?>
	<ul>
	<?php
	foreach ( $stores as $store ) {
		?>
	<li>
	<input value="<?php echo esc_attr( $store->ID ); ?>" type="checkbox" name="wsl_product_stores[]" <?php echo esc_attr( in_array( $store->ID, $assigned_stores ) ? 'checked="checked"' : '' ); ?>> <?php echo esc_attr( $store->post_title ); ?>
	</li>
		<?php
	}
	wp_nonce_field( 'woosl_product_stores_nonce', 'product_stores_nonce' );
	?>
	</ul>
	<?php
}

add_action( 'save_post_product', 'wsl_save_post_product' );

function wsl_save_post_product( $post_ID ) {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return $post_ID;
	}
	if ( ! isset( $_POST['product_stores_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( $_POST['product_stores_nonce'] ), 'woosl_product_stores_nonce' ) ) {
		return $post_ID;
	}

	if ( isset( $_POST['wsl_product_stores'] ) ) {
		$store_ids = '';
		if ( count( $_POST['wsl_product_stores'] ) > 1 ) {
			$store_ids = sanitize_text_field( implode( ',', array_map( 'absint', $_POST['wsl_product_stores'] ) ) );
		} else {
			if ( isset( $_POST['wsl_product_stores'][0] ) ) {
				$store_ids = sanitize_text_field( absint( $_POST['wsl_product_stores'][0] ) );
			}
		}
		update_post_meta( $post_ID, 'wsl_product_stores', $store_ids );

	} else {
		update_post_meta( $post_ID, 'wsl_product_stores', '' );
	}
}
