// Bind events to the page

jQuery( document ).ready(
	function (jQuery) {

		if (wsl_frontend.settings.general._locate_user == 'yes') {
			wsl_map_autolocate_user();
		} else {
			wsl_map_input_address( true )
		}

		jQuery( '.woosl-submit' ).on(
			'click',
			function (e) {

				var default_location = jQuery( '._start_location' ).val();
				wsl_map_initialize( default_location );
			}
		);

		var input        = document.getElementById( '_start_point' );
		var autocomplete = new google.maps.places.Autocomplete( input );
		google.maps.event.addListener(
			autocomplete,
			'place_changed',
			function () {
				wsl_map_input_address( false );
			}
		);

	}
);

function showhide_moreinfo(id){
	if (jQuery( '#woosl-moreinfo-' + id ).hasClass( "woosl-hide" )) {
		jQuery( '.woosl-moreinfo' ).addClass( "woosl-hide" );
		jQuery( '#woosl-moreinfo-' + id ).removeClass( "woosl-hide" );
	} else {
		jQuery( '.woosl-moreinfo' ).addClass( "woosl-hide" );
	}
}
/*
jQuery('#woosl-store-details').click(function() {
	 var id = jQuery(this).attr('data-moreinfoid');



 });
*/

function wsl_map_initialize(default_location) {

	var start_point     = jQuery( '._start_point' ).val();
	var start_point_lat = jQuery( '._search_lat' ).val();
	var start_point_lng = jQuery( '._search_lng' ).val();

	if (default_location && start_point == default_location) {
		var start_point_lat = jQuery( '._start_point_lat' ).val();
		var start_point_lng = jQuery( '._start_point_lng' ).val();
	}
		var product_id  = jQuery( '._product_id' ).val();
		var radius      = jQuery( '._radius_options' ).val();
		var max_results = jQuery( '._max_results' ).val();
		var stores_cat  = jQuery( '._stores_cat' ).val();
	if (start_point.length > 0) {

		if (jQuery( '._start_point' ).hasClass( 'woosl-required-field' )) {
			jQuery( '._start_point' ).removeClass( 'woosl-required-field' );
		}
	} else {
		jQuery( "._start_point" ).addClass( "woosl-required-field" );
		alert( wsl_frontend.settings.labels._label_your_location + " is a required field" );
		return;
	}

	if ( ! product_id || product_id == undefined) {
		// alert('Could not identify Product');
		alert( wsl_frontend.settings.labels._label_general_error );
		return;
	}

	var data = {
		'action': 'wsl_map_request',
		'start_point_lat': start_point_lat,
		'start_point_lng': start_point_lng,
		'product_id': product_id,
		'radius': radius,
		'max_results': max_results,
		'unit': wsl_frontend.settings.general._distance_unit,
		'store_cat': stores_cat,
		'wsl_nonce':wsl_frontend.wsl_nonce
	};

	jQuery.post(
		wsl_frontend.ajax_url,
		data,
		function(response) {

			var stores_details = JSON.parse( response );

			if (stores_details['stores'] != false && stores_details['stores'] != null) {
				stores_arr = Object.entries( stores_details['stores'] );
			} else {
				stores_arr = [];
			}

			wsl_update_map( stores_arr,start_point_lat,start_point_lng );
		}
	);
}


function wsl_update_map(stores_details, center_lat, center_lng){

	var scrollbyzoom      = false;
	var zoom_on_page_load = 8;
	var mapTypeControl    = false;
	var streetview        = false;
	var mapType           = "roadmap";
	if (wsl_frontend.settings.general._scroll_wheel_zoom == "yes") {
		var scrollbyzoom = true;
	}
	if (wsl_frontend.settings.general._show_map_type == "yes") {
		var mapTypeControl = true;
	}
	if (wsl_frontend.settings.general._show_streetview == "yes") {
		var streetview = true;
	}

	wsl_map = new google.maps.Map(
		document.getElementById( 'woosl-gmap' ),
		{
			zoom: zoom_on_page_load,
			center: new google.maps.LatLng( center_lat, center_lng ),
			mapTypeControl: mapTypeControl,
			scrollwheel: scrollbyzoom,
			streetViewControl: streetview,
			gestureHandling: 'cooperative',
			mapTypeId: google.maps.MapTypeId[mapType.toUpperCase()]
		}
	);

	var bounds     = new google.maps.LatLngBounds();
	var infowindow = new google.maps.InfoWindow();

	var start_marker     = wsl_frontend.settings.general._start_markers;
	var store_marker     = wsl_frontend.settings.general._store_markers;
	var start_marker_url = wsl_frontend.images_url + start_marker + '.png';
	var store_marker_url = wsl_frontend.images_url + store_marker + '.png';

	var marker_start = new google.maps.Marker(
		{
			position: new google.maps.LatLng( center_lat, center_lng ),
			map: wsl_map,
			animation: google.maps.Animation.DROP,
			icon: start_marker_url
		}
	);

	bounds.extend( marker_start.position );

	 // default location info window
	google.maps.event.addListener(
		marker_start,
		'click',
		function () {
			infowindow.setContent( document.getElementById( "_start_point" ).value );
			infowindow.open( wsl_map, marker_start );
		}
	);

	var stores = [];
	jQuery( '.woosl-results-list ul' ).html( '' );
	jQuery( '#woosl-directionsPanel' ).html( '' );
	if (stores_details.length == 0) {
		jQuery( '.woosl-results-list ul' ).html( '<li><h3>' + wsl_frontend.settings.labels._label_no_results_found + '</h3></li>' );
	} else {

		for (i = 0; i < stores_details.length; i++) {
			  a = Object.entries( stores_details[i] );   // issues here need to be fixed before releasing

			  jQuery( '.woosl-results-list ul' ).append( a[1][1]['wsl_stores_list'] );

			var store = new google.maps.Marker(
				{
					position: new google.maps.LatLng( a[1][1]['wsl_stores_lat'], a[1][1]['wsl_stores_lng'] ),
					map: wsl_map,
					animation: google.maps.Animation.DROP,
					icon: store_marker_url,
					id: a[1][1]['wsl_stores_id']
				}
			);
			  stores.push( store );
			  bounds.extend( store.position );

			google.maps.event.addListener(
				store,
				'click',
				(function (store, a) {

					var latitude  = parseFloat( a[1][1]['wsl_stores_lat'] );
					var longitude = parseFloat( a[1][1]['wsl_stores_lng'] );

					return function () {
						infowindow.setContent( a[1][1]['wsl_stores_infowindow'] );
						infowindow.open( wsl_map, store );
						jQuery( '#list-item-' + a[1][1]['wsl_stores_id'] ).parent().prepend( jQuery( '#list-item-' + a[1][1]['wsl_stores_id'] ) ).slideDown();

					}
				})(
					store,
					a
				)
			);

			  (function(_store,_store_id){
				jQuery( '#list-item-' + _store_id ).on(
					'mouseenter',
					function(e){
						_store.setAnimation( google.maps.Animation.BOUNCE );

					}
				);
				jQuery( '#list-item-' + _store_id ).mouseleave(
					function(e){

						_store.setAnimation( null );

					}
				);

			  })( store,a[1][1]['wsl_stores_id'] );

		}
	}

	if (stores.length < 1) {
		setTimeout(
			function() {
				wsl_map.setZoom( 10 );
			},
			50
		);
	}

	wsl_map.fitBounds( bounds );

	if (wsl_frontend.settings.general._show_map_cluster === 'yes') {
		var markerCluster = new MarkerClusterer(
			wsl_map,
			stores,
			{imagePath: 'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/m'}
		);

	}

}


function show_store_direction(end_lat, end_lng) {
	var start       = document.getElementById( '_start_point' ).value;
	var markerArray = [];
	var stepDisplay = new google.maps.InfoWindow();
	var unit_system = google.maps.UnitSystem.IMPERIAL;
	if (wsl_frontend.settings.general._distance_unit == 'km') {
		unit_system = google.maps.UnitSystem.METRIC;
	}

	var end = new google.maps.LatLng( end_lat, end_lng );

	if (start !== '' && end !== '') {
		road_direction        = 1;
		var map               = new google.maps.Map(
			document.getElementById( 'woosl-gmap' ),
			{
				zoom: 7,
			}
		);
		var directionsDisplay = new google.maps.DirectionsRenderer(
			{
				map: map,
				panel: document.getElementById( 'woosl-directionsPanel' )
			}
		);
		var directionsService = new google.maps.DirectionsService();
		directionsDisplay.addListener(
			'directions_changed',
			function() {
				computeTotalDistance( directionsDisplay.getDirections() );
			}
		);

		directionsService.route(
			{
				origin: start,
				destination: end,
				travelMode: 'DRIVING',
				unitSystem: unit_system,
			},
			function(response, status) {
				if (status === 'OK') {
					jQuery( '#woosl-directionsPanel' ).html( '' );
					jQuery( '#woosl-directionsPanel' ).html( '<a class="woosl-direction-back" onClick="direction_panel_back()">' + wsl_frontend.settings.labels._label_back + '</a>' );
					directionsDisplay.setDirections( response );
					showSteps( response, markerArray, stepDisplay, map );
					directionsDisplay.setOptions(
						{
							// suppressMarkers: true,
						}
					);
					jQuery( '#woosl-directionsPanel' ).css( 'height',400 ).show();
					jQuery( '.woosl-results-list ul' ).hide();

				} else {
					window.alert( wsl_frontend.settings.labels._label_no_directions_found + ' ' + status );
				}
			}
		);
	} else {
		// alert('One of the direction field is empty');
		alert( wsl_frontend.settings.labels._label_no_directions_found );
	}
}

function computeTotalDistance(result) {
	var total   = 0;
	var myroute = result.routes[0];
	for (var i = 0; i < myroute.legs.length; i++) {
		total += myroute.legs[i].distance.value;
	}
	total = total / 1000;
	// document.getElementById('total').innerHTML = total + ' km';
}
function showSteps(directionResult, markerArray, stepDisplay, map) {
	var myRoute = directionResult.routes[0].legs[0];
	for (var i = 0; i < myRoute.steps.length; i++) {
		var marker = markerArray[i] = markerArray[i] || new google.maps.Marker();
		marker.setMap( map );
		marker.setPosition( myRoute.steps[i].start_location );
		attachInstructionText(
			stepDisplay,
			marker,
			myRoute.steps[i].instructions,
			map
		);
	}
}

function attachInstructionText(stepDisplay, marker, text, map) {
	google.maps.event.addListener(
		marker,
		'click',
		function() {
			// Open an info window when the marker is clicked on, containing the text
			// of the step.
			stepDisplay.setContent( text );
			stepDisplay.open( map, marker );
		}
	);
}


function wsl_map_autolocate_user(){

	if (navigator.geolocation) {
		navigator.geolocation.getCurrentPosition(
			function (position) {
				var pos = {
					lat: position.coords.latitude,
					lng: position.coords.longitude
				};

				var geocoder = new google.maps.Geocoder();
				geocoder.geocode(
					{
						'location': pos
					},
					function (results, status) {
						if (status === google.maps.GeocoderStatus.OK) {
							if (results[0]) {
								jQuery( '._start_point' ).val( results[0].formatted_address );
								jQuery( '._start_location' ).val( results[0].formatted_address );
								jQuery( '._search_lat' ).val( pos.lat );
								jQuery( '._search_lng' ).val( pos.lng );
								jQuery( '._start_point_lat' ).val( pos.lat );
								jQuery( '._start_point_lng' ).val( pos.lng );
								wsl_map_initialize();

							} else {
								// alert(wsl_frontend.settings.labels._label_general_error);
								wsl_map_input_address( true );
							}
						} else {
							// alert(wsl_frontend.settings.labels._label_general_error);
							wsl_map_input_address( true );
						}
					}
				);
			},
			function () {
				// alert(wsl_frontend.settings.labels._label_general_error);
				wsl_map_input_address( true );
			}
		);
	} else {
		// alert(wsl_frontend.settings.labels._label_general_error);
		wsl_map_input_address( true );
	}
}



function wsl_map_input_address(update_map){  // if true update map (used on initial load), else just update coordinates (used in autocomplete)
	addressString = jQuery( '._start_point' ).val();
	var address   = (addressString) ? addressString : "United States";
	var geocoder  = new google.maps.Geocoder();
	geocoder.geocode(
		{'address': address},
		function (results, status) {
			if (status == google.maps.GeocoderStatus.OK) {

				jQuery( '._search_lat' ).val( results[0].geometry.location.lat() );
				jQuery( '._search_lng' ).val( results[0].geometry.location.lng() );

				if (update_map == true) {
					jQuery( '._start_point_lat' ).val( results[0].geometry.location.lat() );
					jQuery( '._start_point_lng' ).val( results[0].geometry.location.lng() );
					wsl_map_initialize();
				}
			}
		}
	);
}


function direction_panel_back(){
	jQuery( '#woosl-directionsPanel' ).html( '' );
	jQuery( '#woosl-directionsPanel' ).hide();
	jQuery( '.woosl-results-list ul' ).show();
	wsl_map_initialize();
}
