// Bind events to the page

jQuery( document ).ready(
	function (jQuery) {

		// bind onchange event on selecting open/close store days
		jQuery( '#wsl_stores_hours input[type="radio"]' ).change(
			function () {
				if (jQuery( this ).val() == '1') {
					var start_elem = jQuery( this ).attr( 'name' ).replace( '[status]', '[start]' );
					var end_elem   = jQuery( this ).attr( 'name' ).replace( '[status]', '[end]' );
					jQuery( '[name="' + start_elem + '"]' ).show();
					jQuery( '[name="' + end_elem + '"]' ).show();
				} else {
					var start_elem = jQuery( this ).attr( 'name' ).replace( '[status]', '[start]' );
					var end_elem   = jQuery( this ).attr( 'name' ).replace( '[status]', '[end]' );
					jQuery( '[name="' + start_elem + '"]' ).val( '' );
					jQuery( '[name="' + start_elem + '"]' ).hide();
					jQuery( '[name="' + end_elem + '"]' ).val( '' );
					jQuery( '[name="' + end_elem + '"]' ).hide();
				}
			}
		);

		function  initializeMapBackend() {
			jQuery( '#map_loader' ).hide();
			// Handle google maps
			var oldMarker;
			var updateMapDuration;
			var mapOptions = {
				scrollwheel: false,
				zoom: 13,
				center: new google.maps.LatLng( 1, 1 )
			};

			// display default address on map
			var map = new google.maps.Map( document.getElementById( 'map-canvas' ), mapOptions );

			setTimeout(
				function () {

					if (jQuery( '#wsl_stores_lat' ).val() && jQuery( '#wsl_stores_lng' ).val()) {
						var currentLatLng = new google.maps.LatLng( parseFloat( jQuery( '#wsl_stores_lat' ).val() ), parseFloat( jQuery( '#wsl_stores_lng' ).val() ) );
						marker            = new google.maps.Marker(
							{
								position: currentLatLng,
								map: map
							}
						);
						oldMarker         = marker;
						map.setCenter( currentLatLng );
					} else {
						var addressString = jQuery( '#wsl_stores_address' ).val();
						addressString     = (jQuery( '#wsl_stores_city' ).val()) ? (addressString + " " + jQuery( '#wsl_stores_city' ).val()) : addressString;
						addressString     = (jQuery( '#wsl_stores_state' ).val()) ? (addressString + ", " + jQuery( '#wsl_stores_state' ).val()) : addressString;
						addressString     = (jQuery( '#wsl_stores_country' ).val()) ? (addressString + " " + jQuery( '#wsl_stores_country' ).val()) : addressString;
						addressString     = (jQuery( '#wsl_stores_zipcode' ).val()) ? (addressString + " " + jQuery( '#wsl_stores_zipcode' ).val()) : addressString;

						var address  = (addressString) ? addressString : "United State";
						var geocoder = new google.maps.Geocoder();
						geocoder.geocode(
							{'address': address},
							function (results, status) {
								if (status == google.maps.GeocoderStatus.OK) {
									jQuery( '#wsl_stores_lat' ).val( results[0].geometry.location.lat() );
									jQuery( '#wsl_stores_lng' ).val( results[0].geometry.location.lng() );
									var currentLatLng = new google.maps.LatLng( results[0].geometry.location.lat(), results[0].geometry.location.lng() );
									marker            = new google.maps.Marker(
										{
											position: currentLatLng,
											map: map
										}
									);
									oldMarker         = marker;
									map.setCenter( currentLatLng );
								}
							}
						);
					}
				},
				1000
			);
			// move marker when click on map
			google.maps.event.addListener(
				map,
				"click",
				function (event) {
					marker = new google.maps.Marker(
						{
							position: event.latLng,
							map: map
						}
					);

					if (oldMarker != undefined) {
						oldMarker.setMap( null );
					}

					oldMarker = marker;
					jQuery( '#wsl_stores_lat' ).val( event.latLng.lat() );
					jQuery( '#wsl_stores_lng' ).val( event.latLng.lng() );
				}
			);

			jQuery( '#wsl_stores_address, #wsl_stores_city, #wsl_stores_country, #wsl_stores_country, #wsl_stores_state' ).change(
				function () {

					clearTimeout( updateMapDuration );
					jQuery( '#map_loader' ).show();
					updateMapDuration = setTimeout(
						function () {
							var addressString = jQuery( '#wsl_stores_address' ).val();
							addressString     = (jQuery( '#wsl_stores_city' ).val()) ? (addressString + " " + jQuery( '#wsl_stores_city' ).val()) : addressString;
							addressString     = (jQuery( '#wsl_stores_state' ).val()) ? (addressString + ", " + jQuery( '#wsl_stores_state' ).val()) : addressString;
							addressString     = (jQuery( '#wsl_stores_country' ).val()) ? (addressString + " " + jQuery( '#wsl_stores_country' ).val()) : addressString;
							addressString     = (jQuery( '#store_locator_zipcode' ).val()) ? (addressString + " " + jQuery( '#wsl_stores_zipcode' ).val()) : addressString;
							var address       = (addressString) ? addressString : "United States";
							var geocoder      = new google.maps.Geocoder();
							geocoder.geocode(
								{'address': address},
								function (results, status) {
									if (status == google.maps.GeocoderStatus.OK) {
										jQuery( '#map_loader' ).hide();
										jQuery( '#wsl_stores_lat' ).val( results[0].geometry.location.lat() );
										jQuery( '#wsl_stores_lng' ).val( results[0].geometry.location.lng() );
										var currentLatLng = new google.maps.LatLng( results[0].geometry.location.lat(), results[0].geometry.location.lng() );
										marker            = new google.maps.Marker(
											{
												position: currentLatLng,
												map: map
											}
										);
										if (oldMarker != undefined) {
												oldMarker.setMap( null );
										}

										oldMarker = marker;
										map.setCenter( currentLatLng );
									}
								}
							);
						},
						1000
					);
				}
			);
		}

		jQuery( '.wsl-markers' ).parent().wrap( "<div class='admin-markers' style='display:inline; float: left;  '> </div>" );

		jQuery( '.admin-markers:eq(0)' ).append( "<img id='theImg' src='" + wsl.assets_url + "/img/blue.png' />" );
		jQuery( '.admin-markers:eq(1)' ).append( "<img id='theImg' src='" + wsl.assets_url + "/img/red.png' />" );
		jQuery( '.admin-markers:eq(2)' ).append( "<img id='theImg' src='" + wsl.assets_url + "/img/green.png' />" );
		jQuery( '.admin-markers:eq(3)' ).append( "<img id='theImg' src='" + wsl.assets_url + "/img/orange.png' />" );
		jQuery( '.admin-markers:eq(4)' ).append( "<img id='theImg' src='" + wsl.assets_url + "/img/purple.png' />" );
		jQuery( '.admin-markers:eq(5)' ).append( "<img id='theImg' src='" + wsl.assets_url + "/img/yellow.png' />" );
		jQuery( '.admin-markers:eq(6)' ).append( "<img id='theImg' src='" + wsl.assets_url + "/img/blue.png' />" );
		jQuery( '.admin-markers:eq(7)' ).append( "<img id='theImg' src='" + wsl.assets_url + "/img/red.png' />" );
		jQuery( '.admin-markers:eq(8)' ).append( "<img id='theImg' src='" + wsl.assets_url + "/img/green.png' />" );
		jQuery( '.admin-markers:eq(9)' ).append( "<img id='theImg' src='" + wsl.assets_url + "/img/orange.png' />" );
		jQuery( '.admin-markers:eq(10)' ).append( "<img id='theImg' src='" + wsl.assets_url + "/img/purple.png' />" );
		jQuery( '.admin-markers:eq(11)' ).append( "<img id='theImg' src='" + wsl.assets_url + "/img/yellow.png' />" );

		if (document.getElementById( 'map-canvas' )) {
			initializeMapBackend();
		}

		/*
		useGmaps = false;
		function gmaps_Loaded() {

		alert("testing");
		var service = new google.maps.places.AutocompleteService();
		service.getPlacePredictions({
			input: 'Brisbane,Australia',
			types: ['(cities)']
		},
		function(predictions, status) {
			if (status == google.maps.places.PlacesServiceStatus.OK) {
				alert("working")
			}
			else{
				alert("not working")
			}
		});
		}

		google.maps.event.addDomListener(window, 'load', gmaps_Loaded);



		console.log(useGmaps);
		console.log(typeof(google));
		console.log(google);

		if (useGmaps === true && typeof(google) !== 'undefined') {
		alert("loaded");
		initializeMapBackend();
		}
		else{
		alert("not loaded");
		}
		*/

		if (document.getElementById( 'wsl_groupsList' ) || document.getElementById( 'file-input' )) {
			jQuery( '.woocommerce-save-button' ).hide();
		}

		jQuery( '.start_time, .end_time' ).timepicker(
			{
				'showDuration': true,
				'timeFormat': 'g:i a'
			}
		);

		jQuery( '.wsl_groupsList' ).sortable(
			{
				stop         : function(event,ui){ send_new_sort_order_of_fields( 'glist' ); }
			}
		); // worked great
		jQuery( '.wsl_itemsList' ).sortable(
			{
				connectWith: jQuery( '.wsl_itemsList' ),
				stop         : function(event,ui){ send_new_sort_order_of_fields( 'ilist' ); }
			}
		);

	}
);

function send_new_sort_order_of_fields(event){
	var children = document.getElementById( "wsl_groupsList" ).children;

	var idArr = {};

	for (var i = 0; i < children.length; i++) {
		var newArr    = [];
		var children1 = document.getElementById( children[i].id ).children;
		var children2 = document.getElementById( children1[1].id ).children;
		for (var j = 0; j < children2.length; j++) {
			if (children2[j].id) {
				newArr.push( children2[j].id );
			}
		}
		if (newArr) {
			idArr[children[i].id] = newArr;
			// console.log(newArr);
		}
	}

	var data = {
		'action': 'wsl_fields_sort_order',
		'fields_order': idArr,
		'wsl_nonce':wsl.wsl_nonce
	};

	// console.log(idArr);
	jQuery.post(
		wsl.ajax_url,
		data,
		function(response) {

		}
	);
}
