<?php
/**
 * Template for the UM Verified Users.
 * Used on the "Account" page, "Get Verified" account field
 * @version 2.1.5
 *
 * Caller: function um_verified_account_info()
 *
 * This template can be overridden by copying it to yourtheme/ultimate-member/um-verified-users/account_info.php
 * @var string $verified_status
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} ?>

<div class="um-field">

	<div class="um-field-label">
		<label><?php esc_html_e( 'Get Verified', 'um-verified' ); ?></label>
		<div class="um-clear"></div>
	</div>

	<?php if ( 'unverified' === $verified_status ) { ?>

		<div class="um-verified-info">
			<a href="<?php echo esc_url( UM()->Verified_Users_API()->api()->verify_url( $user_id, um_get_core_page( 'account' ) ) ); ?>" class="um-link um-verified-request-link"><?php esc_html_e( 'Request Verification', 'um-verified' ); ?></a>
		</div>

	<?php } elseif ( 'pending' === $verified_status ) { ?>

		<div class="um-verified-info">
			<?php
			/* translators: %s - cancel verification request link */
			printf( __( 'Your verification request is currently pending. <a href="%s" class="um-verified-cancel-request">Cancel request?</a>', 'um-verified' ), esc_url( $cancel ) );
			?>
		</div>

	<?php } ?>

</div>