<?php
namespace um_ext\um_verified_users\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Verified_Users_Enqueue
 * @package um_ext\um_verified_users\core
 */
class Verified_Users_Enqueue {

	/**
	 * Verified_Users_Enqueue constructor.
	 */
	public function __construct() {
		$priority = apply_filters( 'um_verified_enqueue_priority', 0 );
		add_action( 'wp_enqueue_scripts', array( &$this, 'enqueue_scripts' ), $priority );
	}

	/**
	 *
	 */
	public function enqueue_scripts() {
		$suffix = UM()->frontend()->enqueue()::get_suffix();
		wp_register_style( 'um-verified', um_verified_users_url . 'assets/css/um-verified' . $suffix . '.css', array(), um_verified_users_version );
	}
}
