<?php
namespace um_ext\um_verified_users\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Actions_Listener
 * @package um_ext\um_verified_users\core
 */
class Actions_Listener {

	/**
	 * Actions_Listener constructor.
	 */
	public function __construct() {
		add_action( 'admin_init', array( $this, 'actions_listener' ) );
		add_filter( 'um_adm_action_individual_nonce_actions', array( $this, 'extends_individual_nonce_actions' ) ); // @todo remove soon after UM core update
		add_filter( 'um_adm_action_custom_update_notice', array( &$this, 'extends_admin_action_notice' ), 10, 2 );
	}

	/**
	 * Handle wp-admin actions
	 *
	 * @since 2.8.7
	 */
	public function actions_listener() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		$rolename = UM()->roles()->get_priority_user_role( get_current_user_id() );
		$role     = get_role( $rolename );

		if ( null === $role ) {
			return;
		}

		// Add Ultimate Member bulk actions only when the current user has 'edit_users' capability.
		if ( ! current_user_can( 'edit_users' ) && ! $role->has_cap( 'edit_users' ) ) {
			return;
		}

		if ( ! empty( $_REQUEST['um_adm_action'] ) ) {
			switch ( sanitize_key( $_REQUEST['um_adm_action'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification -- there is nonce verification below for each case
				case 'verify_user':
					if ( empty( $_REQUEST['uid'] ) || ! is_numeric( $_REQUEST['uid'] ) ) {
						die( esc_html__( 'Invalid user ID', 'um-verified' ) );
					}

					$user_id = absint( $_REQUEST['uid'] );

					check_admin_referer( "verify_user{$user_id}" );

					$result = UM()->Verified_Users_API()->api()->verify( $user_id, true );

					$redirect = wp_get_referer();
					if ( $result ) {
						$redirect = add_query_arg(
							array(
								'update'         => 'um_verified',
								'verified_count' => 1,
							),
							$redirect
						);
					}
					wp_safe_redirect( $redirect );
					exit;
				case 'unverify_user':
					if ( empty( $_REQUEST['uid'] ) || ! is_numeric( $_REQUEST['uid'] ) ) {
						die( esc_html__( 'Invalid user ID', 'um-verified' ) );
					}

					$user_id = absint( $_REQUEST['uid'] );

					check_admin_referer( "unverify_user{$user_id}" );

					$result = UM()->Verified_Users_API()->api()->unverify( $user_id );

					$redirect = wp_get_referer();
					if ( $result ) {
						$redirect = add_query_arg(
							array(
								'update'           => 'um_unverified',
								'unverified_count' => 1,
							),
							$redirect
						);
					}
					wp_safe_redirect( $redirect );
					exit;
				case 'verification_approved':
					if ( empty( $_REQUEST['uid'] ) || ! is_numeric( $_REQUEST['uid'] ) ) {
						die( esc_html__( 'Invalid user ID', 'um-verified' ) );
					}

					$user_id = absint( $_REQUEST['uid'] );

					check_admin_referer( "verification_approved{$user_id}" );

					$result = UM()->Verified_Users_API()->api()->approve_verification( $user_id, true );

					$redirect = wp_get_referer();
					if ( $result ) {
						$redirect = add_query_arg(
							array(
								'update'         => 'um_verification_approved',
								'approved_count' => 1,
							),
							$redirect
						);
					}
					wp_safe_redirect( $redirect );
					exit;
				case 'verification_rejected':
					if ( empty( $_REQUEST['uid'] ) || ! is_numeric( $_REQUEST['uid'] ) ) {
						die( esc_html__( 'Invalid user ID', 'um-verified' ) );
					}

					$user_id = absint( $_REQUEST['uid'] );

					check_admin_referer( "verification_rejected{$user_id}" );

					$result = UM()->Verified_Users_API()->api()->reject_verification( $user_id );

					$redirect = wp_get_referer();
					if ( $result ) {
						$redirect = add_query_arg(
							array(
								'update'         => 'um_verification_rejected',
								'rejected_count' => 1,
							),
							$redirect
						);
					}
					wp_safe_redirect( $redirect );
					exit;
			}
		}
	}

	public function extends_individual_nonce_actions( $actions ) {
		$actions[] = 'verify_user';
		$actions[] = 'unverify_user';
		$actions[] = 'verification_approved';
		$actions[] = 'verification_rejected';
		return $actions;
	}

	public function extends_admin_action_notice( $messages, $update ) {
		if ( 'um_verified' === $update ) {
			$verified_count         = isset( $_REQUEST['verified_count'] ) ? absint( $_REQUEST['verified_count'] ) : 0;
			$messages[0]['content'] = sprintf( _n( '<strong>%s</strong> user has been verified.', '<strong>%s</strong> users have been verified.', $verified_count, 'um-verified' ), $verified_count );
		} elseif ( 'um_unverified' === $update ) {
			$unverified_count       = isset( $_REQUEST['unverified_count'] ) ? absint( $_REQUEST['unverified_count'] ) : 0;
			$messages[0]['content'] = sprintf( _n( '<strong>%s</strong> user has been unverified.', '<strong>%s</strong> users have been unverified.', $unverified_count, 'um-verified' ), $unverified_count );
		} elseif ( 'um_verification_approved' === $update ) {
			$approved_count         = isset( $_REQUEST['approved_count'] ) ? absint( $_REQUEST['approved_count'] ) : 0;
			$messages[0]['content'] = sprintf( _n( '<strong>%s</strong> user has been approved its verification request.', '<strong>%s</strong> users have been approved their verification request.', $approved_count, 'um-verified' ), $approved_count );
		} elseif ( 'um_verification_rejected' === $update ) {
			$rejected_count         = isset( $_REQUEST['rejected_count'] ) ? absint( $_REQUEST['rejected_count'] ) : 0;
			$messages[0]['content'] = sprintf( _n( '<strong>%s</strong> user has been rejected its verification request.', '<strong>%s</strong> users have been rejected their verification request.', $rejected_count, 'um-verified' ), $rejected_count );
		}
		return $messages;
	}
}
