<?php
namespace um_ext\um_verified_users\admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Enqueue
 * @package um_ext\um_verified_users\admin
 */
class Enqueue {

	/**
	 * Verified_Users_Enqueue constructor.
	 */
	public function __construct() {
		add_action( 'admin_enqueue_scripts', array( &$this, 'admin_enqueue_scripts' ) );
		add_action( 'enqueue_block_assets', array( &$this, 'block_editor' ) );

		add_action( 'load-customize.php', array( &$this, 'navmenu_scripts' ) );
		add_action( 'load-nav-menus.php', array( &$this, 'navmenu_scripts' ) );
	}

	/**
	 *
	 */
	public function admin_enqueue_scripts( $hook ) {
		$suffix = UM()->admin()->enqueue()::get_suffix();
		if ( 'users.php' === $hook ) {
			wp_register_script( 'um_verified_users_user_screen', um_verified_users_url . 'assets/js/admin/user' . $suffix . '.js', array( 'wp-hooks' ), um_verified_users_version, true );
			wp_enqueue_script( 'um_verified_users_user_screen' );
		}
	}

	/**
	 *
	 */
	public function block_editor() {
		$suffix = UM()->admin()->enqueue()::get_suffix();
		wp_register_script( 'um_verified_users_block', um_verified_users_url . 'assets/js/admin/block-restrictions' . $suffix . '.js', array( 'wp-hooks' ), um_verified_users_version, true );
		wp_enqueue_script( 'um_verified_users_block' );
	}

	public function navmenu_scripts() {
		add_action( 'admin_enqueue_scripts', array( &$this, 'enqueue_navmenu_scripts' ) );
	}

	public function enqueue_navmenu_scripts() {
		$suffix = UM()->admin()->enqueue()::get_suffix();

		wp_register_script( 'um_verified_admin_nav_menu', um_verified_users_url . 'assets/js/admin/nav-menu' . $suffix . '.js', array(), um_verified_users_version, true );
		wp_enqueue_script( 'um_verified_admin_nav_menu' );
	}
}
