<?php
namespace um_ext\um_user_tags\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Class User_Tags_Taxonomies
 *
 * @package um_ext\um_user_tags\core
 */
class User_Tags_Taxonomies {

	/**
	 * User_Tags_Taxonomies constructor.
	 */
	public function __construct() {
		add_action( 'init', array( &$this, 'setup_taxonomy' ), 2 );
		add_filter( 'um_user_tag_row_actions', array( &$this, 'row_actions' ), 10, 2 );
		add_filter( 'taxonomy_parent_dropdown_args', array( &$this, 'exclude_parent' ), 10, 3 );
	}


	/**
	 * @param $dropdown_args
	 * @param $taxonomy
	 * @param $mode
	 *
	 * @return mixed
	 */
	public function exclude_parent( $dropdown_args, $taxonomy, $mode ) {
		if ( 'um_user_tag' === $taxonomy ) {
			$parent_terms = get_terms(
				array(
					'taxonomy'   => $taxonomy,
					'parent'     => 0,
					'hide_empty' => false,
					'fields'     => 'ids',
				)
			);

			// phpcs:disable WordPress.Security.NonceVerification
			if ( 'edit' === $mode && isset( $_GET['tag_ID'] ) ) {
				if ( in_array( absint( $_GET['tag_ID'] ), $parent_terms, true ) ) {
					unset( $parent_terms[ array_search( absint( $_GET['tag_ID'] ), $parent_terms, true ) ] );
				}
			}
			// phpcs:enable WordPress.Security.NonceVerification

			$dropdown_args['include'] = $parent_terms;
		}

		return $dropdown_args;
	}


	/**
	 * @param $actions
	 * @param $tag
	 *
	 * @return mixed
	 */
	public function row_actions( $actions, $tag ) {
		unset( $actions['view'] );
		return $actions;
	}


	/**
	 * Setup taxonomy
	 */
	public function setup_taxonomy() {

		$labels = array(
			'name'                       => __( 'User Tags', 'um-user-tags' ),
			'singular_name'              => __( 'User Tag', 'um-user-tags' ),
			'search_items'               => __( 'Search User Tags', 'um-user-tags' ),
			'popular_items'              => __( 'Popular User Tags', 'um-user-tags' ),
			'all_items'                  => __( 'All User Tags', 'um-user-tags' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => __( 'Edit User Tag', 'um-user-tags' ),
			'update_item'                => __( 'Update User Tag', 'um-user-tags' ),
			'add_new_item'               => __( 'Add New User Tag', 'um-user-tags' ),
			'new_item_name'              => __( 'New User Tag Name', 'um-user-tags' ),
			'separate_items_with_commas' => __( 'Separate user tags with commas', 'um-user-tags' ),
			'add_or_remove_items'        => __( 'Add or remove user tags', 'um-user-tags' ),
			'choose_from_most_used'      => __( 'Choose from the most used user tags', 'um-user-tags' ),
			'not_found'                  => __( 'No user tags found.', 'um-user-tags' ),
			'menu_name'                  => __( 'User Tags', 'um-user-tags' ),
		);

		$rewrite = false;
		if ( UM()->options()->get( 'members_page' ) ) {
			if ( ! UM()->external_integrations()->is_wpml_active() ) {
				$members_page = get_post( UM()->config()->permalinks['members'] );
			} else {
				if ( function_exists( 'icl_get_current_language' ) && icl_get_current_language() != icl_get_default_language() ) {
					$lang_post_id = icl_object_id( UM()->config()->permalinks['members'], 'page', true, icl_get_current_language() );
					$members_page = get_post( $lang_post_id );
				}
			}

			if ( ! empty( $members_page ) ) {
				$url  = get_home_url( get_current_blog_id() );
				$base = str_replace( trailingslashit( $url ), '', get_permalink( $members_page ) );

				$rewrite = array(
					'slug'       => _x( $base . UM()->options()->get( 'user_tags_slug' ), 'slug', 'um-user-tags' ),
					'with_front' => false,
				);
			}
		}

		$args = array(
			'labels'                => $labels,
			'public'                => false,
			'publicly_queryable'    => true,
			'query_var'             => false,
			'rewrite'               => $rewrite,
			'hierarchical'          => true,
			'show_ui'               => true,
			'show_in_menu'          => false,
			'update_count_callback' => 'user_tag_update_count_callback'
		);

		register_taxonomy( 'um_user_tag', 'user', $args );

		$is_first_setup = $this->is_first_setup();
		if ( $is_first_setup ) {

			$terms = get_terms( 'um_user_tag', array( 'fields' => 'ids', 'hide_empty' => false ) );
			if ( $terms ) {
				foreach ( $terms as $value ) {
					wp_delete_term( $value, 'um_user_tag' );
				}
			}
			$term1 = wp_insert_term( 'Interests', 'um_user_tag', array( 'slug' => 'interests' ) );
			$term2 = wp_insert_term( 'Skills', 'um_user_tag', array( 'slug' => 'skills' ) );

			if ( ! is_wp_error( $term1 ) ) {
				wp_insert_term( 'Racing', 'um_user_tag', array( 'slug' => 'racing', 'parent' => $term1['term_id'] ) );
				wp_insert_term( 'Painting', 'um_user_tag', array( 'slug' => 'painting', 'parent' => $term1['term_id'] ) );
				wp_insert_term( 'Video gaming', 'um_user_tag', array( 'slug' => 'video-gaming', 'parent' => $term1['term_id'] ) );
				wp_insert_term( 'Blogging', 'um_user_tag', array( 'slug' => 'blogging', 'parent' => $term1['term_id'] ) );
				wp_insert_term( 'Reading', 'um_user_tag', array( 'slug' => 'reading', 'parent' => $term1['term_id'] ) );
			}

			if ( ! is_wp_error( $term2 ) ) {
				wp_insert_term( 'PHP', 'um_user_tag', array( 'slug' => 'php', 'parent' => $term2['term_id'] ) );
				wp_insert_term( 'HTML5', 'um_user_tag', array( 'slug' => 'html5', 'parent' => $term2['term_id'] ) );
				wp_insert_term( 'CSS', 'um_user_tag', array( 'slug' => 'css', 'parent' => $term2['term_id'] ) );
				wp_insert_term( 'jQuery', 'um_user_tag', array( 'slug' => 'jquery', 'parent' => $term2['term_id'] ) );
				wp_insert_term( 'MySQL', 'um_user_tag', array( 'slug' => 'mysql', 'parent' => $term2['term_id'] ) );
			}

			// declare plugin as installed
			update_option( 'um_user_tags_defaults', 1 );
		}
	}


	/**
	 * The first time to install this add-on?
	 *
	 * @return bool
	 */
	public function is_first_setup() {
		if ( ! get_option( 'um_user_tags_defaults' ) ) {
			return true;
		}
		return false;
	}

}
