<?php
namespace um_ext\um_user_tags\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Class User_Tags_Enqueue
 * @package um_ext\um_user_tags\core
 */
class User_Tags_Enqueue {


	/**
	 * User_Tags_Enqueue constructor.
	 */
	public function __construct() {
		$priority = apply_filters( 'um_user_tags_enqueue_priority', 0 );

		add_action( 'wp_enqueue_scripts', array( &$this, 'front_enqueue_scripts' ), $priority );
		add_action( 'admin_enqueue_scripts', array( &$this, 'enqueue_scripts' ), $priority );
		add_action( 'um_after_form', array( &$this, 'enable_tag_adding' ), 100 );

		add_action( 'admin_enqueue_scripts', array( &$this, 'admin_enqueue_scripts' ), 100 );
		add_action( 'enqueue_block_assets', array( &$this, 'block_editor' ), 11 );
	}


	/**
	 * Enqueue scripts
	 */
	public function front_enqueue_scripts() {
		$suffix = UM()->frontend()->enqueue()::get_suffix();
		wp_register_script( 'um-user-tags', um_user_tags_url . 'assets/js/um-user-tags' . $suffix . '.js', array( 'jquery', UM()->frontend()->enqueue()::$select2_handle, 'um_tipsy', 'um_conditional', 'wp-hooks' ), um_user_tags_version, true );
		wp_register_script( 'um-user-tags-members', um_user_tags_url . 'assets/js/um-user-tags-members' . $suffix . '.js', array( 'jquery', 'wp-hooks', 'um_members' ), um_user_tags_version, true );
		wp_register_style( 'um-user-tags', um_user_tags_url . 'assets/css/um-user-tags' . $suffix . '.css', array( 'select2', 'um_tipsy' ), um_user_tags_version );
	}

	public function enqueue_scripts() {
		$suffix = UM()->admin()->enqueue()::get_suffix();
		wp_register_script( 'um-user-tags', um_user_tags_url . 'assets/js/um-user-tags' . $suffix . '.js', array( 'jquery', UM()->admin()->enqueue()::$select2_handle, 'um_tipsy', 'um_conditional', 'wp-hooks' ), um_user_tags_version, true );
		wp_register_script( 'um-user-tags-members', um_user_tags_url . 'assets/js/um-user-tags-members' . $suffix . '.js', array( 'jquery', 'wp-hooks', 'um_members' ), um_user_tags_version, true );
		wp_register_style( 'um-user-tags', um_user_tags_url . 'assets/css/um-user-tags' . $suffix . '.css', array( 'select2', 'um_tipsy' ), um_user_tags_version );
	}

	public function admin_enqueue_scripts( $hook_suffix ) {
		if ( 'edit-tags.php' !== $hook_suffix ) {
			return;
		}
		if ( ! isset( $_GET['taxonomy'] ) || 'um_user_tag' !== $_GET['taxonomy'] ) {
			return;
		}
		$suffix = UM()->admin()->enqueue()::get_suffix();
		wp_register_style( 'um-user-tags-admin', um_user_tags_url . 'assets/css/um-user-tags-admin' . $suffix . '.css', array(), um_user_tags_version );
		wp_enqueue_style( 'um-user-tags-admin' );
	}

	/**
	 * Change select2 if user can add tags
	 */
	public function enable_tag_adding() {
		wp_enqueue_script( 'um-user-tags' );
		wp_enqueue_style( 'um-user-tags' );

		if ( um_user( 'user_tags_can_add' ) ) {

			ob_start(); ?>

			jQuery( document ).ready( function() {
				jQuery( '.um-field-type_user_tags select' ).select2( 'destroy' );

				jQuery( '.um-field-user_tags select' ).each( function() {
					var $this = jQuery(this);
					$this.select2({
						tags: true,
						allowClear: true,
						minimumResultsForSearch: 10,
						maximumSelectionSize: parseInt( $this.attr('data-maxsize') )
					});
				});
			});

			<?php
			$inline_script = ob_get_clean();

			wp_add_inline_script( 'um-user-tags', $inline_script );
		}
	}

	public function block_editor() {
		$suffix = UM()->frontend()->enqueue()::get_suffix();
		wp_register_style( 'um-user-tags', um_user_tags_url . 'assets/css/um-user-tags' . $suffix . '.css', array( 'select2', 'um_tipsy' ), um_user_tags_version );
		wp_enqueue_style( 'um-user-tags' );
	}
}
