<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Add possible user tags
 *
 * @param int|array $param1
 * @param int|array $param2
 */
function um_user_tags_display( $param1, $param2 ) {
	if ( true === UM()->fields()->editing ) {
		return;
	}

	if ( ! um_user( 'show_user_tags' ) ) {
		return;
	}

	$metakey = um_user( 'user_tags_metakey' );
	if ( ! $metakey ) {
		return;
	}

	if ( UM()->is_new_ui() ) {
		$user_id = $param2;
	} else {
		$user_id = $param1;
	}

	echo wp_kses( UM()->User_Tags()->get_tags( $user_id, $metakey ), UM()->get_allowed_html( 'templates' ) );
}
add_action( 'um_after_header_meta', 'um_user_tags_display', 30, 2 );


/**
 * Add possible user tags
 *
 * @param $array
 * @param $key
 * @param $args
 */
function um_add_error_on_form_submit_validation( $array, $key, $args ) {
	if ( isset( $array['type'] ) && $array['type'] == 'user_tags' && isset( $array['required'] ) && $array['required'] == 1 && ! isset( $args[ $key ] ) ) {
		// translators: %s is a field title
		UM()->form()->add_error( $key, sprintf( __( '%s is required.', 'um-user-tags' ), $array['title'] ) );
	}
}
add_action( 'um_add_error_on_form_submit_validation', 'um_add_error_on_form_submit_validation', 10, 3 );

/**
 * Creates user_meta "_um_verified" for sorted
 *
 * @param int   $user_id
 * @param array $submitted
 * @param array $form_data
 */
function um_user_tags_sync_terms_count( $user_id, $submitted, $form_data = null ) {
	// @todo remove this condition after UMv2.6.8 release.
	if ( empty( $form_data ) ) {
		$form_data = UM()->form()->form_data;
	}

	global $wpdb;

	$filters = get_option( 'um_user_tags_filters', array() );
	$fields  = maybe_unserialize( $form_data['custom_fields'] );

	$user_tags_metakeys = array();
	foreach ( array_keys( $submitted ) as $maybe_metakey ) {
		if ( array_key_exists( $maybe_metakey, $filters ) && array_key_exists( $maybe_metakey, $fields ) &&
			array_key_exists( 'type', $fields[ $maybe_metakey ] ) && 'user_tags' === $fields[ $maybe_metakey ]['type'] ) {
			$user_tags_metakeys[ $maybe_metakey ] = $filters[ $maybe_metakey ];
		}
	}

	if ( empty( $user_tags_metakeys ) ) {
		return;
	}

	$after_tag_ids = array();
	foreach ( $user_tags_metakeys as $metakey => $term_id ) {
		if ( ! empty( $submitted[ $metakey ] ) ) {
			$after_tag_ids = array_merge( $after_tag_ids, $submitted[ $metakey ] );
		}
	}

	$after_tag_ids = array_unique( $after_tag_ids );
	foreach ( $after_tag_ids as $value ) {
		$term = get_term_by( 'id', $value, 'um_user_tag' );

		if ( empty( $term ) ) {
			continue;
		}

		$wpdb->update(
			$wpdb->term_taxonomy,
			array( 'count' => $term->count + 1 ),
			array( 'term_id' => $term->term_id )
		);
	}
}
add_action( 'um_before_save_registration_details', 'um_user_tags_sync_terms_count', 10, 3 );

/**
 * Save user tags to profile and update tag count
 *
 * @param array $to_update
 * @param int   $user_id
 * @param array $form_data
 */
function um_user_tags_sync_user( $to_update, $user_id, $form_data ) {
	global $wpdb;

	$filters = get_option( 'um_user_tags_filters', array() );
	$fields  = maybe_unserialize( $form_data['custom_fields'] );

	$user_tags_metakeys = array();
	foreach ( $fields as $metakey => $value ) {
		if ( 'user_tags' === $value['type'] && array_key_exists( $metakey, $filters ) ) {
			$data = UM()->fields()->get_field( $metakey );
			if ( ! um_can_edit_field( $data ) || ! um_can_view_field( $data ) ) {
				continue;
			}

			$user_tags_metakeys[ $metakey ] = $filters[ $metakey ];
		}
	}

	if ( empty( $user_tags_metakeys ) ) {
		return;
	}

	$before_tag_ids = array();
	$after_tag_ids  = array();
	foreach ( $user_tags_metakeys as $metakey => $term_id ) {
		$userdata = get_user_meta( $user_id, $metakey, true );
		$userdata = empty( $userdata ) ? array() : $userdata;
		$userdata = ! is_array( $userdata ) ? array( $userdata ) : $userdata;

		$before_tag_ids = array_merge( $before_tag_ids, $userdata );

		if ( ! empty( $to_update[ $metakey ] ) ) {
			$after_tag_ids = array_merge( $after_tag_ids, $to_update[ $metakey ] );
		} else {
			delete_user_meta( $user_id, $metakey );
		}
	}

	$before_tag_ids = array_unique( $before_tag_ids );
	$after_tag_ids  = array_unique( $after_tag_ids );

	$removed_tags = array_diff( $before_tag_ids, $after_tag_ids );
	$added_tags   = array_diff( $after_tag_ids, $before_tag_ids );

	foreach ( $removed_tags as $value ) {
		$term = get_term_by( 'id', $value, 'um_user_tag' );

		if ( empty( $term ) ) {
			continue;
		}

		$wpdb->update(
			$wpdb->term_taxonomy,
			array( 'count' => $term->count - 1 ),
			array( 'term_id' => $term->term_id )
		);
	}

	foreach ( $added_tags as $value ) {
		$term = get_term_by( 'id', $value, 'um_user_tag' );

		if ( empty( $term ) ) {
			continue;
		}

		$wpdb->update(
			$wpdb->term_taxonomy,
			array( 'count' => $term->count + 1 ),
			array( 'term_id' => $term->term_id )
		);
	}
}
add_action( 'um_user_pre_updating_profile', 'um_user_tags_sync_user', 39, 3 );

/**
 * Update tag count after delete user
 *
 * @param $user_id
 */
function um_tags_on_user_delete( $user_id ) {
	global $wpdb;
	$filters = get_option( 'um_user_tags_filters', array() );
	$user_meta_keys = array_keys( $filters );

	foreach ( $user_meta_keys as $user_meta_key ) {
		$termsIds = get_user_meta( $user_id, $user_meta_key, true );
		if ( ! empty( $termsIds ) ) {
			foreach ( $termsIds as $id ) {
				$term = get_term_by( 'id', $id, 'um_user_tag' );
				$wpdb->update(
					$wpdb->term_taxonomy,
					array( 'count' => $term->count - 1 ),
					array( 'term_id' => $term->term_id )
				);
			}
		}
	}
}
add_action( 'um_delete_user', 'um_tags_on_user_delete', 10, 1 );
