<?php
/**
 * Template for download file
 *
 * @version  1.1.1
 * @var int    $id
 * @var string $image
 * @var string $title
 * @var string $author_name
 * @var string $content
 * @var string $post_date
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="um-note-content" data-id="<?php echo esc_attr( $id ); ?>">
	<?php if ( $image ) { ?>
		<div class="note-image">
			<img style="max-width: 100%;" src="<?php echo esc_attr( $image ); ?>" />
		</div>
	<?php } ?>
	<h1><?php echo esc_html( $title ); ?></h1>

	<span class="um_notes_author_date">
		<?php echo esc_html( $author_name ); ?> &bull; <?php echo esc_html( $post_date ); ?>
	</span>
	<br><br>
	<div>
		<?php echo wp_kses( $content, UM()->get_allowed_html( 'templates' ) ); ?>
	</div>
</div>
