<?php
/**
 * Uninstall UM Social Login
 *
 * @package UM_Social_Login_API
 */

// Exit if accessed directly.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}


if ( ! defined( 'UM_SOCIAL_LOGIN_PATH' ) ) {
	define( 'UM_SOCIAL_LOGIN_PATH', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'UM_SOCIAL_LOGIN_URL' ) ) {
	define( 'UM_SOCIAL_LOGIN_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'UM_SOCIAL_LOGIN_PLUGIN' ) ) {
	define( 'UM_SOCIAL_LOGIN_PLUGIN', plugin_basename( __FILE__ ) );
}

$options = get_option( 'um_options', array() );

if ( ! empty( $options['uninstall_on_delete'] ) ) {
	if ( ! class_exists( 'um_ext\um_social_login\core\Social_Login_Setup' ) ) {
		require_once UM_SOCIAL_LOGIN_PATH . 'includes/core/class-social-login-setup.php';
	}

	$social_login_setup = new um_ext\um_social_login\core\Social_Login_Setup();

	// remove settings.
	foreach ( $social_login_setup->settings_defaults as $k => $v ) {
		unset( $options[ $k ] );
	}

	unset( $options['um_social_login_license_key'] );

	update_option( 'um_options', $options );

	$um_social_logins = get_posts(
		array(
			'post_type'   => 'um_social_login',
			'numberposts' => -1,
		)
	);

	foreach ( $um_social_logins as $um_social_login ) {
		wp_delete_post( $um_social_login->ID, 1 );
	}

	delete_option( 'um_social_login_last_version_upgrade' );
	delete_option( 'um_social_login_version' );
	delete_option( 'um_social_login_form_installed' );
}
