<?php
/**
 * Plugin Name: Ultimate Member - Social Login
 * Plugin URI: http://ultimatemember.com/extensions/social-login
 * Description: Social registration and login for Ultimate Member plugin.
 * Version: 2.5.9
 * Author: Ultimate Member
 * Author URI: http://ultimatemember.com/
 * Text Domain: um-social-login
 * Domain Path: /languages
 * Requires at least: 5.5
 * Requires PHP: 5.6
 * UM version: 2.8.9
 * Requires Plugins: ultimate-member
 *
 * @package UM_Social_Login
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once ABSPATH . 'wp-admin/includes/plugin.php';
$plugin_data = get_plugin_data( __FILE__, true, false );

define( 'UM_SOCIAL_LOGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'UM_SOCIAL_LOGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'UM_SOCIAL_LOGIN_PLUGIN', plugin_basename( __FILE__ ) );
define( 'UM_SOCIAL_LOGIN_EXTENSION', $plugin_data['Name'] );
define( 'UM_SOCIAL_LOGIN_VERSION', $plugin_data['Version'] );
define( 'UM_SOCIAL_LOGIN_TEXTDOMAIN', 'um-social-login' );
define( 'UM_SOCIAL_LOGIN_REQUIRES', '2.8.9' );

/**
 * Add languages
 */
function um_social_login_plugins_loaded() {
	$locale = ( get_locale() !== '' ) ? get_locale() : 'en_US';
	load_textdomain( UM_SOCIAL_LOGIN_TEXTDOMAIN, WP_LANG_DIR . '/plugins/' . UM_SOCIAL_LOGIN_TEXTDOMAIN . '-' . $locale . '.mo' );
	load_plugin_textdomain( UM_SOCIAL_LOGIN_TEXTDOMAIN, false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'um_social_login_plugins_loaded', 0 );

add_action( 'plugins_loaded', 'um_social_login_check_dependencies', -20 );

if ( ! function_exists( 'um_social_login_check_dependencies' ) ) {
	/**
	 * Check dependencies
	 */
	function um_social_login_check_dependencies() {
		if ( ! defined( 'um_path' ) || ! file_exists( um_path . 'includes/class-dependencies.php' ) ) {
			/**
			 * UM is not installed.
			 */
			function um_social_login_dependencies() {
				/* translators: %s is the Social Login extension name. */
				$allowed_html_tags = array(
					'strong' => array(),
					'a'      => array(),
				);
				// translators: %s is the Social Login extension name.
				echo '<div class="error"><p>' . wp_kses( sprintf( __( 'The <strong>%s</strong> extension requires the Ultimate Member plugin to be activated to work properly. You can download it <a href="https://wordpress.org/plugins/ultimate-member">here</a>', 'um-social-login' ), UM_SOCIAL_LOGIN_EXTENSION ), $allowed_html_tags ) . '</p></div>';
			}

			add_action( 'admin_notices', 'um_social_login_dependencies' );
		} else {

			if ( ! function_exists( 'UM' ) ) {
				require_once um_path . 'includes/class-dependencies.php';
				$is_um_active = um\is_um_active();
			} else {
				$is_um_active = UM()->dependencies()->ultimatemember_active_check();
			}

			if ( ! $is_um_active ) {
				/**
				 *  UM is not active
				 */
				function um_social_login_dependencies() {
					// translators: %s is the Social Login extension name.
					echo '<div class="error"><p>' . wp_kses( sprintf( __( 'The <strong>%s</strong> extension requires the Ultimate Member plugin to be activated to work properly. You can download it <a href="https://wordpress.org/plugins/ultimate-member">here</a>', 'um-social-login' ), UM_SOCIAL_LOGIN_EXTENSION ), UM()->get_allowed_html( 'templates' ) ) . '</p></div>';
				}

				add_action( 'admin_notices', 'um_social_login_dependencies' );

			} elseif ( true !== UM()->dependencies()->compare_versions( UM_SOCIAL_LOGIN_REQUIRES, UM_SOCIAL_LOGIN_VERSION, 'social-login', UM_SOCIAL_LOGIN_EXTENSION ) ) {
				/**
				 * UM old version is active
				 */
				function um_social_login_dependencies() {
					echo '<div class="error"><p>' . wp_kses( UM()->dependencies()->compare_versions( UM_SOCIAL_LOGIN_REQUIRES, UM_SOCIAL_LOGIN_VERSION, 'social-login', UM_SOCIAL_LOGIN_EXTENSION ), UM()->get_allowed_html( 'templates' ) ) . '</p></div>';
				}

				add_action( 'admin_notices', 'um_social_login_dependencies' );

				require_once UM_SOCIAL_LOGIN_PATH . 'includes/core/filters/um-social-login-license.php';
			} elseif ( ! UM()->dependencies()->php_version_check( '5.4' ) ) {
				/**
				 * UM old version is active
				 */
				function um_social_login_dependencies() {
					// translators: %s is the Social Login extension name.
					echo '<div class="error"><p>' . wp_kses( sprintf( __( 'The <strong>%s</strong> extension requires <strong>PHP 5.4 or better</strong> installed on your server.', 'um-social-login' ), UM_SOCIAL_LOGIN_EXTENSION ), UM()->get_allowed_html( 'templates' ) ) . '</p></div>';
				}

				add_action( 'admin_notices', 'um_social_login_dependencies' );

			} else {
				require_once UM_SOCIAL_LOGIN_PATH . 'includes/core/um-social-login-init.php';
			}
		}
	}
}


register_activation_hook( UM_SOCIAL_LOGIN_PLUGIN, 'um_social_login_activation_hook' );
/**
 * Activate hook
 */
function um_social_login_activation_hook() {
	// first install.
	$version = get_option( 'UM_SOCIAL_LOGIN_VERSION' );
	if ( ! $version ) {
		update_option( 'um_social_login_last_version_upgrade', UM_SOCIAL_LOGIN_VERSION );
	}

	if ( UM_SOCIAL_LOGIN_VERSION !== $version ) {
		update_option( 'UM_SOCIAL_LOGIN_VERSION', UM_SOCIAL_LOGIN_VERSION );
	}

	// run setup.
	if ( ! class_exists( 'um_ext\um_social_login\core\Social_Login_Setup' ) ) {
		require_once UM_SOCIAL_LOGIN_PATH . 'includes/core/class-social-login-setup.php';
	}

	$social_login_setup = new um_ext\um_social_login\core\Social_Login_Setup();
	$social_login_setup->run_setup();
}
