<?php
/**
 * Template for the UM Social Login.
 * Used for the after registration overlay form.
 *
 * Caller: method show_overlay()
 *
 * @version 2.5.2
 *
 * This template can be overridden by copying it to yourtheme/ultimate-member/um-social-login/pre-loader-form.php
 * @var int $form_id
 *
 * @package Social_Login_Shortcode
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wp;
$current_url = home_url( add_query_arg( array(), $wp->request ) );
?>

<div class="um-social-login-overlay">
	<a href="<?php echo esc_url( $current_url ); ?>" class="um-social-login-cancel">
		<i class="um-icon-ios-close-empty"></i>
	</a>
</div>

<div class="um-social-login-wrap">
	<?php
		echo UM()->shortcodes()->load( array( 'form_id' => esc_attr( $um_sso_form_id ) ) ); //phpcs:ignore
	?>
	<center class="um-sso-loading"><img src="<?php echo esc_url( UM_URL . '/assets/img/loading.gif' ); ?>" /></center>
</div>
