<?php
/**
 * Template for the UM Social Login.
 * Used for the Social Login page.
 *
 * Caller: method Social_Login_Shortcode->load()
 * Shortcode: [ultimatemember_social_login]
 *
 * @version 2.3.15
 *
 * This template can be overridden by copying it to yourtheme/ultimate-member/um-social-login/buttons.php
 * @var int    $id
 * @var array  $o_networks
 * @var string $padding
 * @var string $margin
 * @var string $button_style
 * @var bool   $show_labels
 * @var bool   $show_icons
 *
 * @package Social_Login_Shortcode
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="um um-shortcode-social" id="um-shortcode-social-<?php echo esc_attr( $id ); ?>" style="padding:<?php echo esc_attr( $padding ); ?>;margin:<?php echo esc_attr( $margin ); ?>!important;">
	<?php
	if ( empty( UM()->shortcodes()->form_id ) ) {
		do_action( 'um_before_form', array() );
	}
	?>
	<div class="um-field">

		<div class="um-col-alt">

			<?php
			$i = 0;

			foreach ( $o_networks as $provider => $arr ) {

				if ( ! isset( $arr['icon_position'] ) ) {
					$arr['icon_position'] = 'left';
				}

				$i++;
				$class = 'um-left';
				if ( 0 === $i % 2 ) {
					$class = 'um-right';
				}
				?>

				<div 
				<?php
				if ( 'floated' === $button_style ) {
						echo 'style="display:inline"';
				}
				?>
				class="
				<?php
				if ( 'responsive' === $button_style ) {
					echo esc_attr( $class ) . ' um-half';
				}
				?>
				">
					<a href="<?php echo esc_url( UM()->Social_Login_API()->hybridauth()->get_connect_url( $provider, $id ) ); ?>" title="<?php echo esc_attr( $arr['button'] ); ?>"
						class=" <?php echo empty( $show_labels ) ? 'um-sso-no-label' : ''; ?> um-button um-alt um-button-social um-button-<?php echo esc_attr( $provider ); ?>" data-redirect-url="<?php echo esc_url( UM()->Social_Login_API()->hybridauth()->get_current_url() ); ?>"  onclick="um_social_login_oauth_window( this.href,'authWindow', 'width=600,height=600,scrollbars=yes' );return false;">
					<?php if ( $show_icons && 'left' === $arr['icon_position'] ) { ?>
						<i class="<?php echo esc_attr( $arr['icon'] ); ?>" 
						<?php
						if ( $show_labels ) {
							echo 'style="margin-right: 8px;"';
						}
						?>
						></i>
						<?php
					}

					if ( $show_labels ) {
						?>
						<span><?php echo esc_attr( $arr['button'] ); ?></span>
					<?php } ?>
					<?php if ( $show_icons && 'right' === $arr['icon_position'] ) { ?>
						<i class="<?php echo esc_attr( $arr['icon'] ); ?>" 
						<?php
						if ( $show_labels ) {
							echo 'style="margin-right: 8px;"';
						}
						?>
						></i>
						<?php
					}
					?>
					</a>
				</div>

				<?php if ( 'default' === $button_style ) { ?>
					<div class="um-clear"></div>
					<?php
				}

				if ( 0 === $i % 2 && count( $o_networks ) !== $i && 'responsive' === $button_style ) {
					echo '<div class="um-clear"></div></div><div class="um-col-alt um-col-alt-s">';
				}
			}
			?>

			<div class="um-clear"></div>

		</div>

	</div>

	<style type="text/css">

		div#um-shortcode-social-<?php echo esc_attr( $id ); ?> div.um-field {padding: 0}

		div#um-shortcode-social-<?php echo esc_attr( $id ); ?> a.um-button.um-button-social {
			font-size: <?php echo ( $fontsize ) ? esc_attr( $fontsize ) : '15px'; ?>;
			padding: <?php echo ( ! empty( $button_padding ) ) ? esc_attr( $button_padding ) : '16px 20px'; ?> !important;
		}

		div#um-shortcode-social-<?php echo esc_attr( $id ); ?> a.um-button.um-button-social i {
			font-size: <?php echo ( $iconsize ) ? esc_attr( $iconsize ) : '18px'; ?>;
			width: <?php echo ( $iconsize ) ? esc_attr( $iconsize ) : '18px'; ?>;
			top: auto;
			margin-right: 0;
		}

		<?php if ( 'responsive' === $button_style ) { ?>

			div#um-shortcode-social-<?php echo esc_attr( $id ); ?> div.um-field {margin:0 auto; max-width: <?php echo esc_attr( $container_max_width ); ?>}

			<?php
		}


		if ( 'floated' === $button_style ) {
			?>

			div#um-shortcode-social-<?php echo esc_attr( $id ); ?> a.um-button.um-button-social {
				display: inline-block !important;
				float: none !important;
				margin-right: 5px !important;
				margin-left: 5px !important;
				margin-bottom: 10px !important;
				width: auto;
				<?php if ( ! empty( $button_min_width ) ) { ?>
				min-width: <?php echo esc_attr( $button_min_width ); ?>;
				<?php } ?>
			}

			div#um-shortcode-social-<?php echo esc_attr( $id ); ?> div.um-field {text-align: center}

			<?php
		}


		if ( 'default' === $button_style ) {
			?>

			div#um-shortcode-social-<?php echo esc_attr( $id ); ?> a.um-button.um-button-social {
				display: inline-block !important;
				float: none !important;
				margin-bottom: 10px !important;
				width: auto;
				<?php if ( ! empty( $button_min_width ) ) { ?>
				min-width: <?php echo esc_attr( $button_min_width ); ?>;
				<?php } ?>
			}

			div#um-shortcode-social-<?php echo esc_attr( $id ); ?> div.um-field {text-align: center}

			<?php
		}

		foreach ( $o_networks as $provider => $arr ) {
			?>

			div#um-shortcode-social-<?php echo esc_attr( $id ); ?> a.um-button.um-button-<?php echo esc_attr( $provider ); ?> {background-color: <?php echo esc_attr( $arr['bg'] ); ?>!important}
			div#um-shortcode-social-<?php echo esc_attr( $id ); ?> a.um-button.um-button-<?php echo esc_attr( $provider ); ?>:hover {background-color: <?php echo esc_attr( $arr['bg_hover'] ); ?>!important}
			div#um-shortcode-social-<?php echo esc_attr( $id ); ?> a.um-button.um-button-<?php echo esc_attr( $provider ); ?> {color: <?php echo esc_attr( $arr['color'] ); ?>!important}

		<?php } ?>

	</style>

</div>
