<?php
/**
 * Github
 *
 * @package um_ext\um_social_login\core
 */

/**
 * Change API field keys
 *
 * @param array $networks Networks.
 */
function um_sso_github_settings( $networks ) {
	if ( is_admin() ) {
		return $networks;
	}

	foreach ( $networks as $network => $data ) {
		if ( 'github' === $network ) {
			$data['opts']['github_api_id'] = $data['opts']['github_api_key'];
			unset( $data['opts']['github_api_key'] );
			$networks[ $network ] = $data;
			break;
		}
	}

	return $networks;
}
add_filter( 'um_social_login_github__config', 'um_sso_github_settings' );

/**
 * Change API field keys
 *
 * @param array $config Network Config.
 */
function um_sso_github_config( $config ) {

	$config['keys']['id'] = $config['keys']['key'];
	unset( $config['keys']['key'] );

	return $config;
}
add_filter( 'um_social_login_github__config', 'um_sso_github_config' );
