<?php
/**
 * Facebook
 *
 * @package um_ext\um_social_login\core
 */

/**
 * Add access token to the profile photo URL to support Facebook App's development mode.
 *
 * @param object $user_profile User Profile object.
 * @param class  $hybridauth    Hybridauth class.
 * @param string $access_token  Access token.
 */
function um_social_login_get_user_profile__facebook( $user_profile, $hybridauth, $access_token ) {

	if ( ! isset( $access_token['access_token'] ) ) {
		return $user_profile;
	}

	$user_profile->photoURL .= '&access_token=' . $access_token['access_token']; //phpcs:ignore

	return $user_profile;
}
add_filter( 'um_social_login_get_user_profile__facebook', 'um_social_login_get_user_profile__facebook', 10, 3 );

