<?php
/**
 * Settings Hooks
 *
 * @package UM_Social_Login_API
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Extend myCRED settings
 *
 * @param array $settings Settings data.
 *
 * @return array
 */
function um_social_login_mycred_settings_award( $settings ) {
	$networks = UM()->Social_Login_API()->networks;
	foreach ( $networks as $id => $arr ) {
		/* translators: %s is a social network name */
		$settings[ $id ] = sprintf( __( 'user connects with %s', 'um-social-login' ), $arr['name'] );
	}
	return $settings;
}
add_filter( 'um_mycred_extend_award_settings', 'um_social_login_mycred_settings_award', 10, 1 );

/**
 * Extend myCRED settings
 *
 * @param array $settings Settings data.
 *
 * @return mixed
 */
function um_social_login_mycred_settings_deduct( $settings ) {
	$networks = UM()->Social_Login_API()->networks;
	foreach ( $networks as $id => $arr ) {
		/* translators: %s is a social network name */
		$settings[ $id ] = sprintf( __( 'user disconnects from %s', 'um-social-login' ), $arr['name'] );
	}
	return $settings;
}
add_filter( 'um_mycred_extend_deduct_settings', 'um_social_login_mycred_settings_deduct', 10, 1 );

/**
 * Extend settings
 *
 * @param array $settings Settings data.
 *
 * @return mixed
 */
function um_social_login_settings( $settings ) {
	UM()->Social_Login_API()->init_networks();
	$networks = UM()->Social_Login_API()->networks;

	$error_log_last_update = get_option( 'um_sso_error_log_timestamp' );
	if ( $error_log_last_update ) {
		$error_log_timestamp = '<small>(Last updated: ' . human_time_diff( $error_log_last_update, gmdate( 'U' ) ) . ' ago)</small>';
	} else {
		$error_log_timestamp = '<small>(Last updated: - No captured activity yet - )</small>';
	}

	$settings['extensions']['sections']['social-login'] = array(
		'title'  => __( 'Social Login', 'um-social-login' ),
		'fields' => array(
			array(
				'id'      => 'account_tab_social',
				'type'    => 'checkbox',
				'label'   => __( 'Social Account Tab', 'um-social-login' ),
				'tooltip' => __( 'Enable/disable the Social account tab in account page', 'um-social-login' ),
			),
			array(
				'id'      => 'register_show_social',
				'type'    => 'checkbox',
				'label'   => __( 'Show social connect on registration forms', 'um-social-login' ),
				'tooltip' => __( 'Show/hide social connect on all registration forms by default', 'um-social-login' ),
			),
			array(
				'id'      => 'login_show_social',
				'type'    => 'checkbox',
				'label'   => __( 'Show social connect on login forms', 'um-social-login' ),
				'tooltip' => __( 'Show/hide social connect on all login forms by default', 'um-social-login' ),
			),
			array(
				'id'      => 'enable_debug_logs',
				'type'    => 'checkbox',
				'label'   => __( 'Enable Debug Logging', 'um-social-login' ),
				'tooltip' => __( 'This allows developers to see any error when testing the social authorization.', 'um-social-login' ),
			),
			array(
				'id'          => 'debug_logs',
				'type'        => 'info_text',
				'value'       => 'Click to <a href="' . esc_attr( content_url() ) . '/um-sso-logs-' . md5( site_url() ) . '.txt" target="_blank">View the Error logs - File: um-sso-logs-' . md5( site_url() ) . '.txt</a><br/>' . $error_log_timestamp,
				'conditional' => array( 'enable_debug_logs', '=', '1' ),
			),
			array(
				'id'      => 'enable_current_window_authentication',
				'type'    => 'checkbox',
				'label'   => __( 'Authenticate on the current window', 'um-social-login' ),
				'tooltip' => __( 'By default, when users click on the Social Buttons, a child window opens to authenticate users on the Social Provider\'s site, and then returns them to the parent window. If this option is enabled, users will be redirected to the Social Provider in the current window instead.', 'um-social-login' ),
			),
		),
	);

	$i = 0;
	foreach ( $networks as $id => $arr ) {
		$i++;
		$sort[ $i ] = $id;
	}

	foreach ( $networks as $network_id => $array ) {
		$options = array();

		$options[] = array(
			'id'    => 'enable_' . $network_id,
			'type'  => 'checkbox',
			/* translators: %s is a social network name */
			'label' => sprintf( __( '%s Social Connect', 'um-social-login' ), $array['name'] ),
		);

		if ( isset( $array['opts'] ) ) {
			foreach ( $array['opts'] as $opt_id => $title ) {
				$options[] = array(
					'id'          => $opt_id,
					'type'        => 'text',
					'label'       => $title,
					'conditional' => array( "enable_$network_id", '=', '1' ),
				);
			}
		}

		$settings['extensions']['sections']['social-login']['fields'] = array_merge( $settings['extensions']['sections']['social-login']['fields'], $options );
	}

	return $settings;
}
add_filter( 'um_settings_structure', 'um_social_login_settings', 10, 1 );

/**
 * Scan templates from extension
 *
 * @param array $scan_files Template Scanned files.
 *
 * @return array
 */
function um_social_login_extend_scan_files( $scan_files ) {
	$extension_files['um-social-login'] = UM()->admin_settings()->scan_template_files( UM_SOCIAL_LOGIN_PATH . '/templates/' );
	$scan_files                         = array_merge( $scan_files, $extension_files );

	return $scan_files;
}
add_filter( 'um_override_templates_scan_files', 'um_social_login_extend_scan_files', 10, 1 );


/**
 * Get template paths
 *
 * @param array  $located Located templates.
 * @param string $file File name.
 *
 * @return array
 */
function um_social_login_get_path_template( $located, $file ) {
	if ( file_exists( get_stylesheet_directory() . '/ultimate-member/um-social-login/' . $file ) ) {
		$located = array(
			'theme' => get_stylesheet_directory() . '/ultimate-member/um-social-login/' . $file,
			'core'  => UM_SOCIAL_LOGIN_PATH . 'templates/' . $file,
		);
	}

	return $located;
}
add_filter( 'um_override_templates_get_template_path__um-social-login', 'um_social_login_get_path_template', 10, 2 );
