<?php
/**
 * Social Provider Hooks
 *
 * @package UM_Social_Login_API
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Social Networks settings
 *
 * @param  array $networks Array of Social Networks.
 * @return array $networks Array of Social Networks.
 */
function um_social_login_networks( $networks ) {

	$networks['facebook'] = array(
		'name'                  => __( 'Facebook', 'um-social-login' ),
		'button'                => __( 'Connect with Facebook', 'um-social-login' ),
		'color'                 => '#fff',
		'bg'                    => '#4267B2',
		'bg_hover'              => '#365899',
		'icon'                  => 'um-sso bi bi-facebook',
		'icon_position'         => 'left',
		'opts'                  => array(
			'facebook_app_id'     => __( 'App ID', 'um-social-login' ),
			'facebook_app_secret' => __( 'App Secret', 'um-social-login' ),
		),
		'sync'                  => array(
			'handle'    => 'facebook_handle',
			'link'      => 'facebook_link',
			'photo_url' => 'http://graph.facebook.com/{id}/picture?type=square',
		),
		'hybridauth_key'        => 'Facebook',
		'sync_v2'               =>
		array(
			'identifier',
			'displayName',
			'firstName',
			'lastName',
			'profileURL',
			'webSiteURL',
			'gender',
			'language',
			'description',
			'email',
			'region',
			'photoURL',
			'emailVerified',
			'city',
			'country',
			'birthYear',
			'birthMonth',
			'birthDay',
		),
		'has_multiple_callback' => true,
	);

	$networks['twitter'] = array(
		'name'                  => __( 'X', 'um-social-login' ),
		'button'                => __( 'Sign in with', 'um-social-login' ),
		'color'                 => '#fff',
		'bg'                    => '#000000',
		'bg_hover'              => '#242526',
		'icon'                  => 'um-sso bi bi-twitter-x',
		'icon_position'         => 'right',
		'opts'                  =>
		array(
			'twitter_consumer_key'    => __( 'Consumer Key', 'um-social-login' ),
			'twitter_consumer_secret' => __( 'Consumer Secret', 'um-social-login' ),
		),
		'sync'                  =>
		array(
			'handle'        => 'twitter_handle',
			'link'          => 'twitter_link',
			'photo_url_dyn' => 'twitter_photo_url_dyn',
		),
		'hybridauth_key'        => 'Twitter',
		'sync_v2'               =>
		array(
			'identifier',
			'displayName',
			'description',
			'firstName',
			'email',
			'emailVerified',
			'webSiteURL',
			'region',
			'profileURL',
			'photoURL',
			'data',
		),
		'has_multiple_callback' => true,
	);

	$networks['google'] = array(
		'name'                  => __( 'Google', 'um-social-login' ),
		'button'                => __( 'Sign in with Google', 'um-social-login' ),
		'color'                 => '#000',
		'bg'                    => '#fff',
		'bg_hover'              => '#e4e4e4',
		'icon'                  => 'um-sso bi bi-google',
		'icon_position'         => 'left',
		'opts'                  =>
		array(
			'google_client_id'     => __( 'Client ID', 'um-social-login' ),
			'google_client_secret' => __( 'Client secret', 'um-social-login' ),
		),
		'sync'                  =>
		array(
			'handle'        => 'google_handle',
			'link'          => 'google_link',
			'photo_url_dyn' => 'google_photo_url_dyn',
		),
		'hybridauth_key'        => 'Google',
		'sync_v2'               =>
		array(
			'identifier',
			'firstName',
			'lastName',
			'displayName',
			'photoURL',
			'profileURL',
			'gender',
			'language',
			'email',
			'emailVerified',
		),
		'has_multiple_callback' => true,
	);

	$networks['linkedin'] = array(
		'name'                  => __( 'LinkedIn', 'um-social-login' ),
		'button'                => __( 'Sign in with LinkedIn', 'um-social-login' ),
		'color'                 => '#fff',
		'bg'                    => '#0976b4',
		'bg_hover'              => '#07659B',
		'icon'                  => 'um-sso bi bi-linkedin',
		'icon_position'         => 'left',
		'opts'                  =>
		array(
			'linkedin_api_key'    => __( 'API Key', 'um-social-login' ),
			'linkedin_api_secret' => __( 'API Secret', 'um-social-login' ),
		),
		'sync'                  =>
		array(
			'handle'        => 'linkedin_handle',
			'link'          => 'linkedin_link',
			'photo_url_dyn' => 'linkedin_photo_url_dyn',
		),
		'hybridauth_key'        => 'LinkedInOpenID',
		'sync_v2'               =>
		array(
			'firstName',
			'lastName',
			'identifier',
			'photoURL',
			'email',
			'emailVerified',
			'displayName',
		),
		'has_multiple_callback' => true,
	);

	$networks['twitchtv'] = array(
		'name'                  => __( 'TwitchTV', 'um-social-login' ),
		'button'                => __( 'Connect with Twitch', 'um-social-login' ),
		'color'                 => '#fff',
		'bg'                    => '#9146FF',
		'bg_hover'              => '#772CE8',
		'icon'                  => 'um-sso bi bi-twitch',
		'icon_position'         => 'left',
		'opts'                  => array(
			'twitchtv_client_id'     => __( 'Client ID', 'um-social-login' ),
			'twitchtv_client_secret' => __( 'Client secret', 'um-social-login' ),
		),
		'sync'                  => array(
			'handle' => 'twitchtv_handle',
			'link'   => 'twitchtv_link',
		),
		'sync_v2'               => array(
			'displayName',
			'firstName',
			'photoURL',
			'profileURL',
			'country',
		),
		'has_multiple_callback' => true,
		'hybridauth_key'        => 'TwitchTV',
	);

	$networks['discord'] = array(
		'name'                  => __( 'Discord', 'um-social-login' ),
		'button'                => __( 'Connect with Discord', 'um-social-login' ),
		'color'                 => '#fff',
		'bg'                    => '#5865F2',
		'bg_hover'              => '#404EED',
		'icon'                  => 'um-sso bi bi-discord',
		'icon_position'         => 'left',
		'opts'                  => array(
			'discord_client_id'     => __( 'Client ID', 'um-social-login' ),
			'discord_client_secret' => __( 'Client Secret', 'um-social-login' ),
		),
		'sync'                  => array(
			'handle' => 'discord_handle',
			'link'   => 'discord_link',
		),
		'sync_v2'               => array(
			'displayName',
			'firstName',
			'photoURL',
			'profileURL',
			'country',
		),
		'has_multiple_callback' => false,
		'hybridauth_key'        => 'Discord',
	);

	$networks['github'] = array(
		'name'                => __( 'Github', 'um-social-login' ),
		'button'              => __( 'Sign in with Github', 'um-social-login' ),
		'color'               => '#ffffff',
		'bg'                  => '#444444',
		'bg_hover'            => '#000000',
		'icon'                => 'um-sso bi bi-github',
		'icon_position'       => 'left',
		'opts'                =>
		array(
			'github_api_key'    => __( 'Client ID', 'um-social-login' ),
			'github_api_secret' => __( 'Client Secret', 'um-social-login' ),
		),
		'sync'                =>
		array(
			'handle'        => 'github_handle',
			'link'          => 'github_link',
			'photo_url_dyn' => 'github_photo_url_dyn',
		),
		'hybridauth_key'      => 'GitHub',
		'sync_v2'             =>
		array(
			'identifier',
			'displayName',
			'description',
			'photoURL',
			'profileURL',
			'email',
			'webSiteURL',
			'region',
			'email',
		),
		'has_single_callback' => true,
	);

	$networks['wordpress'] = array(
		'name'                  => __( 'Wordpress', 'um-social-login' ),
		'button'                => __( 'Sign in with Wordpress', 'um-social-login' ),
		'color'                 => '#ffffff',
		'bg'                    => '#0085ba',
		'bg_hover'              => '#0085ba',
		'icon'                  => 'um-sso bi bi-wordpress',
		'icon_position'         => 'left',
		'opts'                  =>
		array(
			'wordpress_api_id'     => __( 'Client ID', 'um-social-login' ),
			'wordpress_api_secret' => __( 'Client Secret', 'um-social-login' ),
		),
		'sync'                  =>
		array(
			'handle'        => 'wordpress_handle',
			'link'          => 'wordpress_link',
			'photo_url_dyn' => 'wordpress_photo_url_dyn',
		),
		'hybridauth_key'        => 'WordPress',
		'sync_v2'               =>
		array(
			'identifier',
			'displayName',
			'description',
			'photoURL',
			'profileURL',
			'email',
			'webSiteURL',
			'region',
			'email',
		),
		'has_multiple_callback' => true,
	);

	return $networks;
}
add_filter( 'um_social_login_networks', 'um_social_login_networks' );
