<?php
/**
 * License settings Hooks
 *
 * @package UM_Social_Login_API
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Extend license settings.
 *
 * @param array $settings Settings data.
 *
 * @return array
 */
function um_social_login_license_settings( $settings ) {
	$settings['licenses']['fields'][] = array(
		'id'        => 'um_social_login_license_key',
		'label'     => __( 'Social Login License Key', 'um-social-login' ),
		'item_name' => 'Social Login',
		'author'    => 'Ultimate Member',
		'version'   => UM_SOCIAL_LOGIN_VERSION,
	);

	return $settings;
}
add_filter( 'um_settings_structure', 'um_social_login_license_settings' );
