<?php
/**
 * Users class handler
 *
 * @package um_ext\um_social_login\core
 */

namespace um_ext\um_social_login\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Social_Login_Users
 *
 * @package um_ext\um_social_login\core
 */
class Social_Login_Users {

	/**
	 * Networks
	 *
	 * @var $networks
	 */
	public $networks;

	/**
	 * User ID
	 *
	 * @var $user_id
	 */
	public $user_id = null;

	/**
	 * Data
	 *
	 * @var $data
	 */
	public $data = array();

	/**
	 * Init
	 *
	 * @param integer $user_id User ID.
	 */
	public function __construct( $user_id = null ) {

		if ( $user_id ) {
			$this->user_id = $user_id;
			if ( ! isset( $this->data[ $user_id ] ) ) {
				$this->data[ $user_id ] = get_user_meta( $user_id );
			}
		}
	}

	/**
	 * Get Display Name
	 *
	 * @param  string $provider Provider slug.
	 *
	 * @return string $value Value.
	 */
	public function get_display_name( $provider = '' ) {
		$value = $this->get_value( "{$provider}_handle" );
		if ( $value ) {
			return $value;
		}
		return '';
	}

	/**
	 * Get Profile Photo
	 *
	 * @param  string $provider Provider slug.
	 *
	 * @return string $value Value.
	 */
	public function get_profile_photo( $provider = '' ) {
		$value = $this->get_value( "{$provider}_photo_url" );
		if ( $value ) {

			if ( is_ssl() ) {
				$value = str_replace( 'http://', 'https://', $value );
			}

			return $value;
		}

		return '';
	}

	/**
	 * Get Profile Url
	 *
	 * @param  string $provider Provider slug.
	 *
	 * @return string $value Value.
	 */
	public function get_profile_url( $provider = '' ) {

		$value = $this->get_value( "{$provider}_link" );
		if ( $value ) {
			return $value;
		}
		return '';
	}

	/**
	 * Get Profile Date Linked
	 *
	 * @param  string $provider Provider slug.
	 *
	 * @return string $value Value.
	 */
	public function get_date_linked( $provider = '' ) {

		$value = $this->get_value( "_um_sso_{$provider}_date_connected" );
		if ( $value ) {
			return $value;
		}
		return '';
	}

	/**
	 * Get Raw Data
	 *
	 * @param string $provider Provider slug.
	 *
	 * @return array
	 */
	public function get_raw( $provider = '' ) {
		$user_id = $this->user_id;

		$value = $this->get_value( "{$provider}_raw" );
		if ( $value ) {
			$this->data[ $user_id ][ "{$provider}_raw" ] = maybe_unserialize( $value );
			return $this->data[ $user_id ][ "{$provider}_raw" ];
		}

		return '';
	}

	/**
	 * Get Value
	 *
	 * @param string $key  Field Key.
	 * @return string
	 */
	public function get_value( $key = '' ) {

		if ( isset( $this->data[ $this->user_id ][ $key ] ) ) {

			if ( is_array( $this->data[ $this->user_id ][ $key ] ) ) {
				return current( $this->data[ $this->user_id ][ $key ] );
			}

			return $this->data[ $this->user_id ][ $key ];
		}

		return '';
	}

	/**
	 * Check if user has linked avatar
	 *
	 * @param string $provider  Provider ID.
	 *
	 * @return boolean
	 */
	public function has_avatar_linked( $provider ) {

		$user_id = $this->user_id;

		$has_sso_avatar_linked = get_user_meta( $user_id, '_um_social_login_avatar_provider', true );

		if ( empty( $has_sso_avatar_linked ) ) {
			return false;
		}

		return true;
	}

	/**
	 * Jsdump browser console for debugging purposes
	 *
	 * @param array $args array to convert.
	 */
	public function jsdump( $args ) {
		echo '<script>console.log(' . esc_js( wp_json_encode( $args ) ) . ');</script>';
	}
}
