<?php
/**
 * Shortcode Handler
 *
 * @package um_ext\um_social_login\core
 */

namespace um_ext\um_social_login\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Social_Login_Shortcode
 */
class Social_Login_Shortcode {

	/**
	 * Social_Login_Shortcode constructor.
	 */
	public function __construct() {
		add_shortcode( 'ultimatemember_social_login', array( &$this, 'ultimatemember_social_login' ) );
		add_filter( 'um_registration_user_role', array( &$this, 'change_registration_role' ), 10, 2 );
	}

	/**
	 * Social Login Shortcode
	 *
	 * @param array $args attributes.
	 * @return string
	 */
	public function ultimatemember_social_login( $args = array() ) {
		wp_enqueue_script( 'um-social-login' );
		wp_enqueue_style( 'um-social-login' );

		$sso_session = UM()->Social_Login_API()->hybridauth()->session();
		if ( empty( $sso_session ) ) {
			return '';
		}

		$key = wp_generate_password( 5, false );

		$sso_session->set( '_um_shortcode_id', $key );
		$sso_session->set( '_um_social_login_key_' . $key, $args['id'] );

		$sso_session->deleteMatch( '_um_social_login_key_', $args['id'] );

		$redirect_url = UM()->permalinks()->get_current_url();
		$redirect_url = remove_query_arg( array( 'code', 'state' ), $redirect_url );

		$sso_session->set( 'um_social_login_redirect', $redirect_url );
		$sso_session->set( 'um_social_login_rememberme', get_post_meta( $args['id'], '_um_keep_signed_in', true ) );

		UM()->Social_Login_API()->shortcode_id = $key;

		return $this->load( $args );
	}

	/**
	 * Get shortcode post meta
	 *
	 * @param integer $id post ID.
	 *
	 * @return array
	 */
	public function get_meta( $id ) {
		$array = array();

		$meta = get_post_custom( $id );
		if ( $meta && is_array( $meta ) ) {
			foreach ( $meta as $k => $v ) {
				$k = str_replace( '_um_', '', $k );

				$array[ $k ] = $v[0];
			}
		}

		return $array;
	}

	/**
	 * Load a module with global function
	 *
	 * @param array $atts Attributes.
	 * @return string
	 */
	public function load( $atts ) {
		$networks     = apply_filters( 'um_social_login_networks_output', UM()->Social_Login_API()->available_networks() );
		$arr_settings = $this->get_meta( $atts['id'] );
		$arr_settings = array_merge( $arr_settings, $atts );

		foreach ( $networks as $provider => $arr ) {
			if ( empty( $arr_settings[ 'enable_' . $provider ][0] ) ) {
				unset( $networks[ $provider ] );
			}
		}

		if ( ! $networks ) {
			return '';
		}

		$pairs = array(
			'id'                     => '',
			'show_for_members'       => 0,
			'show_icons'             => '',
			'show_labels'            => '',
			'padding'                => '',
			'margin'                 => '',
			'class'                  => '',
			'button_style'           => '',
			'button_padding'         => '',
			'button_min_width'       => '',
			'fontsize'               => '',
			'iconsize'               => '',
			'container_max_width'    => '',
			'logged-in-text'         => __( 'You\'re already logged-in', 'um-social-login' ),
			'display-logged-in-text' => false,
			'integration_type'       => 'login_register',
		);

		$filter_atts = array_merge( $arr_settings, $atts );

		$args = shortcode_atts( $pairs, $filter_atts );
		if ( '0' === $args['show_for_members'] && is_user_logged_in() ) {
			if ( true === $atts['display-logged-in-text'] ) {
				return esc_attr( $atts['logged_in_text'] );
			} else {
				return '';
			}
		}

		if ( um_is_core_page( 'register' ) || 'register' === $args['integration_type'] ) {
			foreach ( $networks as $provider => $data ) {
				$networks[ $provider ]['button'] = str_replace( __( 'Sign in', 'um-social-login' ), __( 'Sign up', 'um-social-login' ), $networks[ $provider ]['button'] );
			}
		}

		$t_args = array_merge( $args, array( 'o_networks' => $networks ) );
		$output = UM()->get_template( 'buttons.php', UM_SOCIAL_LOGIN_PLUGIN, $t_args );

		return $output;
	}

	/**
	 * Additional arguments for user registration
	 *
	 * @param string $role Role slug.
	 * @param array  $args Field settings.
	 *
	 * @return string
	 */
	public function change_registration_role( $role, $args ) {
		$sso_session = UM()->Social_Login_API()->hybridauth()->session();
		if ( empty( $sso_session ) ) {
			return $role;
		}

		$shortcode_id = sanitize_key( $sso_session->get( 'um_sso' ) );
		if ( $shortcode_id && isset( $_REQUEST['return_provider'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification
			$assigned_role = get_post_meta( absint( $shortcode_id ), '_um_assigned_role', true );

			if ( ! empty( $assigned_role ) ) {
				$role = $assigned_role;
			}
		}

		return $role;
	}
}
