<?php
/**
 * Enqueue class handler
 *
 * @package um_ext\um_social_login\core\Social_Login_Enqueue
 */

namespace um_ext\um_social_login\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Social_Login_Enqueue
 *
 * @package um_ext\um_social_login\core
 */
class Social_Login_Enqueue {


	/**
	 * Asset suffix
	 *
	 * @var $suffix
	 */
	public $suffix;


	/**
	 * Social_Login_Enqueue constructor.
	 */
	public function __construct() {
		$enqueue      = UM()->frontend()->enqueue();
		$this->suffix = $enqueue::get_suffix();

		add_action( 'wp_enqueue_scripts', array( $this, 'wp_enqueue_scripts' ), 9 );
	}


	/**
	 * Frontend enqueue scripts
	 */
	public function wp_enqueue_scripts() {
		wp_register_script( 'um-social-login', UM_SOCIAL_LOGIN_URL . 'assets/js/um-social-connect' . $this->suffix . '.js', array( 'wp-hooks' ), UM_SOCIAL_LOGIN_VERSION, true );
		wp_register_style( 'um-social-login', UM_SOCIAL_LOGIN_URL . 'assets/css/um-social-connect' . $this->suffix . '.css', array(), UM_SOCIAL_LOGIN_VERSION );

		// Localize the script with new data.
		$settings = array(
			'current_window_auth' => UM()->options()->get( 'enable_current_window_authentication' ),
		);
		wp_localize_script( 'um-social-login', 'um_sso_global_settings', $settings );
	}
}
