<?php
/**
 * Form Hooks
 *
 * @package UM_Social_Login_API
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Save extra fields
 *
 * @param integer $user_id User ID.
 */
function um_social_login_save_extra_fields( $user_id ) {
	if ( ! isset( $_REQUEST['return_provider'] ) ) { // phpcs:disable WordPress.Security.NonceVerification
		return;
	}

	$provider       = sanitize_key( $_REQUEST['return_provider'] );
	$um_sso_session = UM()->Social_Login_API()->hybridauth()->session();
	$oauth_response = $um_sso_session->get( 'oauth_response' );
	if ( isset( $oauth_response['has_errors'] ) ) {
		UM()->Social_Login_API()->hybridauth()->log_error( array( 'registration_error' => $oauth_response ) );
		return;
	}

	um_fetch_user( $user_id );

	do_action( 'um_social_do_link_user', $provider, $oauth_response['userProfile'], '', false );
}
add_action( 'um_registration_set_extra_data', 'um_social_login_save_extra_fields', 9 );


/**
 * Modal field settings
 *
 * @param array $args Field settings.
 */
function um_social_login_add_buttons( $args ) {

	wp_enqueue_script( 'um-social-login' );
	wp_enqueue_style( 'um-social-login' );

	if ( isset( UM()->Social_Login_API()->profile ) ) {
		return;
	}

	$show_social = ( isset( $args['show_social'] ) ) ? $args['show_social'] : '-1';

	if ( ! $show_social ) {
		return;
	}

	if ( 'register' === $args['mode'] && ! UM()->options()->get( 'register_show_social' ) ) {
		return;
	}

	if ( 'login' === $args['mode'] && ! UM()->options()->get( 'login_show_social' ) ) {
		return;
	}

	$networks = UM()->Social_Login_API()->available_networks();

	if ( ! $networks ) {
		return;
	}

	if ( um_is_core_page( 'register' ) ) {
		foreach ( $networks as $provider => $data ) {
			$networks[ $provider ]['button'] = str_replace( __( 'Sign in', 'um-social-login' ), __( 'Sign up', 'um-social-login' ), $networks[ $provider ]['button'] );
		}
	}

	$o_networks = $networks; ?>

	<div class="um-field um-social-login-btns">
		<div class="um-col-alt">
			<?php
			$i = 0;
			foreach ( $o_networks as $sso_id => $arr_sso ) {
				$i++;
				$class = ( 0 === $i % 2 ) ? 'um-right' : 'um-left';
				?>

				<div class="<?php echo esc_attr( $class ); ?> um-half">
					<a href="<?php echo esc_attr( UM()->Social_Login_API()->hybridauth()->get_connect_url( $sso_id ) ); ?>" title="<?php echo esc_attr( $arr_sso['button'] ); ?>"
						data-redirect-url="<?php echo esc_attr( UM()->Social_Login_API()->hybridauth()->get_connect_url( $sso_id ) ); ?>" class="um-button um-alt um-button-social um-button-<?php echo esc_attr( $sso_id ); ?>" onclick="um_social_login_oauth_window( this.href,'authWindow', 'width=600,height=600,scrollbars=yes' );return false;">
						<?php
						if ( 'left' === $arr_sso['icon_position'] ) {
							?>
								<i class="<?php echo esc_attr( $arr_sso['icon'] ); ?>"></i>
							<?php
						}
						?>
						<span><?php echo esc_attr( $arr_sso['button'] ); ?></span>
						<?php
						if ( 'right' === $arr_sso['icon_position'] ) {
							?>
								<i class="<?php echo esc_attr( $arr_sso['icon'] ); ?>"></i>
							<?php
						}
						?>
					</a>
				</div>

				<?php if ( 0 === $i % 2 && count( $o_networks ) !== $i ) { ?>
					<div class="um-clear"></div>
		</div>
		<div class="um-col-alt um-col-alt-s">
					<?php
				}
			}
			?>

			<div class="um-clear"></div>
		</div>
	</div>

	<style type="text/css">

		.um-<?php echo esc_attr( $args['form_id'] ); ?>.um a.um-button.um-button-social {
			padding-left: 5px !important;
			padding-right: 5px !important;
		}

		<?php foreach ( $o_networks as $sso_id => $arr_sso ) { ?>
			.um-<?php echo esc_attr( $args['form_id'] ); ?>.um a.um-button.um-button-<?php echo esc_attr( $sso_id ); ?> {background-color: <?php echo esc_attr( $arr_sso['bg'] ); ?>!important}
			.um-<?php echo esc_attr( $args['form_id'] ); ?>.um a.um-button.um-button-<?php echo esc_attr( $sso_id ); ?>:hover {background-color: <?php echo esc_attr( $arr_sso['bg_hover'] ); ?>!important}
			.um-<?php echo esc_attr( $args['form_id'] ); ?>.um a.um-button.um-button-<?php echo esc_attr( $sso_id ); ?> {color: <?php echo esc_attr( $arr_sso['color'] ); ?>!important}
		<?php } ?>

	</style>

	<?php
}
add_action( 'um_before_register_fields', 'um_social_login_add_buttons', 10, 1 );
add_action( 'um_before_login_fields', 'um_social_login_add_buttons', 10, 1 );

/**
 * Add hidden type fields in Register Form
 *
 * @since 2.2.0
 *
 * @param array $args Form settings.
 */
function um_social_register_hidden_fields( $args ) {

	$um_sso_form_id = UM()->Social_Login_API()->user_connect()->form_id();

	if ( absint( $args['form_id'] ) !== absint( $um_sso_form_id ) ) {
		return;
	}

	$sso_session = UM()->Social_Login_API()->hybridauth()->session();

	if ( isset( $_SESSION['um_social_profile'] ) && ! empty( $_SESSION['um_social_profile'] ) ) {
		echo "<input type='hidden' name='_um_social_login' value='1' />";
	}

	if ( null !== $sso_session->get( 'um_social_login_redirect_after' ) ) {
		echo "<input type='hidden' name='_um_social_login_redirect_to' value='" . esc_attr( esc_url_raw( $sso_session->get( 'um_social_login_redirect_after' ) ) ) . "' />";
	}

	if ( null !== $sso_session->get( 'um_sso' ) ) {
		echo "<input type='hidden' name='_um_social_login_is_shortcode' value='" . esc_attr( intval( $sso_session->get( 'um_sso' ) ) ) . "' />";

	}

	$step_process = UM()->Social_Login_API()->user_connect()->get_enabled_step_process( $um_sso_form_id );

	if ( 0 === absint( $step_process ) && absint( $args['form_id'] ) === absint( $um_sso_form_id ) && isset( $_SESSION['um_social_profile'] ) && ! empty( $_SESSION['um_social_profile'] ) ) {
		echo "<input type='hidden' name='_um_social_login_one_step' value='1' />";
		$flash_screen = UM()->Social_Login_API()->user_connect()->get_show_flash_screen( $um_sso_form_id );
		echo "<input type='hidden' name='_um_sso_show_flash_screen' value='" . esc_attr( $flash_screen ) . "' />";
	}

}
add_action( 'um_before_register_fields', 'um_social_register_hidden_fields', 10, 1 );


/**
 * Keep user signed in?
 *
 * @return boolean $session|$cookie
 */
function um_keep_signed_in() {

	$session = absint( ! empty( $_SESSION['um_social_login_rememberme'] ) );
	$cookie  = absint( ! empty( $_COOKIE['um_social_login_rememberme'] ) );

	return $session || $cookie;
}


/**
 * Maybe other extension uses this?
 *
 * @todo Remove this.
 * @param string $role The role slug.
 *
 * @return string
 */
function um_remove_user_role( $role ) {
	return '';
}


/**
 * UM Private Messaging - Message button redirect URL.
 *
 * @param string  $current_url Current page URL.
 * @param integer $user_id User ID.
 */
function um_social_login_redirect_in_message_button( $current_url, $user_id ) {
	$_SESSION['um_social_login_redirect_after'] = $current_url;
}
add_action( 'um_messaging_button_in_profile', 'um_social_login_redirect_in_message_button', 1, 2 );


/**
 * Remove synced profile photo
 *
 * @param integer $user_id User ID.
 */
function um_social_login_remove_profile_photo( $user_id ) {
	delete_user_meta( $user_id, 'synced_profile_photo' );
}
add_action( 'um_after_remove_profile_photo', 'um_social_login_remove_profile_photo', 10, 1 );
