<?php
/**
 * Displays the activity wall.
 *
 * This template can be overridden by copying it to yourtheme/ultimate-member/um-social-activity/user-wall.php
 *
 * @see     https://docs.ultimatemember.com/article/1516-templates-map
 * @package um_ext\um_social_activity\templates
 * @version 2.3.4
 *
 * @var array  $allowed_html
 * @var int    $offset
 * @var bool   $end
 * @var array  $wall_posts
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

foreach ( $wall_posts as $wall_post_id ) {
	$author_id = UM()->Activity_API()->api()->get_author( $wall_post_id );
	$wall_id   = UM()->Activity_API()->api()->get_wall( $wall_post_id );
	$post_link = UM()->Activity_API()->api()->get_permalink( $wall_post_id );

	um_fetch_user( $author_id );
	?>

	<div class="um-activity-widget" id="postid-<?php echo esc_attr( $wall_post_id ); ?>">

		<div class="um-activity-head">

			<div class="um-activity-left um-activity-author">
				<div class="um-activity-ava">
					<a href="<?php echo esc_url( um_user_profile_url( $author_id ) ); ?>">
						<?php echo get_avatar( $author_id, 80 ); ?>
					</a>
				</div>
				<div class="um-activity-author-meta">
					<div class="um-activity-author-url">
						<a href="<?php echo esc_url( um_user_profile_url() ); ?>" class="um-link">
							<?php echo esc_html( um_user( 'display_name' ) ); ?>
						</a>
						<?php
						if ( $wall_id && $wall_id !== $author_id ) {
							um_fetch_user( $wall_id );
							?>
							<i class="um-icon-forward"></i>
							<a href="<?php echo esc_url( um_user_profile_url() ); ?>" class="um-link">
								<?php echo esc_html( um_user( 'display_name' ) ); ?>
							</a>
						<?php } ?>
					</div>
					<span class="um-activity-metadata">
						<a href="<?php echo esc_url( $post_link ); ?>">
							<?php echo wp_kses( UM()->Activity_API()->api()->get_post_time( $wall_post_id ), $allowed_html ); ?>
						</a>
					</span>
				</div>
			</div>

			<div class="um-activity-right">
				<?php if ( is_user_logged_in() ) { ?>

					<a href="javasscript:void(0);" class="um-activity-ticon um-activity-start-dialog" data-role="um-activity-tool-dialog">
						<i class="um-faicon-chevron-down"></i>
					</a>

					<div class="um-activity-dialog um-activity-tool-dialog">

						<?php if ( ( current_user_can( 'edit_users' ) || get_current_user_id() === (int) $author_id ) && 'status' === UM()->Activity_API()->api()->get_action_type( $wall_post_id ) ) { ?>
							<a href="javascript:void(0);" class="um-activity-manage">
								<?php esc_html_e( 'Edit', 'um-activity' ); ?>
							</a>
						<?php } ?>

						<?php if ( current_user_can( 'edit_users' ) || get_current_user_id() === (int) $author_id ) { ?>
							<a href="javascript:void(0);" class="um-activity-trash"
									data-msg="<?php esc_attr_e( 'Are you sure you want to delete this post?', 'um-activity' ); ?>">
								<?php esc_html_e( 'Delete', 'um-activity' ); ?>
							</a>
						<?php } ?>

						<?php if ( get_current_user_id() !== $author_id ) { ?>
							<span class="sep"></span>
							<a href="javascript:void(0);" class="um-activity-report <?php echo UM()->Activity_API()->api()->reported( $wall_post_id ) ? 'flagged' : ''; ?>"
									data-report="<?php esc_attr_e( 'Report', 'um-activity' ); ?>"
									data-cancel_report="<?php esc_attr_e( 'Cancel report', 'um-activity' ); ?>">
								<?php echo UM()->Activity_API()->api()->reported( $wall_post_id, get_current_user_id() ) ? esc_html__( 'Cancel report', 'um-activity' ) : esc_html__( 'Report', 'um-activity' ); ?>
							</a>
						<?php } ?>

					</div>

				<?php } ?>
			</div>

			<div class="um-clear"></div>
		</div>

		<?php
		$has_video      = UM()->Activity_API()->api()->get_video( $wall_post_id );
		$has_text_video = get_post_meta( $wall_post_id, '_video_url', true );
		$has_oembed     = get_post_meta( $wall_post_id, '_oembed', true );
		?>

		<div class="um-activity-body">
			<div class="um-activity-bodyinner<?php echo ( $has_video || $has_text_video ) ? ' has-embeded-video' : ''; ?> <?php echo $has_oembed ? ' has-oembeded' : ''; ?>">
				<div class="um-activity-bodyinner-edit">
					<textarea style="display: none;"><?php echo esc_attr( get_post_meta( $wall_post_id, '_original_content', true ) ); ?></textarea>

					<?php
					$photo_base = get_post_meta( $wall_post_id, '_photo', true );
					$photo_url  = UM()->Activity_API()->api()->get_download_link( $wall_post_id, $author_id );
					?>
					<input type="hidden" name="_photo" value="<?php echo esc_attr( $photo_base ); ?>" />
					<input type="hidden" name="_photo_url" value="<?php echo esc_attr( $photo_url ); ?>" />
				</div>

				<?php
				do_action( 'um_activity_wall_before_displaying_post_content', $wall_post_id );

				$um_activity_post = UM()->Activity_API()->api()->get_content( $wall_post_id );
				$um_shared_link   = get_post_meta( $wall_post_id, '_shared_link', true );
				$content          = $um_activity_post . $um_shared_link;
				if ( $content ) {
					?>
					<div class="um-activity-bodyinner-txt">
						<?php echo wp_kses( $content, $allowed_html ); ?>
					</div>
				<?php } ?>

				<div class="um-activity-bodyinner-photo">
					<?php echo wp_kses( UM()->Activity_API()->api()->get_photo( $wall_post_id, '', $author_id ), $allowed_html ); ?>
				</div>

				<?php
				if ( empty( $um_shared_link ) ) {
					?>
					<div class="um-activity-bodyinner-video">
						<?php echo wp_kses( $has_video, $allowed_html ); ?>
					</div>
					<?php
				}

				do_action( 'um_activity_wall_after_displaying_post_content', $wall_post_id );
				?>
			</div>

			<?php
			$likes         = UM()->Activity_API()->api()->get_likes_number( $wall_post_id );
			$wall_comments = UM()->Activity_API()->api()->get_comments_number( $wall_post_id );

			if ( $likes > 0 || $wall_comments > 0 ) {
				?>
				<div class="um-activity-disp">
					<div class="um-activity-left">
						<div class="um-activity-disp-likes">
							<a href="javascript:void(0);" class="um-activity-show-likes um-link" data-post_id="<?php echo absint( $wall_post_id ); ?>">
								<span class="um-activity-post-likes"><?php echo absint( $likes ); ?></span>
								<span class="um-activity-disp-span"><?php esc_html_e( 'likes', 'um-activity' ); ?></span>
							</a>
						</div>
						<div class="um-activity-disp-comments">
							<a href="javascript:void(0);" class="um-link">
								<span class="um-activity-post-comments"><?php echo absint( $wall_comments ); ?></span>
								<span class="um-activity-disp-span"><?php esc_html_e( 'comments', 'um-activity' ); ?></span>
							</a>
						</div>
					</div>
					<div class="um-activity-faces um-activity-right">
						<?php echo wp_kses( UM()->Activity_API()->api()->get_faces( $wall_post_id ), $allowed_html ); ?>
					</div>
					<div class="um-clear"></div>
				</div>
				<div class="um-clear"></div>
			<?php } ?>

		</div>

		<div class="um-activity-foot status" id="wallcomments-<?php echo absint( $wall_post_id ); ?>">
			<?php if ( is_user_logged_in() ) { ?>

				<div class="um-activity-left um-activity-actions">
					<?php if ( UM()->Activity_API()->api()->user_liked( $wall_post_id ) ) { ?>
						<div class="um-activity-like active"
								data-like_text="<?php esc_attr_e( 'Like', 'um-activity' ); ?>"
								data-unlike_text="<?php esc_attr_e( 'Unlike', 'um-activity' ); ?>">
							<a href="javascript:void(0);">
								<i class="um-faicon-thumbs-up um-active-color"></i>
								<span class=""><?php esc_html_e( 'Unlike', 'um-activity' ); ?></span>
							</a>
						</div>
					<?php } else { ?>
						<div class="um-activity-like"
								data-like_text="<?php esc_attr_e( 'Like', 'um-activity' ); ?>"
								data-unlike_text="<?php esc_attr_e( 'Unlike', 'um-activity' ); ?>">
							<a href="javascript:void(0);">
								<i class="um-faicon-thumbs-up"></i>
								<span class=""><?php esc_html_e( 'Like', 'um-activity' ); ?></span>
							</a>
						</div>
					<?php } ?>

					<?php if ( UM()->Activity_API()->api()->can_comment() ) { ?>
						<div class="um-activity-comment">
							<a href="javascript:void(0);">
								<i class="um-faicon-comment"></i>
								<span class=""><?php esc_html_e( 'Comment', 'um-activity' ); ?></span>
							</a>
						</div>
					<?php } ?>
				</div>

			<?php } else { ?>
				<div class="um-activity-left um-activity-join">
					<?php echo wp_kses( UM()->Activity_API()->api()->login_to_interact( $wall_post_id ), $allowed_html ); ?>
				</div>
			<?php } ?>

			<div class="um-clear"></div>
		</div>

		<?php
		$t_args = array(
			'post_id' => $wall_post_id,
		);

		UM()->Activity_API()->shortcode()->args = $t_args;
		UM()->get_template( 'comments.php', um_activity_plugin, $t_args, true );
		?>

	</div>

	<?php
}
um_reset_user();

if ( ! empty( $end ) ) {
	?>
	<div class="um-activity-end"></div>
	<?php
} else {
	?>
	<div class="um-activity-load" data-offset="<?php echo esc_attr( $offset ); ?>"></div>
	<?php
}
