<?php
namespace um_ext\um_social_activity\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Activity_Shortcode
 * @package um_ext\um_social_activity\core
 */
class Activity_Shortcode {

	/**
	 * @var bool
	 */
	var $confirm_box = false;

	public $args = array();

	private $jetpack_filters = array();

	private $jetpack_removed_filters = array();

	/**
	 * Activity_Shortcode constructor.
	 */
	public function __construct() {
		add_shortcode( 'ultimatemember_wall', array( &$this, 'ultimatemember_wall' ) );
		add_shortcode( 'ultimatemember_activity', array( &$this, 'ultimatemember_activity' ) );
		add_shortcode( 'ultimatemember_activity_form', array( &$this, 'ultimatemember_activity_form' ) );
		add_shortcode( 'ultimatemember_activity_single_post', array( &$this, 'activity_single_post' ) );

		add_shortcode( 'ultimatemember_trending_hashtags', array( &$this, 'ultimatemember_trending_hashtags' ) );
		add_filter( 'um_custom_image_handle_wall_img_upload', array( $this, 'stream_photo_data' ), 10, 1 );

		$this->args = array( '' );

		// Integration with Jetpack.
		add_action( 'init', array( &$this, 'populate_jetpack_filters' ) );
		add_action( 'um_activity_wall_before_displaying_post_content', array( &$this, 'jetpack_remove_pre_kses' ) );
		add_action( 'um_activity_wall_after_displaying_post_content', array( &$this, 'jetpack_add_pre_kses' ) );
	}

	public function populate_jetpack_filters() {
		$this->jetpack_filters = array(
			'jetpack_archiveorg_book_embed_to_shortcode',
			'jetpack_archiveorg_embed_to_shortcode',
			'dailymotion_embed_to_shortcode',
			'dailymotion_channel_reversal',
			'jetpack_dailymotion_embed_reversal',
			'jetpack_shortcodereverse_descript',
			'flickr_embed_to_shortcode',
			'wpcom_shortcodereverse_getty',
			'googleapps_embed_to_shortcode',
			'jetpack_googlemaps_embed_to_short_code',
			'jetpack_instagram_embed_reversal',
			'jetpack_kickstarter_embed_to_shortcode',
			'jetpack_shortcodereverse_smartframe',
			'jetpack_soundcloud_embed_reversal',
			'vimeo_embed_to_shortcode',
			'youtube_embed_to_short_code',
		);

		foreach ( $this->jetpack_filters as $k => $callback ) {
			if ( ! function_exists( $callback ) ) {
				unset( $this->jetpack_filters[ $k ] );
			}
		}

		if ( class_exists( 'Filter_Embedded_HTML_Objects' ) ) {
			if ( method_exists( 'Filter_Embedded_HTML_Objects', 'filter' ) ) {
				$this->jetpack_filters[] = array(
					'callback' => array( 'Filter_Embedded_HTML_Objects', 'filter' ),
					'priority' => 11,
				);
			}

			if ( method_exists( 'Filter_Embedded_HTML_Objects', 'maybe_create_links' ) ) {
				$this->jetpack_filters[] = array(
					'callback' => array( 'Filter_Embedded_HTML_Objects', 'maybe_create_links' ),
					'priority' => 100,
				);
			}
		}

		if ( class_exists( 'CrowdsignalShortcode' ) && method_exists( 'CrowdsignalShortcode', 'crowdsignal_embed_to_shortcode' ) ) {
			$this->jetpack_filters[] = array( 'CrowdsignalShortcode', 'crowdsignal_embed_to_shortcode' );
		}

		if ( class_exists( 'MailChimp_Subscriber_Popup' ) && method_exists( 'MailChimp_Subscriber_Popup', 'reversal' ) ) {
			$this->jetpack_filters[] = array( 'MailChimp_Subscriber_Popup', 'reversal' );
		}
	}

	public function jetpack_remove_pre_kses() {
		if ( empty( $this->jetpack_filters ) ) {
			return;
		}

		foreach ( $this->jetpack_filters as $callback ) {
			if ( is_array( $callback ) && ! empty( $callback['callback'] ) && isset( $callback['priority'] ) ) {
				if ( has_filter( 'pre_kses', $callback['callback'] ) ) {
					$this->jetpack_removed_filters[] = $callback;
					remove_filter( 'pre_kses', $callback['callback'], $callback['priority'] );
				}
			} else {
				if ( has_filter( 'pre_kses', $callback ) ) {
					$this->jetpack_removed_filters[] = $callback;
					remove_filter( 'pre_kses', $callback );
				}
			}
		}
	}

	public function jetpack_add_pre_kses() {
		if ( empty( $this->jetpack_removed_filters ) ) {
			return;
		}

		foreach ( $this->jetpack_removed_filters as $callback ) {
			if ( is_array( $callback ) && ! empty( $callback['callback'] ) && isset( $callback['priority'] ) ) {
				if ( ! has_filter( 'pre_kses', $callback['callback'] ) ) {
					add_filter( 'pre_kses', $callback['callback'], $callback['priority'] );
				}
			} else {
				if ( ! has_filter( 'pre_kses', $callback ) ) {
					add_filter( 'pre_kses', $callback );
				}
			}
		}

		$this->jetpack_removed_filters = array();
	}

	/**
	 * Display trending hashtags.
	 *
	 * @param array $args
	 *
	 * @return string
	 */
	public function ultimatemember_trending_hashtags( $args = array() ) {
		UM()->Activity_API()->enqueue()->enqueue_scripts();

		add_action( 'wp_footer', 'um_activity_confirm_box' );

		$defaults = array(
			'trending_days' => absint( UM()->options()->get( 'activity_trending_days' ) ),
			'number'        => 10,
		);

		$args = shortcode_atts( $defaults, $args, 'ultimatemember_trending_hashtags' );

		global $wpdb;

		$term_ids = $wpdb->get_col(
			$wpdb->prepare(
				"SELECT term_id FROM $wpdb->term_taxonomy
				INNER JOIN $wpdb->term_relationships ON $wpdb->term_taxonomy.term_taxonomy_id = $wpdb->term_relationships.term_taxonomy_id
				INNER JOIN $wpdb->posts ON $wpdb->posts.ID = $wpdb->term_relationships.object_id
				WHERE $wpdb->posts.post_type = 'um_activity' AND
					  $wpdb->term_taxonomy.taxonomy = 'um_hashtag' AND
					  DATE_SUB( CURDATE(), INTERVAL %d DAY ) <= $wpdb->posts.post_date",
				absint( $args['trending_days'] )
			)
		);

		$output = '';
		if ( count( $term_ids ) > 0 ) {
			$hashtags = get_terms(
				array( 'um_hashtag' ),
				array(
					'orderby' => 'count',
					'order'   => 'DESC',
					'number'  => absint( $args['number'] ),
					'include' => $term_ids,
				)
			);

			$this->args = array( 'hashtags' => $hashtags );

			$t_args = $this->args;
			$output = UM()->get_template( 'trending.php', um_activity_plugin, $t_args );
		}

		return $output;
	}

	public function activity_single_post( $args = array() ) {
		if ( ! is_user_logged_in() && UM()->options()->get( 'activity_require_login' ) ) {
			return __( 'You must login to view activity.', 'um-activity' );
		}

		$defaults = array(
			'wall_post' => '',
		);
		$args     = shortcode_atts( $defaults, $args, 'ultimatemember_activity_single_post' );

		if ( empty( $args['wall_post'] ) ) {
			return __( 'Invalid wall post.', 'um-activity' );
		}

		$args['wall_post'] = absint( $args['wall_post'] );

		if ( ! UM()->Activity_API()->api()->can_view_post( $args['wall_post'] ) ) {
			return __( 'Invalid wall post.', 'um-activity' );
		}

		UM()->Activity_API()->enqueue()->enqueue_scripts();

		add_action( 'wp_footer', 'um_activity_confirm_box' );

		$user_id = get_current_user_id();

		um_fetch_user( $user_id );
		ob_start();
		?>

		<div class="um um-activity um-um_activity_id">
			<div class="um-form">
				<?php
				if ( is_user_logged_in() && UM()->Activity_API()->api()->can_write() ) {
					$t_args              = $this->args;
					$t_args['user_wall'] = false;
					UM()->get_template( 'edit-post.php', um_activity_plugin, $t_args, true );
				}
				?>

				<div class="um-activity-wall"
					data-user_id="<?php echo esc_attr( $user_id ); ?>"
					data-user_wall="0"
					data-single_post="1"
					data-wall_post="<?php echo esc_attr( $args['wall_post'] ); ?>"
					data-comments_order="<?php echo esc_attr( UM()->options()->get( 'activity_order_comment' ) ); ?>">

					<?php
					UM()->Activity_API()->shortcode()->args = array(
						'allowed_html' => UM()->Activity_API()->api()->get_allowed_html(),
						'offset'       => UM()->Activity_API()->api()->get_posts_per_page(),
						'wall_post'    => $args['wall_post'],
						'wall_posts'   => array( $args['wall_post'] ),
						'end'          => true,
					);
					$t_args                                 = UM()->Activity_API()->shortcode()->args;

					// @todo: Remove 'safe_style_css' as soon as Requires at least >= 6.2.
					add_filter( 'safe_style_css', array( UM()->Activity_API()->api(), 'add_extra_safe_style_css' ) );
					UM()->get_template( 'user-wall.php', um_activity_plugin, $t_args, true );
					remove_filter( 'safe_style_css', array( UM()->Activity_API()->api(), 'add_extra_safe_style_css' ) );

					if ( is_user_logged_in() ) {
						UM()->get_template( 'clone.php', um_activity_plugin, array( 'user_id' => $user_id ), true );
					}
					?>
				</div>
			</div>
		</div>

		<?php
		$output = ob_get_clean();
		um_reset_user();

		return $output;
	}

	/**
	 * Display User's Wall
	 *
	 * @param array $args
	 *
	 * @return string
	 */
	public function ultimatemember_wall( $args = array() ) {
		if ( ! is_user_logged_in() && UM()->options()->get( 'activity_require_login' ) ) {
			return __( 'You must login to view this user activity.', 'um-activity' );
		}

		UM()->Activity_API()->enqueue()->enqueue_scripts();

		add_action( 'wp_footer', 'um_activity_confirm_box' );

		// phpcs:disable WordPress.Security.NonceVerification
		$defaults = array(
			'user_id' => um_profile_id(),
			'loading' => 'async', // AJAX loading by default. Set to 'sync' for loading 1st activity page together with WordPress page.
		);
		// phpcs:enable WordPress.Security.NonceVerification
		$args = shortcode_atts( $defaults, $args, 'ultimatemember_wall' );

		$um_current_page_tab = get_query_var( 'profiletab' );
		if ( 'activity' === $um_current_page_tab && um_is_core_page( 'user' ) ) {
			$args['user_id'] = um_profile_id();
		}

		$user_id  = $args['user_id'];
		$can_view = UM()->Activity_API()->api()->can_view_wall( $user_id );
		if ( true !== $can_view ) {
			return $can_view;
		}

		$per_page = UM()->Activity_API()->api()->get_posts_per_page();

		$this->args = $args;

		um_fetch_user( $user_id );
		ob_start();
		?>

		<div class="um">
			<div class="um-form">
				<?php
				if ( is_user_logged_in() && UM()->Activity_API()->api()->can_write() ) {
					$t_args              = $this->args;
					$t_args['user_wall'] = true;
					UM()->get_template( 'new.php', um_activity_plugin, $t_args, true );
					UM()->get_template( 'edit-post.php', um_activity_plugin, $t_args, true );
				}
				?>

				<div class="um-activity-wall"
					data-user_id="<?php echo esc_attr( $user_id ); ?>"
					data-user_wall="1"
					data-single_post="0"
					data-loading="<?php echo esc_attr( $args['loading'] ); ?>"
					data-per_page="<?php echo esc_attr( $per_page ); ?>"
					data-wall_post="0"
					data-comments_order="<?php echo esc_attr( UM()->options()->get( 'activity_order_comment' ) ); ?>">

					<?php
					if ( 'sync' === $args['loading'] ) {
						$query_args = array(
							'user_wall' => true,
							'user_id'   => $user_id,
						);
						$query      = UM()->Activity_API()->api()->get_wall_posts( $query_args );

						$offset = UM()->Activity_API()->api()->get_posts_per_page();

						$this->args = array(
							'allowed_html' => UM()->Activity_API()->api()->get_allowed_html(),
							'offset'       => $offset,
							'wall_posts'   => $query['result'],
							'end'          => $offset >= $query['total_posts'],
						);
						$t_args     = $this->args;

						// @todo: Remove 'safe_style_css' as soon as Requires at least >= 6.2.
						add_filter( 'safe_style_css', array( UM()->Activity_API()->api(), 'add_extra_safe_style_css' ) );
						UM()->get_template( 'user-wall.php', um_activity_plugin, $t_args, true );
						remove_filter( 'safe_style_css', array( UM()->Activity_API()->api(), 'add_extra_safe_style_css' ) );
					}

					if ( is_user_logged_in() ) {
						UM()->get_template( 'clone.php', um_activity_plugin, array( 'user_id' => $user_id ), true );
					}
					?>
				</div>
			</div>
		</div>

		<?php
		$output = ob_get_clean();
		um_reset_user();

		return $output;
	}

	/**
	 * Display site's activity
	 *
	 * @param array $args
	 *
	 * @return string
	 */
	public function ultimatemember_activity( $args = array() ) {
		if ( ! is_user_logged_in() && UM()->options()->get( 'activity_require_login' ) ) {
			return __( 'You must login to view activity wall.', 'um-activity' );
		}

		// Left `wall_post` for backward compatibility or getting it from $_GET attribute.
		$defaults = array(
			'wall_post' => ( isset( $_GET['wall_post'] ) ) ? absint( $_GET['wall_post'] ) : '', // phpcs:ignore WordPress.Security.NonceVerification
			'hashtag'   => ( isset( $_GET['hashtag'] ) ) ? sanitize_text_field( $_GET['hashtag'] ) : '', // phpcs:ignore WordPress.Security.NonceVerification
			'template'  => 'activity', // @todo deprecate because internal
			'mode'      => 'activity', // @todo deprecate because internal
			'form_id'   => 'um_activity_id', // @todo deprecate because internal
			'loading'   => 'async', // AJAX loading by default. Set to 'sync' for loading 1st activity page together with WordPress page.
		);
		$args     = shortcode_atts( $defaults, $args, 'ultimatemember_activity' );

		// Single post shortcode if there is a proper $_GET attribute
		if ( ! empty( $args['wall_post'] ) ) {
			return $this->activity_single_post( array( 'wall_post' => absint( $args['wall_post'] ) ) );
		}

		$this->args = $args;

		UM()->Activity_API()->enqueue()->enqueue_scripts();
		add_action( 'wp_footer', 'um_activity_confirm_box' );

		$hashtag_id = '';
		if ( ! empty( $args['hashtag'] ) ) {
			$hashtag    = str_replace( '#', '', sanitize_text_field( $args['hashtag'] ) );
			$term       = get_term_by( 'name', $hashtag, 'um_hashtag' );
			$hashtag_id = isset( $term->term_id ) ? $term->term_id : '';
		}

		$user_id  = get_current_user_id();
		$per_page = UM()->Activity_API()->api()->get_posts_per_page();

		um_fetch_user( $user_id );
		ob_start();
		?>

		<div class="um <?php echo esc_attr( UM()->shortcodes()->get_class( $args['mode'] ) ); ?> um-<?php echo esc_attr( $args['form_id'] ); ?>">
			<div class="um-form">

				<?php
				if ( ! empty( $args['hashtag'] ) ) {
					$get_hashtag = get_term_by( 'slug', $args['hashtag'], 'um_hashtag' );
					if ( ! isset( $get_hashtag->name ) ) {
						echo '<div class="um-activity-bigtext">#' . esc_html( $args['hashtag'] ) . '</div>';
						return '<p>' . __( 'There are no posts with this hashtag.', 'um-activity' ) . '</p></div></div>';
					}
					$hashtag_name = str_replace( '#', '', $get_hashtag->name );
					echo '<div class="um-activity-bigtext">#' . esc_html( $hashtag_name ) . '</div>';

					$check_hashtag_args  = array(
						'hashtag_id' => $hashtag_id,
						'user_wall'  => false,
						'offset'     => 0,
					);
					$check_hashtag_query = UM()->Activity_API()->api()->get_wall_posts( $check_hashtag_args );
					if ( empty( $check_hashtag_query['total_posts'] ) ) {
						return '<p>' . esc_html__( 'There are no posts with this hashtag.', 'um-activity' ) . '</p></div></div>';
					}
				} else {
					$hashtag_name = '';
				}

				if ( empty( $args['hashtag'] ) && is_user_logged_in() && UM()->Activity_API()->api()->can_write() ) {
					$t_args              = $this->args;
					$t_args['user_wall'] = false;
					UM()->get_template( 'new.php', um_activity_plugin, $t_args, true );
				}

				if ( is_user_logged_in() && UM()->Activity_API()->api()->can_write() ) {
					$t_args              = $this->args;
					$t_args['user_wall'] = false;
					UM()->get_template( 'edit-post.php', um_activity_plugin, $t_args, true );
				}
				?>

				<div class="um-activity-wall" data-user_wall="0"
					data-per_page="<?php echo sanitize_html_class( $per_page ); ?>"
					data-single_post="0"
					data-loading="<?php echo esc_attr( $args['loading'] ); ?>"
					data-hashtag="<?php echo esc_attr( $hashtag_name ); ?>"
					data-wall_post=""
					data-comments_order="<?php echo esc_attr( UM()->options()->get( 'activity_order_comment' ) ); ?>">
					<?php
					if ( 'sync' === $args['loading'] ) {
						$hashtag_id = '';
						if ( ! empty( $args['hashtag'] ) ) {
							$hashtag    = str_replace( '#', '', sanitize_text_field( $args['hashtag'] ) );
							$term       = get_term_by( 'name', $hashtag, 'um_hashtag' );
							$hashtag_id = isset( $term->term_id ) ? $term->term_id : '';
						}

						$query_args = array(
							'hashtag_id' => $hashtag_id,
						);
						$query      = UM()->Activity_API()->api()->get_wall_posts( $query_args );

						$offset = UM()->Activity_API()->api()->get_posts_per_page();

						$this->args = array(
							'allowed_html' => UM()->Activity_API()->api()->get_allowed_html(),
							'offset'       => $offset,
							'wall_posts'   => $query['result'],
							'end'          => $offset >= $query['total_posts'],
						);
						$t_args     = $this->args;

						// @todo: Remove 'safe_style_css' as soon as Requires at least >= 6.2.
						add_filter( 'safe_style_css', array( UM()->Activity_API()->api(), 'add_extra_safe_style_css' ) );
						UM()->get_template( 'user-wall.php', um_activity_plugin, $t_args, true );
						remove_filter( 'safe_style_css', array( UM()->Activity_API()->api(), 'add_extra_safe_style_css' ) );
					}

					if ( is_user_logged_in() ) {
						UM()->get_template( 'clone.php', um_activity_plugin, array(), true );
					}
					?>
				</div>
			</div>
		</div>

		<?php
		$output = ob_get_clean();
		um_reset_user();

		return $output;
	}

	/**
	 * Display form
	 *
	 * @param array $args
	 *
	 * @return string
	 */
	public function ultimatemember_activity_form( $args = array() ) {
		if ( ! is_user_logged_in() ) {
			return __( 'You must login to create new post.', 'um-activity' );
		}

		UM()->Activity_API()->enqueue()->enqueue_scripts();

		$defaults   = array(
			'user_id' => um_profile_id(),
			'mode'    => 'activity',
			'form_id' => 'um_activity_id',
		);
		$args       = shortcode_atts( $defaults, $args, 'ultimatemember_activity_form' );
		$this->args = $args;

		$user_id = $args['user_id'];

		um_fetch_user( $user_id );
		ob_start();
		?>

		<div class="um <?php echo esc_attr( UM()->shortcodes()->get_class( $args['mode'] ) ); ?> um-<?php echo esc_attr( $args['form_id'] ); ?>">
			<div class="um-form um-activity-posting-only">
				<?php
					$t_args              = $this->args;
					$t_args['user_wall'] = ( get_current_user_id() !== absint( $user_id ) );
					UM()->get_template( 'new.php', um_activity_plugin, $t_args, true );
				?>
			</div>
		</div>

		<?php

		$output = ob_get_clean();
		um_reset_user();

		return $output;
	}

	/**
	 * Set stream photo default settings
	 * @param  array $args
	 * @return array
	 *
	 * @since 2.0.22
	 */
	public function stream_photo_data( $args ) {
		$args['max_file_size'] = apply_filters( 'um_activity_upload_images_stream_maximum_file_size', 9999999 );
		// translators: %s is maximum file size
		$args['max_file_size_error'] = sprintf( __( 'Maximum file size allowed: %s', 'um-activity' ), size_format( $args['max_file_size'] ) );

		return $args;
	}
}
