<?php
namespace um_ext\um_social_activity\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Activity_Setup
 * @package um_ext\um_social_activity\core
 */
class Activity_Setup {

	/**
	 * @var array
	 */
	var $settings_defaults;

	/**
	 * @var
	 */
	var $global_actions;

	/**
	 * Activity_Setup constructor.
	 */
	public function __construct() {
		$this->global_actions['status']               = __( 'New wall post', 'um-activity' );
		$this->global_actions['new-user']             = __( 'New user', 'um-activity' );
		$this->global_actions['new-post']             = __( 'New blog post', 'um-activity' );
		$this->global_actions['new-product']          = __( 'New product', 'um-activity' );
		$this->global_actions['new-gform']            = __( 'New Gravity Form', 'um-activity' );
		$this->global_actions['new-gform-submission'] = __( 'New Gravity Form Answer', 'um-activity' );
		$this->global_actions['new-follow']           = __( 'New follow', 'um-activity' );
		$this->global_actions['new-topic']            = __( 'New forum topic', 'um-activity' );

		//settings defaults
		$this->settings_defaults = array(
			'activity_posts_num'              => 10,
			'activity_max_faces'              => 10,
			'activity_posts_num_mob'          => 5,
			'activity_init_comments_count'    => 2,
			'activity_load_comments_count'    => 10,
			'activity_order_comment'          => 'asc',
			'activity_post_truncate'          => 25,
			'activity_enable_privacy'         => 1,
			'activity_trending_days'          => 7,
			'activity_require_login'          => 0,
			'activity_need_to_login'          => __( 'Please <a href="{register_page}" class="um-link">sign up</a> or <a href="{login_page}" class="um-link">sign in</a> to like or comment on this post.', 'um-activity' ),
			'activity_followers_mention'      => 1,
			'activity_friends_mention'        => 1,
			'activity_followed_users'         => 0,
			'activity_friends_users'          => 0,
			'profile_tab_activity'            => 1,
			'profile_tab_activity_privacy'    => 0,
			'activity_highlight_color'        => '#0085ba',
			'activity_post_attachments_cache' => false,
		);

		foreach ( apply_filters( 'um_activity_global_actions', $this->global_actions ) as $k => $v ) {
			if ( 'status' === $k ) {
				continue;
			}

			$this->settings_defaults[ 'activity-' . $k ] = 1;
		}

		$notification_types_templates = array(
			'new_wall_post'     => __( '<strong>{member}</strong> has posted on your wall.', 'um-activity' ),
			'new_wall_comment'  => __( '<strong>{member}</strong> has commented on your wall post.', 'um-activity' ),
			'new_post_like'     => __( '<strong>{member}</strong> likes your wall post.', 'um-activity' ),
			'new_mention'       => __( '<strong>{member}</strong> just mentioned you.', 'um-activity' ),
		);

		foreach ( $notification_types_templates as $k => $template ) {
			$this->settings_defaults[ 'log_' . $k ] = 1;
			$this->settings_defaults[ 'log_' . $k . '_template' ] = $template;
		}
	}

	/**
	 *
	 */
	private function set_default_settings() {
		$options = get_option( 'um_options', array() );
		foreach ( $this->settings_defaults as $key => $value ) {
			//set new options to default
			if ( ! isset( $options[ $key ] ) ) {
				$options[ $key ] = $value;
			}
		}

		update_option( 'um_options', $options );
	}

	/**
	 *
	 */
	private function force_show_create_pages() {
		$version = get_option( 'um_activity_version' );

		if ( ! $version ) {
			$hidden_notices = get_option( 'um_hidden_admin_notices', array() );
			$hidden_notices = array_flip( $hidden_notices );
			unset( $hidden_notices['wrong_pages'] );
			$hidden_notices = array_flip( $hidden_notices );

			update_option( 'um_hidden_admin_notices', $hidden_notices );
		}
	}

	/**
	 *
	 */
	public function run_setup() {
		$this->set_default_settings();
		$this->force_show_create_pages();
	}
}
