<?php
namespace um_ext\um_social_activity\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Activity_Enqueue
 * @package um_ext\um_social_activity\core
 */
class Activity_Enqueue {

	/**
	 * Activity_Enqueue constructor.
	 */
	public function __construct() {
		$priority = apply_filters( 'um_activity_enqueue_priority', 0 );
		add_action( 'wp_enqueue_scripts', array( &$this, 'wp_enqueue_scripts' ), $priority );
	}

	/**
	 * Enqueue scripts
	 */
	public function wp_enqueue_scripts() {
		$suffix = UM()->frontend()->enqueue()::get_suffix();

		wp_register_script( 'um_scrollbar', um_activity_url . 'assets/libs/simplebar/simplebar' . $suffix . '.js', array( 'jquery' ), '4.0.0-alpha.5', true );
		wp_register_style( 'um_scrollbar', um_activity_url . 'assets/libs/simplebar/simplebar' . $suffix . '.css', array(), '4.0.0-alpha.5' );
		wp_register_script( 'um_autosize', um_activity_url . 'assets/libs/autosize/autosize' . $suffix . '.js', array( 'jquery' ), '6.0.1', true );
		wp_register_script( 'um_scrollto', um_activity_url . 'assets/libs/jquery.scrollTo/jquery.scrollTo' . $suffix . '.js', array( 'jquery' ), '2.1.3', true );

		wp_register_script( 'um_activity', um_activity_url . 'assets/js/um-activity' . $suffix . '.js', array( 'um_scripts', 'jquery-ui-autocomplete', 'um_autosize', 'um_scrollto', 'um_scrollbar' ), um_activity_version, true );

		wp_register_style( 'um_activity', um_activity_url . 'assets/css/um-activity' . $suffix . '.css', array( 'um_scrollbar' ), um_activity_version );
		wp_register_style( 'um_activity_responsive', um_activity_url . 'assets/css/um-activity-responsive' . $suffix . '.css', array( 'um_activity' ), um_activity_version );
	}

	/**
	 *
	 */
	public function enqueue_scripts() {
		wp_enqueue_script( 'um_activity' );
		wp_enqueue_style( 'um_activity_responsive' );

		do_action( 'um_social_activity_enqueue_scripts' );
	}
}
