<?php if ( ! defined( 'ABSPATH' ) ) exit;


/**
 * Creates options in Role page
 *
 * @param $roles_metaboxes
 *
 * @return array
 */
function um_activity_add_role_metabox( $roles_metaboxes ) {

	$roles_metaboxes[] = array(
		'id'        => "um-admin-form-activity{" . um_activity_path . "}",
		'title'     => __( 'Social Activity', 'um-activity' ),
		'callback'  => array( UM()->metabox(), 'load_metabox_role' ),
		'screen'    => 'um_role_meta',
		'context'   => 'normal',
		'priority'  => 'default'
	);

	return $roles_metaboxes;
}
add_filter( 'um_admin_role_metaboxes', 'um_activity_add_role_metabox', 10, 1 );

/**
 * Clear a wall post report.
 */
function um_admin_do_action__wall_report() {
	if ( empty( $_REQUEST['post_id'] ) || empty( $_REQUEST['_wpnonce'] ) || ! wp_verify_nonce( $_REQUEST['_wpnonce'], "wall_report{$_REQUEST['post_id']}" ) ) {
		wp_die( esc_html__( 'Security check', 'um-activity' ) );
	}

	if ( ! is_numeric( $_REQUEST['post_id'] ) ) {
		die();
	}

	$post_id = absint( $_REQUEST['post_id'] );

	if ( ! UM()->Activity_API()->api()->reported( $post_id ) ) {
		die();
	}

	delete_post_meta( $post_id, '_reported' );
	delete_post_meta( $post_id, '_reported_by' );

	$count = (int) get_option( 'um_activity_flagged' );
	if ( $count < 1 ) {
		$count = 1;
	}
	update_option( 'um_activity_flagged', absint( $count - 1 ) );

	wp_safe_redirect( admin_url( 'edit.php?post_type=um_activity' ) );
	exit;
}
add_action( 'um_admin_do_action__wall_report', 'um_admin_do_action__wall_report' );

function um_social_activity_adm_action_individual_nonce_actions( $actions ) {
	$actions[] = 'wall_report';
	return $actions;
}
add_filter( 'um_adm_action_individual_nonce_actions', 'um_social_activity_adm_action_individual_nonce_actions' );
