<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Extend settings
 *
 * @param array $settings
 *
 * @return array
 */
function um_reviews_settings( $settings ) {
	$settings['extensions']['sections']['reviews'] = array(
		'title'  => __( 'Reviews', 'um-reviews' ),
		'fields' => array(
			array(
				'id'    => 'members_show_rating',
				'type'  => 'checkbox',
				'label' => __( 'Show user rating in members directory', 'um-reviews' ),
			),
			array(
				'id'      => 'review_date_format',
				'type'    => 'select',
				'label'   => __( 'Review date format', 'um-reviews' ),
				'options' => array(
					'j M Y' => UM()->datetime()->get_time( 'j M Y' ),
					'M j Y' => UM()->datetime()->get_time( 'M j Y' ),
					'j F Y' => UM()->datetime()->get_time( 'j F Y' ),
					'F j Y' => UM()->datetime()->get_time( 'F j Y' ),
				),
				'size'    => 'small',
			),
			array(
				'id'          => 'can_flag_review',
				'type'        => 'select',
				'label'       => __( 'Who can flag reviews', 'um-reviews' ),
				'options'     => array(
					'everyone' => __( 'Everyone', 'um-reviews' ),
					'loggedin' => __( 'All Logged-in Users', 'um-reviews' ),
					'reviewed' => __( 'Reviewed user only', 'um-reviews' ),
				),
				'placeholder' => __( 'Select...', 'um-reviews' ),
				'size'        => 'small',
			),
			array(
				'id'    => 'enable_review_reply',
				'type'  => 'checkbox',
				'label' => __( 'Enable review reply', 'um-reviews' ),
			),
		),
	);

	return $settings;
}
add_filter( 'um_settings_structure', 'um_reviews_settings' );


/**
 * Extend email notifications
 *
 * @param array $email_notifications
 *
 * @return array
 */
function um_reviews_email_notifications( $email_notifications ) {
	$email_notifications['review_notice'] = array(
		'key'            => 'review_notice',
		'title'          => __( 'Reviews - New Review', 'um-reviews' ),
		'subject'        => 'You\'ve got a new {rating} review!',
		'body'           => 'Hi {display_name},<br /><br />' .
							'You\'ve received a new {rating} review from {reviewer}!<br /><br />' .
							'Here is the review content:<br /><br />' .
							'{review_content}<br /><br />' .
							'{reviews_link}<br /><br />' .
							'This is an automated notification from {site_name}. You do not need to reply.',
		'description'    => __( 'Send a notification to user when he receives a new review', 'um-reviews' ),
		'recipient'      => 'user',
		'default_active' => true,
	);

	$email_notifications['review_pending_notice'] = array(
			'key'            => 'review_pending_notice',
			'title'          => __( 'Reviews - New Review is Pending', 'um-reviews' ),
			'subject'        => '[{site_name}] New review is pending',
			'body'           => '{reviewer} has just written a review.<br /><br />' .
								'The review status is "Pending".<br />' .
								'To see and publish this review please click the following link:<br />' .
								'{review_admin_link}<br /><br />' .
								'Here is the review content:<br /><br />' .
								'{review_content}<br /><br />' .
								'This is an automated notification from {site_name}. You do not need to reply.',
			'description'    => __('Send a notification to admin when someone write a review and its status is "Pending"','um-reviews'),
			'recipient'      => 'admin',
			'default_active' => true,
	);

	$email_notifications['review_reply_notice'] = array(
		'key'            => 'review_reply_notice',
		'title'          => __( 'Reviews - New Reply', 'um-reviews' ),
		'subject'        => 'You\'ve got a new reply!',
		'body'           => 'Hi {reviewer},<br /><br />' .
							'You\'ve received a new reply from {user}!<br /><br />' .
							'Here is the reply content:<br /><br />' .
							'{reply_content}<br /><br />' .
							'Here is the review content:<br /><br />' .
							'{review_content}<br /><br />' .
							'{reviews_link}<br /><br />' .
							'This is an automated notification from {site_name}. You do not need to reply.',
		'description'    => __( 'Send a notification to reviewer when user reply for received review', 'um-reviews' ),
		'recipient'      => 'user',
		'default_active' => false,
	);

	$email_notifications['review_report_notice'] = array(
		'key'            => 'review_report_notice',
		'title'          => __( 'Reviews - Review is reported', 'um-reviews' ),
		'subject'        => '[{site_name}] Review was reported',
		'body'           => 'Review was reported.<br /><br />' .
							'To see and check this review please click the following link:<br />' .
							'{flagged_reviews_admin_link}<br /><br />' .
							'This is an automated notification from {site_name}. You do not need to reply.',
		'description'    => __( 'Send a notification to admin when someone report a review and its status is "Flagged"', 'um-reviews' ),
		'recipient'      => 'admin',
		'default_active' => true,
	);

	return $email_notifications;
}
add_filter( 'um_email_notifications', 'um_reviews_email_notifications', 10, 1 );


/**
 * Extend UM:Notifications notifications
 *
 * @param array $notifications_log
 *
 * @return array
 */
function um_reviews_notifications_log( $notifications_log ) {
	$notifications_log['user_review'] = array(
		'title'        => __( 'New user review', 'um-reviews' ),
		'account_desc' => __( 'When someone leaves me a review', 'um-reviews' ),
	);

	return $notifications_log;
}
add_filter( 'um_notifications_core_log_types', 'um_reviews_notifications_log', 10, 1 );


/**
 * Scan templates from extension
 *
 * @param $scan_files
 *
 * @return array
 */
function um_reviews_extend_scan_files( $scan_files ) {
	$extension_files['um-reviews'] = UM()->admin_settings()->scan_template_files( um_reviews_path . '/templates/' );
	$scan_files                    = array_merge( $scan_files, $extension_files );

	return $scan_files;
}
add_filter( 'um_override_templates_scan_files', 'um_reviews_extend_scan_files', 10, 1 );


/**
 * Get template paths
 *
 * @param $located
 * @param $file
 *
 * @return array
 */
function um_reviews_get_path_template( $located, $file ) {
	if ( file_exists( get_stylesheet_directory() . '/ultimate-member/um-reviews/' . $file ) ) {
		$located = array(
			'theme' => get_stylesheet_directory() . '/ultimate-member/um-reviews/' . $file,
			'core'  => um_reviews_path . 'templates/' . $file,
		);
	}

	return $located;
}
add_filter( 'um_override_templates_get_template_path__um-reviews', 'um_reviews_get_path_template', 10, 2 );
