<?php
/**
 * Plugin Name: Ultimate Member - Profile Completeness
 * Plugin URI: http://ultimatemember.com/extensions/profile-completeness
 * Description: Add a robust profile completeness to your community.
 * Version: 2.3.2
 * Author: Ultimate Member
 * Author URI: http://ultimatemember.com/
 * Text Domain: um-profile-completeness
 * Domain Path: /languages
 * Requires at least: 5.5
 * Requires PHP: 5.6
 * Requires Plugins: ultimate-member
 * UM version: 2.9.0
 *
 * @package UM_Profile_Completeness
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once ABSPATH . 'wp-admin/includes/plugin.php';

$plugin_data = get_plugin_data( __FILE__, true, false );

define( 'um_profile_completeness_url', plugin_dir_url( __FILE__ ) );
define( 'um_profile_completeness_path', plugin_dir_path( __FILE__ ) );
define( 'um_profile_completeness_plugin', plugin_basename( __FILE__ ) );
define( 'um_profile_completeness_extension', $plugin_data['Name'] );
define( 'um_profile_completeness_version', $plugin_data['Version'] );
define( 'um_profile_completeness_textdomain', 'um-profile-completeness' );

define( 'um_profile_completeness_requires', '2.9.0' );

function um_profile_completeness_plugins_loaded() {
	$locale = ( get_locale() != '' ) ? get_locale() : 'en_US';
	load_textdomain( um_profile_completeness_textdomain, WP_LANG_DIR . '/plugins/' . um_profile_completeness_textdomain . '-' . $locale . '.mo' );
	load_plugin_textdomain( um_profile_completeness_textdomain, false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'um_profile_completeness_plugins_loaded', 0 );

add_action( 'plugins_loaded', 'um_profile_completeness_check_dependencies', -20 );

if ( ! function_exists( 'um_profile_completeness_check_dependencies' ) ) {
	function um_profile_completeness_check_dependencies() {
		if ( ! defined( 'um_path' ) || ! file_exists( um_path  . 'includes/class-dependencies.php' ) ) {
			//UM is not installed
			function um_profile_completeness_dependencies() {
				// translators: %s is the Profile Completeness extension name.
				echo '<div class="error"><p>' . sprintf( __( 'The <strong>%s</strong> extension requires the Ultimate Member plugin to be activated to work properly. You can download it <a href="https://wordpress.org/plugins/ultimate-member">here</a>', 'um-profile-completeness' ), um_profile_completeness_extension ) . '</p></div>';
			}

			add_action( 'admin_notices', 'um_profile_completeness_dependencies' );
		} else {

			if ( ! function_exists( 'UM' ) ) {
				require_once um_path . 'includes/class-dependencies.php';
				$is_um_active = um\is_um_active();
			} else {
				$is_um_active = UM()->dependencies()->ultimatemember_active_check();
			}

			if ( ! $is_um_active ) {
				//UM is not active
				function um_profile_completeness_dependencies() {
					// translators: %s is the Profile Completeness extension name.
					echo '<div class="error"><p>' . sprintf( __( 'The <strong>%s</strong> extension requires the Ultimate Member plugin to be activated to work properly. You can download it <a href="https://wordpress.org/plugins/ultimate-member">here</a>', 'um-profile-completeness' ), um_profile_completeness_extension ) . '</p></div>';
				}

				add_action( 'admin_notices', 'um_profile_completeness_dependencies' );

			} elseif ( true !== UM()->dependencies()->compare_versions( um_profile_completeness_requires, um_profile_completeness_version, 'profile-completeness', um_profile_completeness_extension ) ) {
				//UM old version is active
				function um_profile_completeness_dependencies() {
					echo '<div class="error"><p>' . UM()->dependencies()->compare_versions( um_profile_completeness_requires, um_profile_completeness_version, 'profile-completeness', um_profile_completeness_extension ) . '</p></div>';
				}

				add_action( 'admin_notices', 'um_profile_completeness_dependencies' );

				function um_profile_completeness_license_settings( $settings ) {
					$settings['licenses']['fields'][] = array(
						'id'        => 'um_profile_completeness_license_key',
						'label'     => __( 'Profile Completeness License Key', 'um-profile-completeness' ),
						'item_name' => 'Profile Completeness',
						'author'    => 'Ultimate Member',
						'version'   => um_profile_completeness_version,
					);
					return $settings;
				}
				add_filter( 'um_settings_structure', 'um_profile_completeness_license_settings' );
			} else {
				require_once um_profile_completeness_path . 'includes/core/um-profile-completeness-init.php';
			}
		}
	}
}


if ( ! function_exists( 'um_profile_completeness_activation_hook' ) ) {
	function um_profile_completeness_activation_hook() {
		//run setup
		if ( ! class_exists( 'um_ext\um_profile_completeness\core\Profile_Completeness_Setup' ) ) {
			require_once um_profile_completeness_path . 'includes/core/class-profile-completeness-setup.php';
		}

		$profile_completeness = new um_ext\um_profile_completeness\core\Profile_Completeness_Setup();
		$profile_completeness->run_setup();

		//first install
		$version = get_option( 'um_profile_completeness_version' );
		if ( ! $version ) {
			update_option( 'um_profile_completeness_last_version_upgrade', um_profile_completeness_version );
		}

		if ( $version != um_profile_completeness_version ) {
			update_option( 'um_profile_completeness_version', um_profile_completeness_version );
		}
	}
}
register_activation_hook( um_profile_completeness_plugin, 'um_profile_completeness_activation_hook' );
